/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.TimeoutException;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class PromiseTest {
    public static void testGetResultNoTimeout() {
        Promise p = new Promise();
        new ResultSetter(p, 500L).start();
        Object result = p.getResult(0L);
        Assert.assertEquals((Object)Boolean.TRUE, result);
    }

    public static void testGetResultNoTimeout_ResultAlreadySet() {
        Promise p = new Promise();
        new ResultSetter(p, 1L).start();
        Util.sleep(100L);
        Object result = p.getResult(0L);
        Assert.assertEquals((Object)Boolean.TRUE, result);
    }

    @Test(expectedExceptions={TimeoutException.class})
    public static void testGetResultWithTimeout() throws TimeoutException {
        Promise p = new Promise();
        p.getResultWithTimeout(500L);
    }

    public static void testGetResultWithTimeoutNoException() {
        Promise p = new Promise();
        Object ret = p.getResult(500L);
        assert (ret == null);
    }

    public static void testGetResultWithTimeoutAndInterrupt() {
        Promise p = new Promise();
        new Interrupter(Thread.currentThread(), 100L).start();
        Object result = p.getResult(500L);
        assert (result == null);
    }

    public static void testGetResultWithTimeoutAndResultSetter() {
        final Promise p = new Promise();
        Thread t = new Thread(){

            public void run() {
                Util.sleep(500L);
                System.out.println("-- setting promise to \"Bela\"");
                p.setResult("Bela");
            }
        };
        t.start();
        long start = System.currentTimeMillis();
        Object result = p.getResult(100000L);
        long stop = System.currentTimeMillis();
        System.out.println("-- waited for " + (stop - start) + "ms, result is " + result);
        assert (result != null);
        Assert.assertEquals((Object)"Bela", result);
        assert (!p.hasResult()) : "promise was reset after getResult()";
    }

    static class Interrupter
    extends Thread {
        long wait_time = 2000L;
        Thread target = null;

        Interrupter(Thread target, long wait_time) {
            this.target = target;
            this.wait_time = wait_time;
        }

        public void run() {
            Util.sleep(this.wait_time);
            this.target.interrupt();
        }
    }

    static class ResultSetter
    extends Thread {
        long wait_time = 2000L;
        Promise target = null;

        ResultSetter(Promise target, long wait_time) {
            this.target = target;
            this.wait_time = wait_time;
        }

        public void run() {
            Util.sleep(this.wait_time);
            this.target.setResult(Boolean.TRUE);
        }
    }
}

