/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.text.NumberFormat;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnicastContentionTest {
    static final String GROUP = "UnicastContentionTest-Cluster";
    int num_msgs = 10000;
    int size = 1000;
    int num_mbrs = 2;
    int num_threads = 1;
    int MOD = 1000;
    private static NumberFormat f = NumberFormat.getNumberInstance();

    private void start(String props, int num_msgs, int size, int num_mbrs, int num_threads, boolean dump_stats) throws Exception {
        this.num_msgs = num_msgs;
        this.size = size;
        this.num_mbrs = num_mbrs;
        this.num_threads = num_threads;
        this.MOD = num_threads * num_msgs / 10;
        MySender[] senders = new MySender[num_threads];
        JChannel ch = new JChannel(props);
        JmxConfigurator.registerChannel(ch, Util.getMBeanServer(), "jgroups", GROUP, true);
        CountDownLatch latch = new CountDownLatch(1);
        MyReceiver receiver = new MyReceiver(latch);
        ch.setReceiver(receiver);
        ch.connect(GROUP);
        System.out.println("Waiting for " + num_mbrs + " members");
        latch.await();
        View view = ch.getView();
        Address local_addr = ch.getAddress();
        Address dest = UnicastContentionTest.pickNextMember(view, local_addr);
        System.out.println("View is " + view + "\n" + num_threads + " threads are sending " + num_msgs + " messages (of " + size + " bytes) to " + dest);
        for (int i = 0; i < senders.length; ++i) {
            senders[i] = new MySender(dest, ch);
        }
        for (MySender sender : senders) {
            sender.start();
        }
        for (MySender sender : senders) {
            sender.join();
        }
        if (dump_stats) {
            Util.keyPress("enter to dump stats and close channel");
            System.out.println("stats:\n" + UnicastContentionTest.printStats(ch.dumpStats("NAKACK")) + "\n" + UnicastContentionTest.printStats(ch.dumpStats("FC")) + "\n" + UnicastContentionTest.printStats(ch.dumpStats("UNICAST")));
        } else {
            Util.sleep(2000L);
        }
        Util.close((Channel)ch);
    }

    private static String printStats(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append(entry.getKey()).append("\n");
            Map val = (Map)entry.getValue();
            for (Map.Entry tmp : val.entrySet()) {
                sb.append(tmp.getKey()).append("=").append(tmp.getValue()).append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private static Address pickNextMember(View view, Address local_addr) {
        Vector<Address> mbrs = view.getMembers();
        for (Address mbr : mbrs) {
            if (mbr.equals(local_addr)) continue;
            return mbr;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        int num_msgs = 10000;
        int size = 1000;
        int num_mbrs = 2;
        int num_threads = 1;
        String props = null;
        boolean dump_stats = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-num_msgs")) {
                num_msgs = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-size")) {
                size = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-num_mbrs")) {
                num_mbrs = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-num_threads")) {
                num_threads = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-dump_stats")) {
                dump_stats = true;
                continue;
            }
            UnicastContentionTest.help();
            return;
        }
        new UnicastContentionTest().start(props, num_msgs, size, num_mbrs, num_threads, dump_stats);
    }

    private static void help() {
        System.out.println("UnicastStressTest2 [-props properties] [-num_msgs <number of messages to send>] [-size bytes] [-num_mbrs members]");
    }

    static {
        f.setGroupingUsed(false);
        f.setMaximumFractionDigits(2);
    }

    private class MyReceiver
    extends ReceiverAdapter {
        private final CountDownLatch latch;
        private int msgs = 0;
        private long start = 0L;
        private int expected_msgs;

        public MyReceiver(CountDownLatch latch) {
            this.expected_msgs = UnicastContentionTest.this.num_msgs * UnicastContentionTest.this.num_threads;
            this.latch = latch;
        }

        public void receive(Message msg) {
            if (this.start == 0L) {
                this.start = System.currentTimeMillis();
            }
            ++this.msgs;
            if (this.msgs % UnicastContentionTest.this.MOD == 0) {
                System.out.println("-- " + this.msgs + " received");
            }
            if (this.msgs >= this.expected_msgs) {
                long time = System.currentTimeMillis() - this.start;
                double msgs_sec = (double)this.msgs / ((double)time / 1000.0);
                double throughput = msgs_sec * (double)UnicastContentionTest.this.size;
                System.out.println(new StringBuilder("-- received ").append(this.msgs).append(" messages").append(" (" + time + " ms, " + f.format(msgs_sec) + " msgs/sec, " + Util.printBytes(throughput) + "/sec)"));
            }
        }

        public void viewAccepted(View new_view) {
            if (new_view.size() >= UnicastContentionTest.this.num_mbrs) {
                this.latch.countDown();
            }
        }
    }

    private class MySender
    extends Thread {
        final byte[] buf;
        final Address dest;
        final JChannel ch;

        public MySender(Address dest, JChannel ch) {
            this.buf = new byte[UnicastContentionTest.this.size];
            this.dest = dest;
            this.ch = ch;
        }

        public void run() {
            for (int i = 0; i < UnicastContentionTest.this.num_msgs; ++i) {
                Message msg = new Message(this.dest, null, this.buf);
                try {
                    this.ch.send(msg);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

