/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import org.jgroups.tests.perf.MemberInfo;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class Data
implements Streamable {
    static final byte DISCOVERY_REQ = 1;
    static final byte DISCOVERY_RSP = 2;
    static final byte DATA = 3;
    static final byte RESULTS = 4;
    static final byte FINAL_RESULTS = 5;
    static final byte FINAL_RESULTS_OK = 6;
    static final byte START = 7;
    static final byte WARMUP = 8;
    byte type = 0;
    byte[] payload = null;
    boolean sender = false;
    long num_msgs = 0L;
    MemberInfo result = null;
    Map<Object, MemberInfo> results = null;

    public Data() {
    }

    public Data(byte type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void writeTo(DataOutputStream out) throws IOException {
        out.writeByte(this.type);
        if (this.payload != null) {
            out.writeBoolean(true);
            out.writeInt(this.payload.length);
            out.write(this.payload, 0, this.payload.length);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.sender);
        out.writeLong(this.num_msgs);
        Util.writeStreamable(this.result, out);
        if (this.results != null) {
            out.writeBoolean(true);
            out.writeInt(this.results.size());
            for (Map.Entry<Object, MemberInfo> entry : this.results.entrySet()) {
                Object key = entry.getKey();
                MemberInfo val = entry.getValue();
                try {
                    Util.writeObject(key, out);
                }
                catch (Exception e) {
                    throw new IOException("failed to write object " + key);
                }
                Util.writeStreamable(val, out);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        int length;
        this.type = in.readByte();
        if (in.readBoolean()) {
            length = in.readInt();
            this.payload = new byte[length];
            in.readFully(this.payload, 0, length);
        }
        this.sender = in.readBoolean();
        this.num_msgs = in.readLong();
        this.result = (MemberInfo)Util.readStreamable(MemberInfo.class, in);
        if (in.readBoolean()) {
            length = in.readInt();
            this.results = new HashMap<Object, MemberInfo>(length);
            for (int i = 0; i < length; ++i) {
                Object key;
                try {
                    key = Util.readObject(in);
                }
                catch (Exception e) {
                    IOException ex = new IOException("failed to read key");
                    ex.initCause(e);
                    throw ex;
                }
                MemberInfo val = (MemberInfo)Util.readStreamable(MemberInfo.class, in);
                this.results.put(key, val);
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.type);
        if (this.payload != null) {
            out.writeInt(this.payload.length);
            out.write(this.payload, 0, this.payload.length);
        } else {
            out.writeInt(0);
        }
        out.writeBoolean(this.sender);
        out.writeLong(this.num_msgs);
        if (this.results != null) {
            out.writeBoolean(true);
            out.writeObject(this.results);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readByte();
        int len = in.readInt();
        if (len > 0) {
            this.payload = new byte[len];
            in.readFully(this.payload, 0, this.payload.length);
        }
        this.sender = in.readBoolean();
        this.num_msgs = in.readLong();
        boolean results_available = in.readBoolean();
        if (results_available) {
            this.results = (Map)in.readObject();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        switch (this.type) {
            case 1: {
                sb.append("DISCOVERY_REQ");
                break;
            }
            case 2: {
                sb.append("DISCOVERY_RSP");
                break;
            }
            case 3: {
                sb.append("DATA");
                break;
            }
            case 4: {
                sb.append("RESULTS");
                break;
            }
            case 5: {
                sb.append("FINAL_RESULTS");
                break;
            }
            case 6: {
                sb.append("FINAL_RESULTS_OK");
                break;
            }
            case 7: {
                sb.append("START");
                break;
            }
            case 8: {
                sb.append("WARMUP");
                break;
            }
            default: {
                sb.append("<unknown>");
            }
        }
        sb.append("] ");
        return sb.toString();
    }
}

