/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Exchanger;
import org.jgroups.Address;
import org.jgroups.BlockEvent;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Event;
import org.jgroups.ExtendedReceiver;
import org.jgroups.GetStateEvent;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.Receiver;
import org.jgroups.SetStateEvent;
import org.jgroups.StateTransferException;
import org.jgroups.StreamingGetStateEvent;
import org.jgroups.StreamingSetStateEvent;
import org.jgroups.SuspectEvent;
import org.jgroups.TimeoutException;
import org.jgroups.UnblockEvent;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.blocks.MethodCall;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.Promise;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBean(description="JGroups channel")
public class JChannel
extends Channel {
    public static final String DEFAULT_PROTOCOL_STACK = "udp.xml";
    protected String properties = null;
    protected UUID local_addr = null;
    protected String name = null;
    private String cluster_name = null;
    private View my_view = null;
    private final Queue mq = new Queue();
    private ProtocolStack prot_stack = null;
    private final Promise<Boolean> state_promise = new Promise();
    private final Exchanger<StateTransferInfo> applstate_exchanger = new Exchanger();
    @ManagedAttribute(description="Flag indicating whether to receive blocks", writable=true)
    private boolean receive_blocks = false;
    @ManagedAttribute(description="Flag indicating whether to receive this channel's own messages", writable=true)
    private boolean receive_local_msgs = true;
    protected volatile boolean connected = false;
    protected volatile boolean closed = false;
    private boolean state_transfer_supported = false;
    private volatile boolean flush_supported = false;
    protected final Map<String, Object> additional_data = new HashMap<String, Object>();
    protected final ConcurrentMap<String, Object> config = new ConcurrentHashMap<String, Object>();
    protected final Log log = LogFactory.getLog(JChannel.class);
    @ManagedAttribute(description="Collect channel statistics", writable=true)
    protected boolean stats = true;
    protected long sent_msgs = 0L;
    protected long received_msgs = 0L;
    protected long sent_bytes = 0L;
    protected long received_bytes = 0L;
    private final TP.ProbeHandler probe_handler = new MyProbeHandler();

    protected JChannel(boolean no_op) {
    }

    public JChannel() throws ChannelException {
        this(DEFAULT_PROTOCOL_STACK);
    }

    public JChannel(File properties) throws ChannelException {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(Element properties) throws ChannelException {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(URL properties) throws ChannelException {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(String properties) throws ChannelException {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(ProtocolStackConfigurator configurator) throws ChannelException {
        this.init(configurator);
    }

    public JChannel(Object properties) throws ChannelException {
        ProtocolStackConfigurator c;
        if (properties == null) {
            properties = DEFAULT_PROTOCOL_STACK;
        }
        try {
            c = ConfiguratorFactory.getStackConfigurator(properties);
        }
        catch (Exception x) {
            throw new ChannelException("unable to load protocol stack", x);
        }
        this.init(c);
    }

    public JChannel(JChannel ch) throws ChannelException {
        this.init(ch);
        this.receive_blocks = ch.receive_blocks;
        this.receive_local_msgs = ch.receive_local_msgs;
    }

    @Override
    public ProtocolStack getProtocolStack() {
        return this.prot_stack;
    }

    @Override
    protected Log getLog() {
        return this.log;
    }

    @Override
    public String getProperties() {
        String retval;
        String string = retval = this.prot_stack != null ? this.prot_stack.printProtocolSpec(true) : null;
        if (retval != null) {
            this.properties = retval;
        }
        return this.properties;
    }

    public boolean statsEnabled() {
        return this.stats;
    }

    public void enableStats(boolean stats) {
        this.stats = stats;
    }

    @ManagedOperation
    public void resetStats() {
        this.received_bytes = 0L;
        this.sent_bytes = 0L;
        this.received_msgs = 0L;
        this.sent_msgs = 0L;
    }

    @ManagedAttribute
    public long getSentMessages() {
        return this.sent_msgs;
    }

    @ManagedAttribute
    public long getSentBytes() {
        return this.sent_bytes;
    }

    @ManagedAttribute
    public long getReceivedMessages() {
        return this.received_msgs;
    }

    @ManagedAttribute
    public long getReceivedBytes() {
        return this.received_bytes;
    }

    @ManagedAttribute
    public int getNumberOfTasksInTimer() {
        TimeScheduler timer = this.getTimer();
        return timer != null ? timer.size() : -1;
    }

    @ManagedAttribute
    public int getTimerThreads() {
        TimeScheduler timer = this.getTimer();
        return timer != null ? timer.getCorePoolSize() : -1;
    }

    public String dumpTimerQueue() {
        TimeScheduler timer = this.getTimer();
        return timer != null ? timer.dumpTaskQueue() : "<n/a";
    }

    @ManagedOperation
    public String printProtocolSpec(boolean include_properties) {
        ProtocolStack ps = this.getProtocolStack();
        return ps != null ? ps.printProtocolSpec(include_properties) : null;
    }

    @Override
    @ManagedOperation(description="Connects the channel to a group")
    public synchronized void connect(String cluster_name) throws ChannelException {
        this.connect(cluster_name, true);
    }

    @ManagedOperation(description="Connects the channel to a group")
    public synchronized void connect(String cluster_name, boolean useFlushIfPresent) throws ChannelException {
        Event connect_event;
        Object res;
        if (this.connected) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("already connected to " + cluster_name);
            }
            return;
        }
        this.setAddress();
        this.startStack(cluster_name);
        if (cluster_name != null && (res = this.downcall(connect_event = useFlushIfPresent ? new Event(92, cluster_name) : new Event(2, cluster_name))) != null && res instanceof Exception) {
            this.stopStack(true, false);
            this.init();
            throw new ChannelException("connect() failed", (Throwable)res);
        }
        this.connected = true;
        this.notifyChannelConnected(this);
    }

    @Override
    public synchronized void connect(String cluster_name, Address target, String state_id, long timeout) throws ChannelException {
        this.connect(cluster_name, target, state_id, timeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect(String cluster_name, Address target, String state_id, long timeout, boolean useFlushIfPresent) throws ChannelException {
        block11: {
            if (this.connected) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("already connected to " + cluster_name);
                }
                return;
            }
            this.setAddress();
            this.startStack(cluster_name);
            boolean canFetchState = false;
            if (cluster_name == null) {
                return;
            }
            try {
                boolean joinSuccessful;
                Event connect_event = useFlushIfPresent ? new Event(93, cluster_name) : new Event(80, cluster_name);
                Object res = this.downcall(connect_event);
                boolean bl = joinSuccessful = res == null || !(res instanceof Exception);
                if (!joinSuccessful) {
                    this.stopStack(true, false);
                    this.init();
                    throw new ChannelException("connect() failed", (Throwable)res);
                }
                this.connected = true;
                this.notifyChannelConnected(this);
                boolean bl2 = canFetchState = this.getView() != null && this.getView().size() > 1;
                if (!canFetchState) break block11;
                try {
                    boolean stateTransferOk = this.getState(target, state_id, timeout, false);
                    if (!stateTransferOk) {
                        throw new StateTransferException(this.getAddress() + " could not fetch state " + (state_id == null ? "(full)" : state_id) + " from " + (target == null ? "(all)" : target));
                    }
                }
                catch (Exception e) {
                    throw new StateTransferException(this.getAddress() + " could not fetch state " + (state_id == null ? "(full)" : state_id) + " from " + (target == null ? "(all)" : target), e);
                }
            }
            finally {
                if (this.flushSupported() && useFlushIfPresent && (canFetchState || !this.connected)) {
                    this.stopFlush();
                }
            }
        }
    }

    @Override
    @ManagedOperation(description="Disconnects the channel if connected")
    public synchronized void disconnect() {
        if (this.closed) {
            return;
        }
        if (this.connected) {
            if (this.cluster_name != null) {
                Event disconnect_event = new Event(4, this.local_addr);
                this.down(disconnect_event);
            }
            this.connected = false;
            this.stopStack(true, false);
            this.notifyChannelDisconnected(this);
            this.init();
        }
    }

    @Override
    @ManagedOperation(description="Disconnects and destroys the channel")
    public synchronized void close() {
        this._close(true, true);
    }

    @Override
    @ManagedOperation(description="Shuts down the channel without disconnecting")
    @Deprecated
    public synchronized void shutdown() {
        try {
            Util.shutdown(this);
        }
        catch (Exception e) {
            this.log.error("failed shutting down channel " + this.getAddress(), e);
        }
    }

    @Override
    @Deprecated
    public synchronized void open() throws ChannelException {
        if (!this.closed) {
            throw new ChannelException("channel is already open");
        }
        try {
            this.mq.reset();
            String props = this.getProperties();
            this.prot_stack = new ProtocolStack(this, props);
            this.prot_stack.setup();
            this.closed = false;
        }
        catch (Exception e) {
            throw new ChannelException("failed to open channel", e);
        }
    }

    @Override
    @ManagedAttribute
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    @ManagedAttribute
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    @ManagedAttribute
    public int getNumMessages() {
        return this.mq.size();
    }

    @Override
    @ManagedOperation
    public String dumpQueue() {
        return Util.dumpQueue(this.mq);
    }

    @Override
    @ManagedOperation
    public Map<String, Object> dumpStats() {
        Map<String, Long> tmp;
        Map<String, Object> retval = this.prot_stack.dumpStats();
        if (retval != null && (tmp = this.dumpChannelStats()) != null) {
            retval.put("channel", tmp);
        }
        return retval;
    }

    @ManagedOperation
    public Map<String, Object> dumpStats(String protocol_name) {
        return this.prot_stack.dumpStats(protocol_name);
    }

    protected Map<String, Long> dumpChannelStats() {
        HashMap<String, Long> retval = new HashMap<String, Long>();
        retval.put("sent_msgs", this.sent_msgs);
        retval.put("sent_bytes", this.sent_bytes);
        retval.put("received_msgs", this.received_msgs);
        retval.put("received_bytes", this.received_bytes);
        return retval;
    }

    @Override
    @ManagedOperation
    public void send(Message msg) throws ChannelNotConnectedException, ChannelClosedException {
        this.checkClosedOrNotConnected();
        if (msg == null) {
            throw new NullPointerException("msg is null");
        }
        if (this.stats) {
            ++this.sent_msgs;
            this.sent_bytes += (long)msg.getLength();
        }
        this.down(new Event(1, msg));
    }

    @Override
    @ManagedOperation
    public void send(Address dst, Address src, Serializable obj) throws ChannelNotConnectedException, ChannelClosedException {
        this.send(new Message(dst, src, obj));
    }

    @Override
    public Object receive(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
        this.checkClosedOrNotConnected();
        try {
            Event evt = timeout <= 0L ? (Event)this.mq.remove() : (Event)this.mq.remove(timeout);
            Object retval = JChannel.getEvent(evt);
            evt = null;
            return retval;
        }
        catch (QueueClosedException queue_closed) {
            throw new ChannelClosedException();
        }
        catch (TimeoutException t) {
            throw t;
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("exception: " + e);
            }
            return null;
        }
    }

    @Override
    public Object peek(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
        this.checkClosedOrNotConnected();
        try {
            Event evt = timeout <= 0L ? (Event)this.mq.peek() : (Event)this.mq.peek(timeout);
            Object retval = JChannel.getEvent(evt);
            evt = null;
            return retval;
        }
        catch (QueueClosedException queue_closed) {
            if (this.log.isErrorEnabled()) {
                this.log.error("exception: " + queue_closed);
            }
            return null;
        }
        catch (TimeoutException t) {
            return null;
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("exception: " + e);
            }
            return null;
        }
    }

    @Override
    public View getView() {
        return this.closed || !this.connected ? null : this.my_view;
    }

    @ManagedAttribute(name="View")
    public String getViewAsString() {
        View v = this.getView();
        return v != null ? v.toString() : "n/a";
    }

    @ManagedAttribute
    public static String getVersion() {
        return Version.printDescription();
    }

    @Override
    public Address getLocalAddress() {
        return this.getAddress();
    }

    @Override
    public Address getAddress() {
        return this.closed ? null : this.local_addr;
    }

    @ManagedAttribute(name="Address")
    public String getAddressAsString() {
        return this.local_addr != null ? this.local_addr.toString() : "n/a";
    }

    @ManagedAttribute(name="Address (UUID)")
    public String getAddressAsUUID() {
        return this.local_addr != null ? this.local_addr.toStringLong() : null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @ManagedAttribute(writable=true, description="The logical name of this channel. Stays with the channel until the channel is closed")
    public void setName(String name) {
        if (name != null) {
            this.name = name;
            if (this.local_addr != null) {
                UUID.add(this.local_addr, this.name);
            }
        }
    }

    @Override
    public String getChannelName() {
        return this.closed ? null : (!this.connected ? null : this.cluster_name);
    }

    @Override
    @ManagedAttribute(description="Returns cluster name this channel is connected to")
    public String getClusterName() {
        return this.closed ? null : (!this.connected ? null : this.cluster_name);
    }

    @Override
    public void setOpt(int option, Object value) {
        if (this.closed) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("channel is closed; option not set !");
            }
            return;
        }
        switch (option) {
            case 1: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn("option VIEW has been deprecated (it is always true now); this option is ignored");
                break;
            }
            case 2: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn("option SUSPECT has been deprecated (it is always true now); this option is ignored");
                break;
            }
            case 0: {
                if (value instanceof Boolean) {
                    this.receive_blocks = (Boolean)value;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error("option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean");
                break;
            }
            case 4: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn("option GET_STATE_EVENTS has been deprecated (it is always true now); this option is ignored");
                break;
            }
            case 3: {
                if (value instanceof Boolean) {
                    this.receive_local_msgs = (Boolean)value;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error("option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean");
                break;
            }
            case 5: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn("Option AUTO_RECONNECT has been deprecated and is ignored");
                break;
            }
            case 6: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn("Option AUTO_GETSTATE has been deprecated and is ignored");
                break;
            }
            default: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error("option " + Channel.option2String(option) + " not known");
            }
        }
    }

    @Override
    public Object getOpt(int option) {
        switch (option) {
            case 1: {
                return Boolean.TRUE;
            }
            case 0: {
                return this.receive_blocks;
            }
            case 2: {
                return Boolean.TRUE;
            }
            case 5: {
                return false;
            }
            case 6: {
                return false;
            }
            case 4: {
                return Boolean.TRUE;
            }
            case 3: {
                return this.receive_local_msgs ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        if (this.log.isErrorEnabled()) {
            this.log.error("option " + Channel.option2String(option) + " not known");
        }
        return null;
    }

    @Override
    public void blockOk() {
    }

    @Override
    public boolean getState(Address target, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        return this.getState(target, null, timeout);
    }

    @Override
    public boolean getState(Address target, String state_id, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        return this.getState(target, state_id, timeout, true);
    }

    public boolean getState(Address target, String state_id, long timeout, boolean useFlushIfPresent) throws ChannelNotConnectedException, ChannelClosedException {
        Callable<Boolean> flusher = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return Util.startFlush(JChannel.this);
            }
        };
        return this.getState(target, state_id, timeout, useFlushIfPresent ? flusher : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getState(Address target, String state_id, long timeout, Callable<Boolean> flushInvoker) throws ChannelNotConnectedException, ChannelClosedException {
        boolean state_transfer_successfull;
        boolean initiateFlush;
        block12: {
            this.checkClosedOrNotConnected();
            if (!this.state_transfer_supported) {
                throw new IllegalStateException("fetching state will fail as state transfer is not supported. Add one of the STATE_TRANSFER protocols to your protocol configuration");
            }
            if (target == null) {
                target = this.determineCoordinator();
            }
            if (target != null && this.local_addr != null && target.equals(this.local_addr)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("cannot get state from myself (" + target + "): probably the first member");
                }
                return false;
            }
            boolean bl = initiateFlush = this.flushSupported() && flushInvoker != null;
            if (initiateFlush) {
                boolean successfulFlush = false;
                try {
                    successfulFlush = flushInvoker.call();
                }
                catch (Exception e) {
                    successfulFlush = false;
                    return successfulFlush;
                }
                finally {
                    if (successfulFlush) break block12;
                    throw new IllegalStateException("Node " + this.local_addr + " could not flush the cluster for state retrieval");
                }
            }
        }
        this.state_promise.reset();
        StateTransferInfo state_info = new StateTransferInfo(target, state_id, timeout);
        this.down(new Event(19, state_info));
        Boolean b = this.state_promise.getResult(state_info.timeout);
        if (initiateFlush) {
            this.stopFlush();
        }
        boolean bl = state_transfer_successfull = b != null && b != false;
        if (!state_transfer_successfull) {
            this.down(new Event(66));
        }
        return state_transfer_successfull;
    }

    @Override
    public boolean getAllStates(Vector targets, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        throw new UnsupportedOperationException("use getState() instead");
    }

    @Override
    public void returnState(byte[] state) {
        try {
            StateTransferInfo state_info = new StateTransferInfo(null, null, 0L, state);
            this.applstate_exchanger.exchange(state_info);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void returnState(byte[] state, String state_id) {
        try {
            StateTransferInfo state_info = new StateTransferInfo(null, state_id, 0L, state);
            this.applstate_exchanger.exchange(state_info);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Object up(Event evt) {
        block63: {
            type = evt.getType();
            switch (type) {
                case 1: {
                    msg = (Message)evt.getArg();
                    if (this.stats) {
                        ++this.received_msgs;
                        this.received_bytes += (long)msg.getLength();
                    }
                    if (this.receive_local_msgs || this.local_addr == null || msg.getSrc() == null || !this.local_addr.equals(msg.getSrc())) break;
                    return null;
                }
                case 6: {
                    tmp = (View)evt.getArg();
                    if (tmp instanceof MergeView) {
                        this.my_view = new View(tmp.getVid(), tmp.getMembers());
                        break;
                    }
                    this.my_view = tmp;
                    break;
                }
                case 56: {
                    cfg = (Map)evt.getArg();
                    if (cfg == null) break;
                    if (cfg.containsKey("state_transfer")) {
                        this.state_transfer_supported = (Boolean)cfg.get("state_transfer");
                    }
                    if (cfg.containsKey("flush_supported")) {
                        this.flush_supported = (Boolean)cfg.get("flush_supported");
                    }
                    cfg.putAll(cfg);
                    break;
                }
                case 20: {
                    state_info = (StateTransferInfo)evt.getArg();
                    state = state_info.state;
                    try {
                        if (this.up_handler == null) ** GOTO lbl38
                        var8_18 = this.up_handler.up(evt);
                        this.state_promise.setResult(state != null ? Boolean.TRUE : Boolean.FALSE);
                        return var8_18;
                    }
                    catch (Throwable var10_24) {
                        this.state_promise.setResult(state != null ? Boolean.TRUE : Boolean.FALSE);
                        throw var10_24;
                    }
lbl38:
                    // 2 sources

                    if (state == null) ** GOTO lbl56
                    state_id = state_info.state_id;
                    if (this.receiver == null) ** GOTO lbl51
                    try {
                        if (!(this.receiver instanceof ExtendedReceiver) || state_id == null) ** GOTO lbl45
                        ((ExtendedReceiver)this.receiver).setState(state_id, state);
                        ** GOTO lbl56
lbl45:
                        // 1 sources

                        this.receiver.setState(state);
                    }
                    catch (Throwable t) {
                        if (this.log.isWarnEnabled()) {
                            this.log.warn("failed calling setState() in receiver", t);
                        }
                    }
                    ** GOTO lbl56
lbl51:
                    // 1 sources

                    try {
                        this.mq.add(new Event(21, state_info));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
lbl56:
                    // 6 sources

                    this.state_promise.setResult(state != null ? Boolean.TRUE : Boolean.FALSE);
                    break;
                }
                case 73: {
                    this.state_promise.setResult(Boolean.TRUE);
                    break;
                }
                case 71: {
                    sti = (StateTransferInfo)evt.getArg();
                    is = sti.inputStream;
                    if (this.up_handler != null) {
                        return this.up_handler.up(evt);
                    }
                    if (is == null) break;
                    if (this.receiver instanceof ExtendedReceiver) {
                        try {
                            if (sti.state_id == null) {
                                ((ExtendedReceiver)this.receiver).setState(is);
                                break;
                            }
                            ((ExtendedReceiver)this.receiver).setState(sti.state_id, is);
                        }
                        catch (Throwable t) {
                            if (!this.log.isWarnEnabled()) break;
                            this.log.warn("failed calling setState() in receiver", t);
                        }
                        break;
                    }
                    if (this.receiver instanceof Receiver) {
                        if (!this.log.isWarnEnabled()) break;
                        this.log.warn("Channel has STREAMING_STATE_TRANSFER, however, application does not implement ExtendedMessageListener. State is not transfered");
                        Util.close(is);
                        break;
                    }
                    try {
                        this.mq.add(new Event(71, sti));
                    }
                    catch (Exception e) {}
                    break;
                }
                case 91: {
                    return this.local_addr;
                }
            }
            if (this.up_handler != null) {
                return this.up_handler.up(evt);
            }
            switch (type) {
                case 1: {
                    if (this.receiver == null) break;
                    try {
                        this.receiver.receive((Message)evt.getArg());
                    }
                    catch (Throwable t) {
                        if (!this.log.isWarnEnabled()) ** GOTO lbl101
                        this.log.warn("failed calling receive() in receiver", t);
                    }
lbl101:
                    // 3 sources

                    return null;
                }
                case 6: {
                    if (this.receiver == null) break;
                    try {
                        this.receiver.viewAccepted((View)evt.getArg());
                    }
                    catch (Throwable t) {
                        if (!this.log.isWarnEnabled()) ** GOTO lbl110
                        this.log.warn("failed calling viewAccepted() in receiver", t);
                    }
lbl110:
                    // 3 sources

                    return null;
                }
                case 9: {
                    if (this.receiver == null) break;
                    try {
                        this.receiver.suspect((Address)evt.getArg());
                    }
                    catch (Throwable t) {
                        if (!this.log.isWarnEnabled()) ** GOTO lbl119
                        this.log.warn("failed calling suspect() in receiver", t);
                    }
lbl119:
                    // 3 sources

                    return null;
                }
                case 17: {
                    if (this.receiver == null) break;
                    state_info = (StateTransferInfo)evt.getArg();
                    tmp_state = null;
                    state_id = state_info.state_id;
                    try {
                        tmp_state = this.receiver instanceof ExtendedReceiver && state_id != null ? ((ExtendedReceiver)this.receiver).getState(state_id) : this.receiver.getState();
                    }
                    catch (Throwable t) {
                        if (!this.log.isWarnEnabled()) ** GOTO lbl131
                        this.log.warn("failed calling getState() in receiver", t);
                    }
lbl131:
                    // 3 sources

                    return new StateTransferInfo(null, state_id, 0L, tmp_state);
                }
                case 72: {
                    sti = (StateTransferInfo)evt.getArg();
                    os = sti.outputStream;
                    if (this.receiver instanceof ExtendedReceiver) {
                        if (os == null) break;
                        try {
                            if (sti.state_id == null) {
                                ((ExtendedReceiver)this.receiver).getState(os);
                                break;
                            }
                            ((ExtendedReceiver)this.receiver).getState(sti.state_id, os);
                        }
                        catch (Throwable t) {
                            if (!this.log.isWarnEnabled()) break;
                            this.log.warn("failed calling getState() in receiver", t);
                        }
                        break;
                    }
                    if (!(this.receiver instanceof Receiver) || !this.log.isWarnEnabled()) break;
                    this.log.warn("Channel has STREAMING_STATE_TRANSFER, however, application does not implement ExtendedMessageListener. State is not transfered");
                    Util.close(os);
                    break;
                }
                case 10: {
                    if (!this.receive_blocks) {
                        return true;
                    }
                    if (this.receiver == null) break;
                    try {
                        this.receiver.block();
                    }
                    catch (Throwable t) {
                        if (!this.log.isErrorEnabled()) ** GOTO lbl161
                        this.log.error("failed calling block() in receiver", t);
                    }
lbl161:
                    // 3 sources

                    return true;
                }
                case 75: {
                    if (!this.receive_blocks || !(this.receiver instanceof ExtendedReceiver)) ** GOTO lbl170
                    try {
                        ((ExtendedReceiver)this.receiver).unblock();
                    }
                    catch (Throwable t) {
                        if (!this.log.isErrorEnabled()) ** GOTO lbl170
                        this.log.error("failed calling unblock() in receiver", t);
                    }
lbl170:
                    // 4 sources

                    return null;
                }
            }
            if (type == 1 || type == 6 || type == 9 || type == 17 || type == 72 || type == 10 || type == 75) {
                try {
                    this.mq.add(evt);
                }
                catch (QueueClosedException queue_closed) {
                }
                catch (Exception e) {
                    if (!this.log.isWarnEnabled()) break block63;
                    this.log.warn("exception adding event " + evt + " to message queue", e);
                }
            }
        }
        if (type == 17) {
            try {
                return this.applstate_exchanger.exchange(null);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return null;
    }

    @Override
    public void down(Event evt) {
        if (evt == null) {
            return;
        }
        switch (evt.getType()) {
            case 56: {
                try {
                    Map m = (Map)evt.getArg();
                    if (m == null) break;
                    this.additional_data.putAll(m);
                    if (!m.containsKey("additional_data")) break;
                    byte[] tmp = (byte[])m.get("additional_data");
                    if (this.local_addr == null) break;
                    this.local_addr.setAdditionalData(tmp);
                    break;
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break;
                    this.log.error("CONFIG event did not contain a hashmap: " + t);
                }
            }
        }
        this.prot_stack.down(evt);
    }

    @Override
    public Object downcall(Event evt) {
        if (evt == null) {
            return null;
        }
        switch (evt.getType()) {
            case 56: {
                try {
                    Map m = (Map)evt.getArg();
                    if (m == null) break;
                    this.additional_data.putAll(m);
                    if (!m.containsKey("additional_data")) break;
                    byte[] tmp = (byte[])m.get("additional_data");
                    if (this.local_addr == null) break;
                    this.local_addr.setAdditionalData(tmp);
                    break;
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break;
                    this.log.error("CONFIG event did not contain a hashmap: " + t);
                }
            }
        }
        return this.prot_stack.down(evt);
    }

    @ManagedOperation
    public String toString(boolean details) {
        StringBuilder sb = new StringBuilder();
        sb.append("local_addr=").append(this.local_addr).append('\n');
        sb.append("cluster_name=").append(this.cluster_name).append('\n');
        sb.append("my_view=").append(this.my_view).append('\n');
        sb.append("connected=").append(this.connected).append('\n');
        sb.append("closed=").append(this.closed).append('\n');
        sb.append("incoming queue size=").append(this.mq.size()).append('\n');
        if (details) {
            sb.append("receive_blocks=").append(this.receive_blocks).append('\n');
            sb.append("receive_local_msgs=").append(this.receive_local_msgs).append('\n');
            sb.append("state_transfer_supported=").append(this.state_transfer_supported).append('\n');
            sb.append("props=").append(this.getProperties()).append('\n');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void init(ProtocolStackConfigurator configurator) throws ChannelException {
        if (this.log.isInfoEnabled()) {
            this.log.info("JGroups version: 2.8.0.GA");
        }
        String tmp = configurator.getProtocolStackString();
        try {
            Vector<Configurator.ProtocolConfiguration> configs = Configurator.parseConfigurations(tmp);
            for (Configurator.ProtocolConfiguration config : configs) {
                config.substituteVariables();
            }
            tmp = Configurator.printConfigurations(configs);
        }
        catch (Exception e) {
            throw new ChannelException("unable to parse the protocol configuration", e);
        }
        Class<Channel> clazz = Channel.class;
        synchronized (Channel.class) {
            this.prot_stack = new ProtocolStack(this, tmp);
            try {
                this.prot_stack.setup();
                this.properties = tmp;
            }
            catch (Throwable e) {
                throw new ChannelException("unable to setup the protocol stack", e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void init(JChannel ch) throws ChannelException {
        if (ch == null) {
            throw new IllegalArgumentException("channel is null");
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("JGroups version: 2.8.0.GA");
        }
        Class<JChannel> clazz = JChannel.class;
        synchronized (JChannel.class) {
            this.prot_stack = new ProtocolStack(this, null);
            try {
                this.prot_stack.setup(ch.getProtocolStack());
                this.getProperties();
            }
            catch (Throwable e) {
                throw new ChannelException("unable to setup the protocol stack: " + e.getMessage(), e);
            }
            return;
        }
    }

    private void init() {
        if (this.local_addr != null) {
            this.down(new Event(90, this.local_addr));
        }
        this.local_addr = null;
        this.cluster_name = null;
        this.my_view = null;
        this.connected = false;
    }

    private void startStack(String cluster_name) throws ChannelException {
        this.checkClosed();
        if (cluster_name == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("cluster_name is null, assuming unicast channel");
            }
        } else {
            this.cluster_name = cluster_name;
        }
        try {
            this.prot_stack.startStack(cluster_name, this.local_addr);
        }
        catch (Throwable e) {
            throw new ChannelException("failed to start protocol stack", e);
        }
        Vector<Address> t = new Vector<Address>(1);
        t.addElement(this.local_addr);
        this.my_view = new View(this.local_addr, 0L, t);
        TP transport = this.prot_stack.getTransport();
        transport.registerProbeHandler(this.probe_handler);
    }

    protected void setAddress() {
        UUID old_addr = this.local_addr;
        this.local_addr = UUID.randomUUID();
        byte[] buf = (byte[])this.additional_data.get("additional_data");
        if (buf != null) {
            this.local_addr.setAdditionalData(buf);
        }
        if (old_addr != null) {
            this.down(new Event(90, old_addr));
        }
        if (this.name == null || this.name.length() == 0) {
            this.name = Util.generateLocalName();
        }
        if (this.name != null && this.name.length() > 0) {
            UUID.add(this.local_addr, this.name);
        }
        Event evt = new Event(8, this.local_addr);
        this.down(evt);
        if (this.up_handler != null) {
            this.up_handler.up(evt);
        }
    }

    protected void checkClosed() throws ChannelClosedException {
        if (this.closed) {
            throw new ChannelClosedException();
        }
    }

    protected void checkClosedOrNotConnected() throws ChannelNotConnectedException, ChannelClosedException {
        if (this.closed) {
            throw new ChannelClosedException();
        }
        if (!this.connected) {
            throw new ChannelNotConnectedException();
        }
    }

    static Object getEvent(Event evt) {
        if (evt == null) {
            return null;
        }
        switch (evt.getType()) {
            case 1: {
                return evt.getArg();
            }
            case 6: {
                return evt.getArg();
            }
            case 9: {
                return new SuspectEvent(evt.getArg());
            }
            case 10: {
                return new BlockEvent();
            }
            case 75: {
                return new UnblockEvent();
            }
            case 17: {
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                return new GetStateEvent(info.target, info.state_id);
            }
            case 21: {
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                return new SetStateEvent(info.state, info.state_id);
            }
            case 72: {
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                return new StreamingGetStateEvent(info.outputStream, info.state_id);
            }
            case 71: {
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                return new StreamingSetStateEvent(info.inputStream, info.state_id);
            }
        }
        return evt;
    }

    protected void _close(boolean disconnect, boolean close_mq) {
        UUID old_addr = this.local_addr;
        if (this.closed) {
            return;
        }
        if (disconnect) {
            this.disconnect();
        }
        if (close_mq) {
            this.closeMessageQueue(false);
        }
        this.stopStack(true, true);
        this.closed = true;
        this.connected = false;
        this.notifyChannelClosed(this);
        this.init();
        if (old_addr != null) {
            UUID.remove(old_addr);
        }
    }

    protected void stopStack(boolean stop, boolean destroy) {
        if (this.prot_stack != null) {
            block6: {
                try {
                    if (stop) {
                        this.prot_stack.stopStack(this.cluster_name);
                    }
                    if (destroy) {
                        this.prot_stack.destroy();
                    }
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block6;
                    this.log.error("failed destroying the protocol stack", e);
                }
            }
            TP transport = this.prot_stack.getTransport();
            if (transport != null) {
                transport.unregisterProbeHandler(this.probe_handler);
            }
        }
    }

    public final void closeMessageQueue(boolean flush_entries) {
        this.mq.close(flush_entries);
    }

    @Override
    public boolean flushSupported() {
        return this.flush_supported;
    }

    @Override
    public boolean startFlush(boolean automatic_resume) {
        if (!this.flushSupported()) {
            throw new IllegalStateException("Flush is not supported, add pbcast.FLUSH protocol to your configuration");
        }
        boolean successfulFlush = (Boolean)this.downcall(new Event(68));
        if (automatic_resume) {
            this.stopFlush();
        }
        return successfulFlush;
    }

    @Override
    public boolean startFlush(List<Address> flushParticipants, boolean automatic_resume) {
        if (!this.flushSupported()) {
            throw new IllegalStateException("Flush is not supported, add pbcast.FLUSH protocol to your configuration");
        }
        View v = this.getView();
        if (v == null || !v.getMembers().containsAll(flushParticipants)) {
            throw new IllegalArgumentException("Current view " + v + " does not contain all flush participants " + flushParticipants);
        }
        boolean successfulFlush = (Boolean)this.downcall(new Event(68, flushParticipants));
        if (automatic_resume) {
            this.stopFlush(flushParticipants);
        }
        return successfulFlush;
    }

    @Override
    public boolean startFlush(long timeout, boolean automatic_resume) {
        return this.startFlush(automatic_resume);
    }

    @Override
    public void stopFlush() {
        if (!this.flushSupported()) {
            throw new IllegalStateException("Flush is not supported, add pbcast.FLUSH protocol to your configuration");
        }
        this.down(new Event(70));
    }

    @Override
    public void stopFlush(List<Address> flushParticipants) {
        if (!this.flushSupported()) {
            throw new IllegalStateException("Flush is not supported, add pbcast.FLUSH protocol to your configuration");
        }
        this.down(new Event(70, flushParticipants));
    }

    @Override
    public Map<String, Object> getInfo() {
        return new HashMap<String, Object>(this.config);
    }

    @Override
    public void setInfo(String key, Object value) {
        if (key != null) {
            this.config.put(key, value);
        }
    }

    Address determineCoordinator() {
        Vector<Address> mbrs;
        Vector<Address> vector = mbrs = this.my_view != null ? this.my_view.getMembers() : null;
        if (mbrs == null) {
            return null;
        }
        if (!mbrs.isEmpty()) {
            return mbrs.firstElement();
        }
        return null;
    }

    private TimeScheduler getTimer() {
        TP transport;
        if (this.prot_stack != null && (transport = this.prot_stack.getTransport()) != null) {
            return transport.getTimer();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyProbeHandler
    implements TP.ProbeHandler {
        MyProbeHandler() {
        }

        @Override
        public Map<String, String> handleProbe(String ... keys) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            for (String key : keys) {
                int index;
                if (key.startsWith("jmx")) {
                    Map<String, Object> tmp_stats;
                    int index2 = key.indexOf("=");
                    if (index2 > -1) {
                        String value = key.substring(index2 + 1);
                        tmp_stats = JChannel.this.dumpStats(value);
                    } else {
                        tmp_stats = JChannel.this.dumpStats();
                    }
                    map.put("jmx", tmp_stats != null ? Util.mapToString(tmp_stats) : "null");
                    continue;
                }
                if (key.equals("info")) {
                    Map<String, Object> tmp_info = JChannel.this.getInfo();
                    map.put("info", tmp_info != null ? Util.mapToString(tmp_info) : "null");
                }
                if (!key.startsWith("invoke") && !key.startsWith("op") || (index = key.indexOf("=")) == -1) continue;
                try {
                    this.handleOperation(map, key.substring(index + 1));
                }
                catch (Throwable throwable) {
                    JChannel.this.log.error("failed invoking operation " + key.substring(index + 1), throwable);
                }
            }
            map.put("version", "2.8.0.GA, cvs=\"$Id: Version.java,v 1.81 2009/12/01 10:31:13 belaban Exp $\"");
            if (JChannel.this.my_view != null && !map.containsKey("view")) {
                map.put("view", JChannel.this.my_view.toString());
            }
            map.put("local_addr", JChannel.this.getAddressAsString() + " [" + JChannel.this.getAddressAsUUID() + "]");
            PhysicalAddress physical_addr = (PhysicalAddress)JChannel.this.downcall(new Event(87, JChannel.this.local_addr));
            if (physical_addr != null) {
                map.put("physical_addr", physical_addr.toString());
            }
            map.put("cluster", JChannel.this.getClusterName());
            return map;
        }

        @Override
        public String[] supportedKeys() {
            return new String[]{"jmx", "info", "invoke", "op"};
        }

        private void handleOperation(Map<String, String> map, String operation) throws Throwable {
            Object retval;
            int index = operation.indexOf(".");
            if (index == -1) {
                throw new IllegalArgumentException("operation " + operation + " is missing the protocol name");
            }
            String prot_name = operation.substring(0, index);
            Protocol prot = JChannel.this.prot_stack.findProtocol(prot_name);
            if (prot == null) {
                throw new IllegalArgumentException("protocol " + prot_name + " not found");
            }
            int args_index = operation.indexOf("[");
            String method_name = args_index != -1 ? operation.substring(index + 1, args_index).trim() : operation.substring(index + 1).trim();
            String[] args = null;
            if (args_index != -1) {
                int end_index = operation.indexOf("]");
                if (end_index == -1) {
                    throw new IllegalArgumentException("] not found");
                }
                List<String> str_args = Util.parseCommaDelimitedStrings(operation.substring(args_index + 1, end_index));
                Object[] strings = str_args.toArray();
                args = new String[strings.length];
                for (int i = 0; i < strings.length; ++i) {
                    args[i] = (String)strings[i];
                }
            }
            Method method = MethodCall.findMethod(prot.getClass(), method_name, args);
            MethodCall call = new MethodCall(method);
            Object[] converted_args = null;
            if (args != null) {
                converted_args = new Object[args.length];
                Class<?>[] types = method.getParameterTypes();
                for (int i = 0; i < args.length; ++i) {
                    converted_args[i] = MethodCall.convert(args[i], types[i]);
                }
            }
            if ((retval = call.invoke(prot, converted_args)) != null) {
                map.put(prot_name + "." + method_name, retval.toString());
            }
        }
    }
}

