/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.jgroups.blocks.ReplCache;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridInputStream
extends InputStream {
    final ReplCache<String, byte[]> cache;
    final int chunk_size;
    final String name;
    int index = 0;
    int local_index = 0;
    byte[] current_buffer = null;
    boolean end_reached = false;
    static final Log log = LogFactory.getLog(GridInputStream.class);

    public GridInputStream(String name, ReplCache<String, byte[]> cache, int chunk_size) throws FileNotFoundException {
        this.cache = cache;
        this.chunk_size = chunk_size;
        this.name = name;
    }

    public GridInputStream(File file, ReplCache<String, byte[]> cache, int chunk_size) throws FileNotFoundException {
        this(file.getName(), cache, chunk_size);
    }

    @Override
    public int read() throws IOException {
        int bytes_remaining_to_read = this.getBytesRemainingInChunk();
        if (bytes_remaining_to_read == 0) {
            if (this.end_reached) {
                return -1;
            }
            this.current_buffer = this.fetchNextChunk();
            this.local_index = 0;
            if (this.current_buffer == null) {
                return -1;
            }
            if (this.current_buffer.length < this.chunk_size) {
                this.end_reached = true;
            }
            bytes_remaining_to_read = this.getBytesRemainingInChunk();
        }
        byte retval = this.current_buffer[this.local_index++];
        ++this.index;
        return retval;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytes_read = 0;
        while (len > 0) {
            int bytes_remaining_to_read = this.getBytesRemainingInChunk();
            if (bytes_remaining_to_read == 0) {
                if (this.end_reached) {
                    return bytes_read > 0 ? bytes_read : -1;
                }
                this.current_buffer = this.fetchNextChunk();
                this.local_index = 0;
                if (this.current_buffer == null) {
                    return bytes_read > 0 ? bytes_read : -1;
                }
                if (this.current_buffer.length < this.chunk_size) {
                    this.end_reached = true;
                }
                bytes_remaining_to_read = this.getBytesRemainingInChunk();
            }
            int bytes_to_read = Math.min(len, bytes_remaining_to_read);
            System.arraycopy(this.current_buffer, this.local_index, b, off, bytes_to_read);
            this.local_index += bytes_to_read;
            off += bytes_to_read;
            len -= bytes_to_read;
            bytes_read += bytes_to_read;
            this.index += bytes_to_read;
        }
        return bytes_read;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int available() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.index = 0;
        this.local_index = 0;
        this.end_reached = false;
    }

    private int getBytesRemainingInChunk() {
        return this.current_buffer == null ? 0 : this.current_buffer.length - this.local_index;
    }

    private byte[] fetchNextChunk() {
        int chunk_number = this.getChunkNumber();
        String key = this.name + "#" + chunk_number;
        byte[] val = this.cache.get(key);
        if (log.isTraceEnabled()) {
            log.trace("fetching index=" + this.index + ", key=" + key + ": " + (val != null ? val.length + " bytes" : "null"));
        }
        return val;
    }

    private int getChunkNumber() {
        return this.index / this.chunk_size;
    }
}

