/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.File;
import org.jgroups.blocks.GridFile;
import org.jgroups.blocks.ReplCache;

public class GridFileTest {
    public static void main(String[] args) throws Exception {
        GridFile f2;
        String props = "udp.xml";
        String cluster_name = "imfs-cluster";
        int chunk_size = 4000;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-cluster_name")) {
                cluster_name = args[++i];
                continue;
            }
            System.out.println("GridFileTest [-props <JGroups config>] [-cluster_name <cluster name]");
            return;
        }
        ReplCache<String, GridFile.Metadata> cache = new ReplCache<String, GridFile.Metadata>(props, cluster_name);
        cache.start();
        GridFile file = new GridFile("/home/bela/grid", cache, 4000);
        ((File)file).mkdirs();
        System.out.println("file = " + file);
        for (String name : new String[]{"a.txt", "b.txt", "one.log"}) {
            GridFile f22 = new GridFile(file, name, cache, 4000);
            ((File)f22).createNewFile();
        }
        GridFile subdir = new GridFile(file, "docs", cache, 4000);
        ((File)subdir).mkdir();
        for (String name : new String[]{"data.log", "c.txt", "two.log"}) {
            f2 = new GridFile(subdir, name, cache, 4000);
            ((File)f2).createNewFile();
        }
        subdir = new GridFile(file, "src", cache, 4000);
        ((File)subdir).mkdir();
        for (String name : new String[]{"bla.java", "foo.java", "foobar.java"}) {
            f2 = new GridFile(subdir, name, cache, 4000);
            ((File)f2).createNewFile();
        }
        String[] list = ((File)file).list();
        if (list != null) {
            for (String filename : list) {
                System.out.println("file = " + filename);
            }
        }
        cache.stop();
    }
}

