/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Map;
import org.jgroups.Address;
import org.jgroups.util.ResponseCollector;
import org.jgroups.util.Util;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=false)
public class ResponseCollectorTest {
    static final Address a = Util.createRandomAddress();
    static final Address b = Util.createRandomAddress();
    static final Address c = Util.createRandomAddress();

    public static void testAdd() {
        ResponseCollector<Integer> coll = new ResponseCollector<Integer>(a, b, c);
        coll.add(a, 1);
        System.out.println("coll = " + coll);
        assert (coll.size() == 3);
        assert (!coll.hasAllResponses());
        coll.add(c, 3);
        coll.add(b, 2);
        System.out.println("coll = " + coll);
        assert (coll.size() == 3);
        assert (coll.hasAllResponses());
    }

    public static void testAddNonExistentKeys() {
        ResponseCollector<Integer> coll = new ResponseCollector<Integer>(a, b);
        coll.add(a, 1);
        System.out.println("coll = " + coll);
        assert (coll.size() == 2);
        assert (!coll.hasAllResponses());
        coll.add(c, 3);
        coll.add(b, 2);
        System.out.println("coll = " + coll);
        assert (coll.size() == 2);
        assert (coll.hasAllResponses());
    }

    public static void testWaitForAllResponses() {
        final ResponseCollector coll = new ResponseCollector(a, b, c);
        boolean rc = coll.waitForAllResponses(500L);
        assert (!rc);
        new Thread(){

            public void run() {
                coll.add(a, 1);
                Util.sleep(500L);
                coll.add(b, 2);
                coll.add(c, 3);
            }
        }.start();
        rc = coll.waitForAllResponses(5000L);
        System.out.println("coll = " + coll);
        assert (rc);
        assert (coll.hasAllResponses());
    }

    public static void testWaitForAllResponsesAndTimeout() {
        final ResponseCollector coll = new ResponseCollector(a, b, c);
        new Thread(){

            public void run() {
                coll.add(a, 1);
                Util.sleep(1000L);
                coll.add(b, 2);
                Util.sleep(1000L);
                coll.add(c, 3);
            }
        }.start();
        boolean rc = coll.waitForAllResponses(400L);
        System.out.println("coll = " + coll);
        assert (!rc);
        assert (!coll.hasAllResponses()) : "collector had all responses (not expected)";
    }

    public static void testWaitForAllResponsesAndReset() {
        final ResponseCollector coll = new ResponseCollector(a, b, c);
        new Thread(){

            public void run() {
                Util.sleep(1000L);
                coll.add(a, 1);
                coll.reset();
            }
        }.start();
        boolean rc = coll.waitForAllResponses(5000L);
        System.out.println("coll = " + coll);
        assert (rc);
        assert (coll.hasAllResponses());
    }

    public static void testWaitForAllResponsesAndGetResults() throws InterruptedException {
        final ResponseCollector<Integer> coll = new ResponseCollector<Integer>(a, b, c);
        coll.add(a, 1);
        coll.add(b, 2);
        coll.add(c, 3);
        Map results = coll.getResults();
        System.out.println("results = " + results);
        Thread thread = new Thread(){

            public void run() {
                coll.reset();
            }
        };
        thread.start();
        thread.join();
        System.out.println("results = " + results);
        assert (coll.size() == 0);
    }
}

