/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.Set;
import org.jgroups.blocks.Cache;
import org.jgroups.blocks.ReplCache;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridFile
extends File {
    private static final long serialVersionUID = -6729548421029004260L;
    private final ReplCache<String, Metadata> cache;
    private final String name;
    private final int chunk_size;

    public GridFile(String pathname, ReplCache<String, Metadata> cache, int chunk_size) {
        super(pathname);
        this.name = pathname;
        this.cache = cache;
        this.chunk_size = chunk_size;
    }

    public GridFile(String parent, String child, ReplCache<String, Metadata> cache, int chunk_size) {
        super(parent, child);
        this.name = parent + File.separator + child;
        this.cache = cache;
        this.chunk_size = chunk_size;
    }

    public GridFile(File parent, String child, ReplCache<String, Metadata> cache, int chunk_size) {
        super(parent, child);
        this.name = parent.getAbsolutePath() + File.separator + child;
        this.cache = cache;
        this.chunk_size = chunk_size;
    }

    public GridFile(URI uri, ReplCache<String, Metadata> cache, int chunk_size) {
        super(uri);
        this.name = this.getAbsolutePath();
        this.cache = cache;
        this.chunk_size = chunk_size;
    }

    @Override
    public boolean createNewFile() throws IOException {
        if (this.exists()) {
            return false;
        }
        if (!this.checkParentDirs(this.name, false)) {
            return false;
        }
        this.cache.put(this.name, new Metadata(0, System.currentTimeMillis(), this.chunk_size, 1), (short)-1, 0L);
        return true;
    }

    @Override
    public boolean mkdir() {
        try {
            boolean parents_exist = this.checkParentDirs(this.name, false);
            if (!parents_exist) {
                return false;
            }
            this.cache.put(this.name, new Metadata(0, System.currentTimeMillis(), this.chunk_size, 2), (short)-1, 0L);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean mkdirs() {
        try {
            boolean parents_exist = this.checkParentDirs(this.name, true);
            if (!parents_exist) {
                return false;
            }
            this.cache.put(this.name, new Metadata(0, System.currentTimeMillis(), this.chunk_size, 2), (short)-1, 0L);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean exists() {
        return this.cache.get(this.name) != null;
    }

    @Override
    public String[] list() {
        Cache<String, ReplCache.Value<Metadata>> internal_cache = this.cache.getL2Cache();
        Set keys = internal_cache.getInternalMap().keySet();
        if (keys == null) {
            return null;
        }
        String[] retval = new String[keys.size()];
        int index = 0;
        for (String str : keys) {
            retval[index++] = str;
        }
        return retval;
    }

    private boolean checkParentDirs(String path, boolean create_if_absent) throws IOException {
        String[] components = GridFile.components(path);
        if (components == null) {
            return false;
        }
        if (components.length == 1) {
            return true;
        }
        StringBuilder sb = new StringBuilder(File.separator);
        boolean first = true;
        for (int i = 0; i < components.length - 1; ++i) {
            String tmp = components[i];
            if (first) {
                first = false;
            } else {
                sb.append(File.separator);
            }
            sb.append(tmp);
            String comp = sb.toString();
            if (this.exists(comp)) {
                if (!this.isFile(comp)) continue;
                throw new IOException("cannot create " + path + " as component " + comp + " is a file");
            }
            this.cache.put(comp, new Metadata(0, System.currentTimeMillis(), this.chunk_size, 2), (short)-1, 0L);
        }
        return true;
    }

    private static String[] components(String path) {
        if (path == null) {
            return null;
        }
        int index = (path = path.trim()).indexOf(File.separator);
        if (index == 0) {
            path = path.substring(1);
        }
        return path.split(File.separator);
    }

    private boolean exists(String key) {
        return this.cache.get(key) != null;
    }

    private boolean isFile(String key) {
        Metadata val = this.cache.get(key);
        return val.isFile();
    }

    public static class Metadata
    implements Streamable {
        public static final byte FILE = 1;
        public static final byte DIR = 2;
        private int length = 0;
        private long modification_time = 0L;
        private int chunk_size = 0;
        private byte flags = 0;

        public Metadata() {
        }

        public Metadata(int length, long modification_time, int chunk_size, byte flags) {
            this.length = length;
            this.modification_time = modification_time;
            this.chunk_size = chunk_size;
            this.flags = flags;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public long getModificationTime() {
            return this.modification_time;
        }

        public void setModificationTime(long modification_time) {
            this.modification_time = modification_time;
        }

        public int getChunkSize() {
            return this.chunk_size;
        }

        public boolean isFile() {
            return Util.isFlagSet(this.flags, (byte)1);
        }

        public boolean isDirectory() {
            return Util.isFlagSet(this.flags, (byte)2);
        }

        public String toString() {
            return "length=" + this.length + " bytes, modification_time=" + new Date(this.modification_time) + ", chunk_size=" + this.chunk_size + ", type=" + this.getType();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeInt(this.length);
            out.writeLong(this.modification_time);
            out.writeInt(this.chunk_size);
            out.writeByte(this.flags);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.length = in.readInt();
            this.modification_time = in.readLong();
            this.chunk_size = in.readInt();
            this.flags = in.readByte();
        }

        private String getType() {
            if (Util.isFlagSet(this.flags, (byte)1)) {
                return "file";
            }
            if (Util.isFlagSet(this.flags, (byte)2)) {
                return "dir";
            }
            return "n/a";
        }
    }
}

