/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.TP;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Promise;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class ConnectTest
extends ChannelTestBase {
    JChannel channel;
    JChannel coordinator;

    @AfterMethod
    void tearDown() throws Exception {
        Util.close(this.channel, this.coordinator);
    }

    @Test
    public void testConnectAndDisconnect() throws Exception {
        this.channel = this.createChannel(true);
        String GROUP = ConnectTest.getUniqueClusterName("ConnectTest");
        for (int i = 0; i < 5; ++i) {
            System.out.print("Attempt #" + (i + 1));
            this.channel.connect(GROUP);
            System.out.println(": OK");
            this.channel.disconnect();
        }
    }

    @Test
    public void testDisconnectConnectOne() throws Exception {
        this.channel = this.createChannel(true);
        ConnectTest.changeProps(this.channel);
        this.channel.connect("ConnectTest.testgroup-1");
        this.channel.disconnect();
        this.channel.connect("ConnectTest.testgroup-2");
        View view = this.channel.getView();
        assert (view.size() == 1);
        assert (view.containsMember(this.channel.getAddress()));
    }

    @Test
    public void testDisconnectConnectTwo() throws Exception {
        this.coordinator = this.createChannel(true);
        ConnectTest.changeProps(this.coordinator);
        this.coordinator.connect("ConnectTest.testgroup-3");
        ConnectTest.print(this.coordinator, "coordinator");
        View view = this.coordinator.getView();
        System.out.println("-- view for coordinator: " + view);
        assert (view.size() == 1);
        this.channel = this.createChannel(this.coordinator);
        ConnectTest.changeProps(this.channel);
        this.channel.connect("ConnectTest.testgroup-4");
        ConnectTest.print(this.channel, "channel");
        view = this.channel.getView();
        System.out.println("-- view for channel: " + view);
        assert (view.size() == 1);
        this.channel.disconnect();
        this.channel.connect("ConnectTest.testgroup-3");
        ConnectTest.print(this.channel, "channel");
        view = this.channel.getView();
        System.out.println("-- view for channel: " + view);
        assert (view.size() == 2);
        assert (view.containsMember(this.channel.getAddress()));
        assert (view.containsMember(this.coordinator.getAddress()));
    }

    static void print(JChannel ch, String msg) {
        System.out.println(msg + ": name=" + ch.getName() + ", addr=" + ch.getAddress() + ", UUID=" + ch.getAddressAsUUID() + "\nUUID cache:\n" + UUID.printCache() + "\nLogical_addr_cache:\n" + ch.getProtocolStack().getTransport().printLogicalAddressCache());
    }

    @Test
    public void testDisconnectConnectSendTwo() throws Exception {
        Promise<Message> msgPromise = new Promise<Message>();
        this.coordinator = this.createChannel(true);
        ConnectTest.changeProps(this.coordinator);
        this.coordinator.setReceiver(new PromisedMessageListener(msgPromise));
        this.coordinator.connect("ConnectTest.testgroup-5");
        this.channel = this.createChannel(this.coordinator);
        ConnectTest.changeProps(this.channel);
        this.channel.connect("ConnectTest.testgroup-6");
        this.channel.disconnect();
        this.channel.connect("ConnectTest.testgroup-5");
        this.channel.send(new Message(null, null, (Serializable)((Object)"payload")));
        Message msg = msgPromise.getResult(20000L);
        assert (msg != null);
        assert (msg.getObject().equals("payload"));
    }

    private static void changeProps(Channel ch) {
        ProtocolStack stack = ch.getProtocolStack();
        TP transport = stack.getTransport();
        transport.setLogDiscardMessages(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PromisedMessageListener
    extends ReceiverAdapter {
        private final Promise<Message> promise;

        public PromisedMessageListener(Promise<Message> promise) {
            this.promise = promise;
        }

        @Override
        public void receive(Message msg) {
            this.promise.setResult(msg);
        }
    }
}

