/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Membership;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.NAKACK;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Digest;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"stack-dependent"}, sequential=true)
public class OverlappingMergeTest
extends ChannelTestBase {
    private JChannel a;
    private JChannel b;
    private JChannel c;
    private MyReceiver ra;
    private MyReceiver rb;
    private MyReceiver rc;

    @BeforeMethod
    protected void start() throws Exception {
        this.a = this.createChannel(true, 3);
        this.a.setName("A");
        this.ra = new MyReceiver("A", this.a);
        this.a.setReceiver(this.ra);
        this.b = this.createChannel(this.a);
        this.b.setName("B");
        this.rb = new MyReceiver("B", this.b);
        this.b.setReceiver(this.rb);
        this.c = this.createChannel(this.a);
        this.c.setName("C");
        this.rc = new MyReceiver("C", this.c);
        this.c.setReceiver(this.rc);
        OverlappingMergeTest.modifyConfigs(this.a, this.b, this.c);
        this.a.connect("OverlappingMergeTest");
        this.b.connect("OverlappingMergeTest");
        this.c.connect("OverlappingMergeTest");
        View view = this.c.getView();
        assert (view.size() == 3) : "view is " + view;
    }

    @AfterMethod
    protected void stop() throws Exception {
        Util.close(this.c, this.b, this.a);
        this.ra.clear();
        this.rb.clear();
        this.rc.clear();
    }

    public void testRegularMessageSending() throws Exception {
        this.sendAndCheckMessages(5, this.a, this.b, this.c);
    }

    public void testOverlappingMergeWithBC() throws Exception {
        this.sendAndCheckMessages(5, this.a, this.b, this.c);
        View new_view = Util.createView(this.b.getLocalAddress(), 10L, this.b.getLocalAddress(), this.c.getLocalAddress());
        System.out.println("\n ==== Injecting view " + new_view + " into B and C ====");
        OverlappingMergeTest.injectView(new_view, this.b, this.c);
        OverlappingMergeTest.makeCoordinator(this.b);
        assert (Util.isCoordinator(this.a));
        assert (Util.isCoordinator(this.b));
        assert (!Util.isCoordinator(this.c));
        System.out.println("A's view: " + this.a.getView());
        System.out.println("B's view: " + this.b.getView());
        System.out.println("C's view: " + this.c.getView());
        assert (this.a.getView().size() == 3) : "A's view is " + this.a.getView();
        assert (this.b.getView().size() == 2) : "B's view is " + this.b.getView();
        assert (this.c.getView().size() == 2) : "C's view is " + this.c.getView();
        System.out.println("\n==== Sending messages while the cluster is partitioned ====");
        this.sendAndCheckMessages(5, this.a, this.b, this.c);
        System.out.println("\n ==== Digests are:\n" + OverlappingMergeTest.dumpDigests(this.a, this.b, this.c));
        HashMap<Address, View> views = new HashMap<Address, View>();
        views.put(this.a.getAddress(), this.a.getView());
        views.put(this.b.getAddress(), this.b.getView());
        views.put(this.c.getAddress(), this.c.getView());
        Event merge_evt = new Event(14, views);
        JChannel merge_leader = OverlappingMergeTest.determineMergeLeader(this.a, this.b);
        System.out.println("\n==== Injecting a merge event (leader=" + merge_leader.getLocalAddress() + ") ====");
        OverlappingMergeTest.injectMergeEvent(merge_evt, merge_leader);
        System.out.println("\n==== checking views after merge ====:");
        for (int i = 0; i < 10; ++i) {
            if (this.a.getView().size() == 3 && this.b.getView().size() == 3 && this.c.getView().size() == 3) {
                System.out.println("views are correct: all views have a size of 3");
                break;
            }
            System.out.print(".");
            OverlappingMergeTest.runStableProtocol(this.a);
            OverlappingMergeTest.runStableProtocol(this.b);
            OverlappingMergeTest.runStableProtocol(this.c);
            Util.sleep(1000L);
        }
        System.out.println("\n ==== Digests after the merge:\n" + OverlappingMergeTest.dumpDigests(this.a, this.b, this.c));
        View va = this.a.getView();
        View vb = this.b.getView();
        View vc = this.c.getView();
        System.out.println("\nA's view: " + va);
        System.out.println("B's view: " + vb);
        System.out.println("C's view: " + vc);
        assert (va.size() == 3) : "A's view is " + va;
        assert (vb.size() == 3) : "B's view is " + vb;
        assert (vc.size() == 3) : "C's view is " + vc;
        System.out.println("\n==== Sending messages after merge ====");
        this.sendAndCheckMessages(5, this.a, this.b, this.c);
    }

    @Test(enabled=true)
    public void testOverlappingMergeWithABC() throws Exception {
        this.sendAndCheckMessages(5, this.a, this.b, this.c);
        View new_view = Util.createView(this.a.getLocalAddress(), 4L, this.a.getLocalAddress(), this.c.getLocalAddress());
        System.out.println("\n ==== Injecting view " + new_view + " into A ====");
        OverlappingMergeTest.injectView(new_view, this.a);
        OverlappingMergeTest.assertTrue(Util.isCoordinator(this.a));
        OverlappingMergeTest.assertFalse(Util.isCoordinator(this.b));
        OverlappingMergeTest.assertFalse(Util.isCoordinator(this.c));
        System.out.println("A's view: " + this.a.getView());
        System.out.println("B's view: " + this.b.getView());
        System.out.println("C's view: " + this.c.getView());
        OverlappingMergeTest.assertEquals("A's view is " + this.a.getView(), 2, this.a.getView().size());
        OverlappingMergeTest.assertEquals("B's view is " + this.b.getView(), 3, this.b.getView().size());
        OverlappingMergeTest.assertEquals("C's view is " + this.c.getView(), 3, this.c.getView().size());
        HashMap<Address, View> views = new HashMap<Address, View>();
        views.put(this.a.getAddress(), this.a.getView());
        views.put(this.b.getAddress(), this.b.getView());
        views.put(this.c.getAddress(), this.c.getView());
        Event merge_evt = new Event(14, views);
        System.out.println("\n==== Injecting a merge event (leader=" + this.a.getAddress() + ") ====");
        OverlappingMergeTest.injectMergeEvent(merge_evt, this.a);
        System.out.println("\n==== checking views after merge ====:");
        for (int i = 0; i < 10; ++i) {
            if (this.a.getView().size() == 3 && this.b.getView().size() == 3 && this.c.getView().size() == 3) {
                System.out.println("views are correct: all views have a size of 3");
                break;
            }
            System.out.print(".");
            for (JChannel ch : new JChannel[]{this.a, this.b, this.c}) {
                OverlappingMergeTest.runStableProtocol(ch);
            }
            Util.sleep(1000L);
        }
        System.out.println("\n ==== Digests after the merge:\n" + OverlappingMergeTest.dumpDigests(this.a, this.b, this.c));
        View va = this.a.getView();
        View vb = this.b.getView();
        View vc = this.c.getView();
        System.out.println("\nA's view: " + va);
        System.out.println("B's view: " + vb);
        System.out.println("C's view: " + vc);
        OverlappingMergeTest.assertEquals("A's view is " + va, 3, va.size());
        OverlappingMergeTest.assertEquals("B's view is " + vb, 3, vb.size());
        OverlappingMergeTest.assertEquals("C's view is " + vc, 3, vc.size());
        System.out.println("\n==== Sending messages after merge ====");
        this.sendAndCheckMessages(5, this.a, this.b, this.c);
    }

    private static void makeCoordinator(JChannel ch) {
        GMS gms = (GMS)ch.getProtocolStack().findProtocol(GMS.class);
        gms.becomeCoordinator();
    }

    private static String dumpDigests(JChannel ... channels) {
        StringBuilder sb = new StringBuilder();
        for (JChannel ch : channels) {
            sb.append(ch.getLocalAddress()).append(": ");
            NAKACK nakack = (NAKACK)ch.getProtocolStack().findProtocol(NAKACK.class);
            Digest digest = nakack.getDigest();
            sb.append(digest).append("\n");
        }
        return sb.toString();
    }

    private static JChannel determineMergeLeader(JChannel ... coords) {
        Membership tmp = new Membership();
        for (JChannel ch : coords) {
            tmp.add(ch.getLocalAddress());
        }
        tmp.sort();
        Address merge_leader = tmp.elementAt(0);
        for (JChannel ch : coords) {
            if (!ch.getLocalAddress().equals(merge_leader)) continue;
            return ch;
        }
        return null;
    }

    private static void injectView(View view, JChannel ... channels) {
        for (JChannel ch : channels) {
            GMS gms = (GMS)ch.getProtocolStack().findProtocol(GMS.class);
            gms.installView(view);
        }
        for (JChannel ch : channels) {
            MyReceiver receiver = (MyReceiver)ch.getReceiver();
            System.out.println("[" + receiver.name + "] view=" + ch.getView());
        }
    }

    private static void injectMergeEvent(Event evt, JChannel ... channels) {
        for (JChannel ch : channels) {
            GMS gms = (GMS)ch.getProtocolStack().findProtocol(GMS.class);
            gms.up(evt);
        }
    }

    private void sendAndCheckMessages(int num_msgs, JChannel ... channels) throws Exception {
        this.ra.clear();
        this.rb.clear();
        this.rc.clear();
        HashSet<Address> mbrs = new HashSet<Address>(channels.length);
        for (JChannel ch : channels) {
            mbrs.add(ch.getLocalAddress());
        }
        for (JChannel ch : channels) {
            for (int i = 1; i <= 5; ++i) {
                ch.send(null, null, (Serializable)((Object)("#" + i)));
            }
        }
        for (JChannel ch : channels) {
            for (Address dest : mbrs) {
                for (int i = 1; i <= num_msgs; ++i) {
                    ch.send(dest, null, (Serializable)((Object)("#" + i)));
                }
            }
        }
        MyReceiver[] receivers = new MyReceiver[channels.length];
        for (int i = 0; i < channels.length; ++i) {
            receivers[i] = (MyReceiver)channels[i].getReceiver();
        }
        for (JChannel ch : channels) {
            OverlappingMergeTest.runStableProtocol(ch);
        }
        OverlappingMergeTest.checkReceivedMessages(num_msgs, receivers);
    }

    private static void runStableProtocol(JChannel ch) {
        STABLE stable = (STABLE)ch.getProtocolStack().findProtocol(STABLE.class);
        if (stable != null) {
            stable.runMessageGarbageCollection();
        }
    }

    private static void checkReceivedMessages(int num_msgs, MyReceiver ... receivers) {
        List<Message> ucasts;
        int total_unicasts = receivers.length * num_msgs;
        for (int i = 0; i < 30; ++i) {
            boolean all_received = true;
            for (MyReceiver receiver : receivers) {
                List<Message> mcasts = receiver.getMulticasts();
                List<Message> ucasts2 = receiver.getUnicasts();
                int mcasts_received = mcasts.size();
                int ucasts_received = ucasts2.size();
                int total_mcasts = receiver.view.size() * num_msgs;
                if (ucasts_received != total_unicasts || mcasts_received != total_mcasts) {
                    all_received = false;
                    break;
                }
                OverlappingMergeTest.runStableProtocol(receiver.ch);
            }
            if (all_received) break;
            Util.sleep(500L);
        }
        for (MyReceiver receiver : receivers) {
            List<Message> mcasts = receiver.getMulticasts();
            ucasts = receiver.getUnicasts();
            int mcasts_received = mcasts.size();
            int ucasts_received = ucasts.size();
            System.out.println("receiver " + receiver + ": mcasts=" + mcasts_received + ", ucasts=" + ucasts_received);
        }
        for (MyReceiver receiver : receivers) {
            List<Message> mcasts = receiver.getMulticasts();
            ucasts = receiver.getUnicasts();
            int mcasts_received = mcasts.size();
            int ucasts_received = ucasts.size();
            int total_mcasts = receiver.view.size() * num_msgs;
            assert (ucasts_received == total_unicasts) : "(" + receiver.name + ") ucasts: " + OverlappingMergeTest.print(ucasts) + " (expected: " + total_unicasts + ")";
            assert (mcasts_received == total_mcasts) : "(" + receiver.name + ") num_mcasts=" + OverlappingMergeTest.print(mcasts) + " expected: " + total_mcasts + ")";
        }
    }

    private static String print(List<Message> msgs) {
        StringBuilder sb = new StringBuilder();
        for (Message msg : msgs) {
            sb.append(msg.getSrc()).append(": ").append(msg.getObject()).append(" ");
        }
        return sb.toString();
    }

    private static void modifyConfigs(JChannel ... channels) throws Exception {
        for (JChannel ch : channels) {
            ProtocolStack stack = ch.getProtocolStack();
            stack.removeProtocol("MERGE2");
            stack.removeProtocol("FC");
            stack.removeProtocol("VERIFY_SUSPECT");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReceiver
    extends ReceiverAdapter {
        final String name;
        View view = null;
        final JChannel ch;
        final List<Message> mcasts = new ArrayList<Message>(20);
        final List<Message> ucasts = new ArrayList<Message>(20);

        public MyReceiver(String name, JChannel ch) {
            this.name = name;
            this.ch = ch;
        }

        @Override
        public void receive(Message msg) {
            boolean mcast;
            Address dest = msg.getDest();
            boolean bl = mcast = dest == null;
            if (mcast) {
                this.mcasts.add(msg);
            } else {
                this.ucasts.add(msg);
            }
        }

        @Override
        public void viewAccepted(View new_view) {
            this.view = new_view;
        }

        public List<Message> getMulticasts() {
            return this.mcasts;
        }

        public List<Message> getUnicasts() {
            return this.ucasts;
        }

        public void clear() {
            this.mcasts.clear();
            this.ucasts.clear();
        }

        public String toString() {
            return this.name;
        }
    }
}

