/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Enumeration;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class Deadlock2Test
extends ChannelTestBase {
    private String name = "Deadlock2Test";
    private JChannel c1;
    private JChannel c2;

    @AfterMethod
    void cleanup() {
        Util.close(this.c1, this.c2);
    }

    public void testOneChannel() throws Exception {
        this.c1 = this.createChannel(true);
        ServerObject serverObject = new ServerObject("obj1");
        RpcDispatcher disp = new RpcDispatcher((Channel)this.c1, null, null, serverObject);
        serverObject.setRpcDispatcher(disp);
        this.c1.connect(this.name);
        Address localAddress = this.c1.getAddress();
        MethodCall call = new MethodCall("outerMethod", new Object[0], new Class[0]);
        Deadlock2Test.log("calling outerMethod() on all members");
        RspList rspList = disp.callRemoteMethods(null, call, 2, 0L);
        Deadlock2Test.log("results of outerMethod(): " + rspList);
        Assert.assertEquals((int)1, (int)rspList.size());
        Deadlock2Test.assertEquals("outerMethod[innerMethod]", rspList.getValue(localAddress));
        Deadlock2Test.assertTrue(rspList.isReceived(localAddress));
        Deadlock2Test.assertFalse(rspList.isSuspected(localAddress));
    }

    public void testTwoChannels() throws Throwable {
        ServerObject obj2 = null;
        this.c1 = this.createChannel(true);
        ServerObject obj1 = new ServerObject("obj1");
        RpcDispatcher disp1 = new RpcDispatcher((Channel)this.c1, null, null, obj1);
        obj1.setRpcDispatcher(disp1);
        this.c1.connect(this.name);
        this.c2 = this.createChannel(this.c1);
        obj2 = new ServerObject("obj2");
        RpcDispatcher disp2 = new RpcDispatcher((Channel)this.c2, null, null, obj2);
        obj2.setRpcDispatcher(disp2);
        this.c2.connect(this.name);
        Address localAddress2 = this.c2.getAddress();
        MethodCall call = new MethodCall("outerMethod", new Object[0], new Class[0]);
        Deadlock2Test.log("calling outerMethod() on " + localAddress2);
        Object retval = disp1.callRemoteMethod(localAddress2, call, 2, 0L);
        Deadlock2Test.log("results of outerMethod(): " + retval);
    }

    public void testTwoChannelsWithInitialMulticast() throws Exception {
        ServerObject obj2 = null;
        this.c1 = this.createChannel(true);
        ServerObject obj1 = new ServerObject("obj1");
        RpcDispatcher disp1 = new RpcDispatcher((Channel)this.c1, null, null, obj1);
        obj1.setRpcDispatcher(disp1);
        this.c1.connect(this.name);
        this.c2 = this.createChannel(this.c1);
        obj2 = new ServerObject("obj2");
        RpcDispatcher disp2 = new RpcDispatcher((Channel)this.c2, null, null, obj2);
        obj2.setRpcDispatcher(disp2);
        this.c2.connect(this.name);
        Vector<Address> dests = new Vector<Address>();
        dests.add(this.c1.getAddress());
        dests.add(this.c2.getAddress());
        MethodCall call = new MethodCall("outerMethod", new Object[0], new Class[0]);
        Deadlock2Test.log("calling outerMethod() on all members");
        RspList rsps = disp1.callRemoteMethods(dests, call, 2, 0L);
        Deadlock2Test.log("results of outerMethod():\n" + rsps);
        Assert.assertEquals((int)2, (int)rsps.size());
    }

    static void log(String msg) {
        System.out.println("[" + Thread.currentThread() + "] " + msg);
    }

    public static class ServerObject {
        String myName;
        private RpcDispatcher disp;

        public ServerObject(String name) {
            this.myName = name;
        }

        public void setRpcDispatcher(RpcDispatcher rpcDispatcher) {
            this.disp = rpcDispatcher;
        }

        public String outerMethod() {
            Deadlock2Test.log("**** outerMethod() received, calling innerMethod() on all members");
            MethodCall call = new MethodCall("innerMethod", new Object[0], new Class[0]);
            RspList rspList = this.disp.callRemoteMethods(null, call, 2, 0L, false, true);
            Vector<Object> results = rspList.getResults();
            Deadlock2Test.log("results of calling innerMethod():\n" + rspList);
            StringBuilder sb = new StringBuilder("outerMethod[");
            Enumeration<Object> e = results.elements();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                sb.append(s);
                if (!e.hasMoreElements()) continue;
                sb.append(";");
            }
            sb.append("]");
            return sb.toString();
        }

        public static String innerMethod() {
            Deadlock2Test.log("**** innerMethod() received, returning result");
            return "innerMethod";
        }
    }
}

