/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class InterruptTest {
    static final long TIMEOUT = 3000L;
    static final int SLEEP = 1;
    static final int WAIT = 2;
    static final int READ = 3;
    static final int SOCKET_READ = 4;

    static String modeToString(int m) {
        switch (m) {
            case 1: {
                return "SLEEP";
            }
            case 2: {
                return "WAIT";
            }
            case 3: {
                return "READ";
            }
            case 4: {
                return "SOCKET_READ";
            }
        }
        return "<unknown>";
    }

    public static void testSleepInterrupt() {
        SleeperThread thread = new SleeperThread(1);
        InterruptTest.runTest(thread);
    }

    public static void testWaitInterrupt() {
        SleeperThread thread = new SleeperThread(2);
        InterruptTest.runTest(thread);
    }

    static void runTest(SleeperThread thread) {
        System.out.println();
        System.out.println("InterruptTest.runTest(" + InterruptTest.modeToString(thread.getMode()) + "): starting other thread");
        thread.start();
        System.out.println("InterruptTest.runTest(" + InterruptTest.modeToString(thread.getMode()) + "): starting other thread -- done");
        System.out.println("InterruptTest.runTest(" + InterruptTest.modeToString(thread.getMode()) + "): sleeping for " + 3000L + " msecs");
        InterruptTest.sleep(3000L);
        System.out.println("InterruptTest.runTest(" + InterruptTest.modeToString(thread.getMode()) + "): sleeping -- done");
        System.out.println("InterruptTest.runTest(" + InterruptTest.modeToString(thread.getMode()) + "): interrupting other thread");
        thread.interrupt();
        System.out.println("InterruptTest.runTest(" + InterruptTest.modeToString(thread.getMode()) + "): interrupting other thread -- done");
        System.out.println("InterruptTest.runTest(" + InterruptTest.modeToString(thread.getMode()) + "): joining other thread (timeout=" + 3000L + " msecs");
        try {
            thread.join(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("InterruptTest.runTest(" + InterruptTest.modeToString(thread.getMode()) + "): joining other thread -- done");
        System.out.println("InterruptTest.runTest(" + InterruptTest.modeToString(thread.getMode()) + "): thread.isAlive()=" + thread.isAlive());
        assert (!thread.isAlive());
    }

    static void sleep(long msecs) {
        try {
            Thread.sleep(msecs);
        }
        catch (Exception ex) {
            System.err.println("InterruptTest.sleep(): " + ex);
        }
    }

    static class SleeperThread
    extends Thread {
        int mode;
        DatagramSocket sock = null;

        SleeperThread(int mode) {
            this.mode = mode;
        }

        public int getMode() {
            return this.mode;
        }

        public void run() {
            switch (this.mode) {
                case 1: {
                    SleeperThread.runSleep();
                    break;
                }
                case 2: {
                    SleeperThread.runWait();
                    break;
                }
                case 3: {
                    SleeperThread.runRead();
                    break;
                }
                case 4: {
                    this.runSocketRead();
                    break;
                }
            }
        }

        static void runSleep() {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ex) {
                System.err.println("InterruptTest.SleeperThread.runSleep(): " + ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void runWait() {
            Object mutex;
            Object object = mutex = new Object();
            synchronized (object) {
                try {
                    mutex.wait();
                }
                catch (InterruptedException ex) {
                    System.err.println("InterruptTest.SleeperThread.runWait(): " + ex);
                }
            }
        }

        static void runRead() {
            try {
                System.in.read();
            }
            catch (Exception ex) {
                System.err.println("InterruptTest.SleeperThread.runRead(): " + ex);
            }
        }

        void runSocketRead() {
            byte[] buf = new byte[2];
            try {
                this.sock = new DatagramSocket(12345, InetAddress.getLocalHost());
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                this.sock.receive(packet);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }
}

