/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.UpHandler;
import org.jgroups.protocols.PingData;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ping
implements UpHandler {
    Channel channel = null;
    boolean print_all_events = false;

    public Ping(String props, boolean printall) throws Exception {
        this.print_all_events = printall;
        this.channel = new JChannel(props);
        this.channel.setUpHandler(this);
    }

    public void go(String groupname) {
        try {
            this.channel.connect(groupname);
            List responses = (List)this.channel.downcall(new Event(12));
            for (int i = 0; i < responses.size(); ++i) {
                PingData rsp = (PingData)responses.get(i);
                System.out.println("Rsp #" + (i + 1) + ": " + rsp);
            }
            if (!responses.isEmpty()) {
                Ping.verifyCoordinator(responses);
            }
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Ping.go(): " + e);
            System.exit(1);
        }
    }

    static void verifyCoordinator(List<PingData> rsps) {
        Hashtable votes = new Hashtable();
        for (int i = 0; i < rsps.size(); ++i) {
            PingData rsp = rsps.get(i);
            Address coord = rsp.getCoordAddress();
            Address mbr = rsp.getAddress();
            Vector<Address> v = (Vector<Address>)votes.get(coord);
            if (v == null) {
                v = new Vector<Address>();
                votes.put(coord, v);
            }
            if (v.contains(mbr)) continue;
            v.addElement(mbr);
        }
        System.out.println("");
        if (votes.size() > 1) {
            System.err.println("*** Found more than 1 coordinator !");
        }
        Ping.printVotes(votes);
    }

    static void printVotes(Hashtable votes) {
        Enumeration e = votes.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Vector val = (Vector)votes.get(key);
            System.out.println("\n\nCoord: " + key);
            System.out.println("Votes: " + val + '\n');
        }
    }

    public static void main(String[] args) {
        Ping ping = null;
        String groupname = Util.shortName(Util.getHostname());
        boolean printall = false;
        String props = "UDP(mcast_addr=224.0.0.200;mcast_port=7500;ip_ttl=0;ucast_send_buf_size=30000;ucast_recv_buf_size=60000):PING(timeout=5000;num_initial_members=30)";
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                Ping.usage();
                return;
            }
            if ("-printall".equals(args[i])) {
                printall = true;
                continue;
            }
            if ("-group".equals(args[i])) {
                groupname = args[++i];
                continue;
            }
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            Ping.usage();
            return;
        }
        try {
            ping = new Ping(props, printall);
            ping.go(groupname);
        }
        catch (Exception e) {
            System.err.println("Ping.main(): " + e);
            System.exit(0);
        }
    }

    static void usage() {
        System.out.println("Ping [-help] [-group <groupname>] [-props <properties>] [-printall]");
    }

    @Override
    public Object up(Event evt) {
        return null;
    }
}

