/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import org.jgroups.JChannel;
import org.jgroups.blocks.RpcDispatcherAnycastServerObject;
import org.jgroups.tests.ChannelTestBase;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class RpcDispatcherAnycastMultipleCallsTest
extends ChannelTestBase {
    private RpcDispatcherAnycastServerObject[] targets = null;
    static final int NUM = 3;

    @BeforeClass
    public void init() throws Exception {
        this.targets = new RpcDispatcherAnycastServerObject[3];
        String GROUP = "RpcDispatcherAnycastMultipleCallsTest";
        JChannel first_channel = null;
        for (int i = 0; i < 3; ++i) {
            JChannel c;
            JChannel jChannel = c = first_channel == null ? this.createChannel(true, 3) : this.createChannel(first_channel);
            if (first_channel == null) {
                first_channel = c;
            }
            this.targets[i] = new RpcDispatcherAnycastServerObject(c);
            c.connect("RpcDispatcherAnycastMultipleCallsTest");
        }
    }

    @AfterMethod
    protected void tearDown() throws Exception {
        if (this.targets != null) {
            for (int i = 0; i < this.targets.length; ++i) {
                if (this.targets[i] == null) continue;
                this.targets[i].i = 0;
            }
        }
    }

    @AfterClass
    protected void shutdown() throws Exception {
        if (this.targets != null) {
            for (int i = 0; i < this.targets.length; ++i) {
                if (this.targets[i] != null) {
                    this.targets[i].shutdown();
                }
                this.targets[i] = null;
            }
            this.targets = null;
        }
    }

    public void test2InstancesAnycastIncludeSelf() throws Exception {
        this.performTest(true, 2, false);
    }

    public void test3InstancesAnycastIncludeSelf() throws Exception {
        this.performTest(true, 3, false);
    }

    public void test2InstancesMcastIncludeSelf() throws Exception {
        this.performTest(false, 2, false);
    }

    public void test3InstancesMcastIncludeSelf() throws Exception {
        this.performTest(false, 3, false);
    }

    public void test2InstancesAnycastExcludeSelf() throws Exception {
        this.performTest(true, 2, true);
    }

    public void test3InstancesAnycastExcludeSelf() throws Exception {
        this.performTest(true, 3, true);
    }

    public void test2InstancesMcastExcludeSelf() throws Exception {
        this.performTest(false, 2, true);
    }

    public void test3InstancesMcastExcludeSelf() throws Exception {
        this.performTest(false, 3, true);
    }

    private void performTest(boolean useAnycast, int n, boolean excludeSelf) throws Exception {
        for (int i = 0; i < n; ++i) {
            RpcDispatcherAnycastMultipleCallsTest.assertEquals(0, this.targets[i].i);
        }
        int value = 0;
        int[] expectedValues = null;
        if (excludeSelf) {
            expectedValues = new int[n];
            for (int i = 0; i < n; ++i) {
                expectedValues[i] = 0;
            }
        }
        for (int instances = 0; instances < n; ++instances) {
            int i;
            this.targets[instances].callRemote(useAnycast, excludeSelf);
            if (excludeSelf) {
                for (i = 0; i < n; ++i) {
                    if (i == instances) continue;
                    int n2 = i;
                    expectedValues[n2] = expectedValues[n2] + 1;
                }
                for (i = 0; i < n; ++i) {
                    RpcDispatcherAnycastMultipleCallsTest.assertEquals("Failure when invoking call on instance " + instances + ".  Did not reach instance " + i + ".", expectedValues[i], this.targets[i].i);
                }
                continue;
            }
            ++value;
            for (i = 0; i < n; ++i) {
                RpcDispatcherAnycastMultipleCallsTest.assertEquals("Failure when invoking call on instance " + instances + ".  Did not reach instance " + i + ".", value, this.targets[i].i);
            }
        }
    }
}

