/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.TimeoutException;
import org.jgroups.util.AckCollector;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class AckCollectorTest {
    final List list = Arrays.asList("one", "two", "three", "four", "five");

    public void testConstructor() {
        AckCollector ac = new AckCollector(null, this.list);
        System.out.println("AckCollector is " + ac);
        Assert.assertEquals((int)5, (int)ac.size());
    }

    public void testWaitForAllAcksNoTimeout() {
        final AckCollector ac = new AckCollector(null, this.list);
        new Thread(){

            public void run() {
                ac.ack("one");
                System.out.println("AckCollector: " + ac);
                Util.sleep(100L);
                ac.ack("two");
                System.out.println("AckCollector: " + ac);
                Util.sleep(100L);
                ac.ack("three");
                System.out.println("AckCollector: " + ac);
                Util.sleep(100L);
                ac.ack("four");
                System.out.println("AckCollector: " + ac);
                Util.sleep(100L);
                ac.ack("five");
                System.out.println("AckCollector: " + ac);
            }
        }.start();
        ac.waitForAllAcks();
        Assert.assertEquals((int)0, (int)ac.size());
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void testWaitForAllAcksWithTimeoutException() throws TimeoutException {
        AckCollector ac = new AckCollector(null, this.list);
        ac.waitForAllAcks(200L);
    }

    public void testWaitForAllAcksWithTimeout() {
        AckCollector ac;
        block2: {
            ac = new AckCollector(null, this.list);
            new Thread(){

                public void run() {
                    ac.ack("one");
                    System.out.println("AckCollector: " + ac);
                    Util.sleep(100L);
                    ac.ack("two");
                    System.out.println("AckCollector: " + ac);
                    Util.sleep(100L);
                    ac.ack("three");
                    System.out.println("AckCollector: " + ac);
                    Util.sleep(100L);
                    ac.ack("four");
                    System.out.println("AckCollector: " + ac);
                    Util.sleep(100L);
                    ac.ack("five");
                    System.out.println("AckCollector: " + ac);
                }
            }.start();
            try {
                ac.waitForAllAcks(5000L);
            }
            catch (TimeoutException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"we should not get a timeout exception here");
            }
        }
        Assert.assertEquals((int)0, (int)ac.size());
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void testWaitForAllAcksWithTimeoutException2() throws TimeoutException {
        final AckCollector ac = new AckCollector(null, this.list);
        new Thread(){

            public void run() {
                ac.ack("one");
                System.out.println("AckCollector: " + ac);
                Util.sleep(200L);
                ac.ack("two");
                System.out.println("AckCollector: " + ac);
                Util.sleep(200L);
                ac.ack("three");
                System.out.println("AckCollector: " + ac);
                Util.sleep(200L);
                ac.ack("four");
                System.out.println("AckCollector: " + ac);
                Util.sleep(200L);
                ac.ack("five");
                System.out.println("AckCollector: " + ac);
            }
        }.start();
        ac.waitForAllAcks(300L);
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void testReset() throws TimeoutException {
        final AckCollector ac = new AckCollector(null, this.list);
        final List<String> new_list = Arrays.asList("six", "seven", "eight");
        new Thread(){

            public void run() {
                Util.sleep(500L);
                System.out.println("resetting AckCollector");
                ac.reset(new_list);
                System.out.println("reset AckCollector: " + ac);
            }
        }.start();
        System.out.println("initial AckCollector: " + ac);
        ac.waitForAllAcks(1000L);
        System.out.println("new AckCollector: " + ac);
    }

    public void testReset2() throws TimeoutException {
        final AckCollector ac = new AckCollector(null, this.list);
        final List<String> new_list = Arrays.asList("six", "seven", "eight");
        new Thread(){

            public void run() {
                Util.sleep(500L);
                System.out.println("resetting AckCollector");
                ac.reset(new_list);
                System.out.println("reset AckCollector: " + ac);
                Util.sleep(100L);
                ac.ack("six");
                System.out.println("AckCollector: " + ac);
                Util.sleep(100L);
                ac.ack("seven");
                System.out.println("AckCollector: " + ac);
                Util.sleep(100L);
                ac.ack("eight");
                System.out.println("AckCollector: " + ac);
            }
        }.start();
        System.out.println("initial AckCollector: " + ac);
        ac.waitForAllAcks(5000L);
        System.out.println("new AckCollector: " + ac);
    }

    public static void testNullList() throws TimeoutException {
        AckCollector coll = new AckCollector();
        coll.waitForAllAcks(1000L);
    }

    public static void testOneList() throws TimeoutException, UnknownHostException {
        ArrayList<Object> tmp = new ArrayList<Object>();
        Address addr = Util.createRandomAddress();
        tmp.add(addr);
        AckCollector coll = new AckCollector(null, tmp);
        coll.ack(addr);
        coll.waitForAllAcks(1000L);
    }
}

