/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.LinkedList;
import java.util.List;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"stack-dependent"}, sequential=false)
public class ChannelTest
extends ChannelTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicOperations() throws Exception {
        JChannel c1 = this.createChannel(true, 1);
        JChannel c2 = null;
        try {
            c1.connect("testBasicOperations");
            assert (c1.isOpen());
            assert (c1.isConnected());
            assert (c1.getAddress() != null);
            assert (c1.getView() != null);
            assert (c1.getView().getMembers().contains(c1.getAddress()));
            c1.connect("testBasicOperations");
            c1.disconnect();
            assert (!c1.isConnected());
            assert (c1.isOpen());
            assert (c1.getAddress() == null);
            assert (c1.getView() == null);
            assert (c1.getClusterName() == null);
            c1.connect("testBasicOperations");
            c1.close();
            try {
                c1.connect("testBasicOperations");
                throw new IllegalStateException("Should generated exception, and it has NOT");
            }
            catch (Exception e) {
                assert (e instanceof ChannelClosedException);
                assert (!c1.isConnected());
                assert (!c1.isOpen());
                assert (c1.getAddress() == null);
                assert (c1.getView() == null);
                assert (c1.getClusterName() == null);
                c1 = this.createChannel(true, 2);
                c1.connect("testBasicOperations");
                c2 = this.createChannel(c1);
                c2.connect("testBasicOperations");
                Util.sleep(1000L);
                assert (c1.isOpen());
                assert (c1.isConnected());
                assert (c1.getAddress() != null);
                assert (c1.getView() != null);
                assert (c1.getView().getMembers().contains(c1.getAddress()));
                assert (c1.getView().getMembers().contains(c2.getAddress()));
                assert (c2.isOpen());
                assert (c2.isConnected());
                assert (c2.getAddress() != null);
                assert (c2.getView() != null);
                assert (c2.getView().getMembers().contains(c2.getAddress()));
                assert (c2.getView().getMembers().contains(c1.getAddress()));
                c2.close();
                Util.sleep(1000L);
                assert (!c2.isOpen());
                assert (!c2.isConnected());
                assert (c2.getAddress() == null);
                assert (c2.getView() == null);
                assert (c1.isOpen());
                assert (c1.isConnected());
                assert (c1.getAddress() != null);
                assert (c1.getView() != null);
                assert (c1.getView().getMembers().contains(c1.getAddress()));
                assert (!c1.getView().getMembers().contains(c2.getAddress()));
                Util.close(c1, c2);
            }
        }
        catch (Throwable throwable) {
            Util.close(c1, c2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testViewChange() throws Exception {
        JChannel ch1 = this.createChannel(true, 2);
        ViewChecker checker = new ViewChecker(ch1);
        ch1.setReceiver(checker);
        ch1.connect("testViewChange");
        JChannel ch2 = this.createChannel(ch1);
        try {
            ((Channel)ch2).connect("testViewChange");
            ChannelTest.assertTrue(checker.getReason(), checker.isSuccess());
            ((Channel)ch2).close();
            ChannelTest.assertTrue(checker.getReason(), checker.isSuccess());
        }
        catch (Throwable throwable) {
            Util.close(ch1, ch2);
            throw throwable;
        }
        Util.close(ch1, ch2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsConnectedOnFirstViewChange() throws Exception {
        JChannel ch1 = this.createChannel(true, 2);
        JChannel ch2 = this.createChannel(ch1);
        ConnectedChecker tmp = new ConnectedChecker(ch2);
        ch2.setReceiver(tmp);
        try {
            ch1.connect("testIsConnectedOnFirstViewChange");
            ((Channel)ch2).connect("testIsConnectedOnFirstViewChange");
            ChannelTest.assertFalse(tmp.isConnected());
        }
        catch (Throwable throwable) {
            Util.close(ch1, ch2);
            throw throwable;
        }
        Util.close(ch1, ch2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoViewIsReceivedAferDisconnect() throws Exception {
        JChannel ch1 = this.createChannel(true, 2);
        JChannel ch2 = this.createChannel(ch1);
        MyViewChecker ra = new MyViewChecker(ch2);
        ch2.setReceiver(ra);
        try {
            ch1.connect("testNoViewIsReceivedAferDisconnect");
            ((Channel)ch2).connect("testNoViewIsReceivedAferDisconnect");
            Util.sleep(500L);
            ((Channel)ch2).disconnect();
            Util.sleep(1000L);
            assert (!ra.receivedViewWhenDisconnected) : "Received view where not member";
        }
        catch (Throwable throwable) {
            Util.close(ch1, ch2);
            throw throwable;
        }
        Util.close(ch1, ch2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoViewIsReceivedAferClose() throws Exception {
        JChannel ch1 = this.createChannel(true, 2);
        JChannel ch2 = this.createChannel(ch1);
        MyViewChecker ra = new MyViewChecker(ch2);
        ch2.setReceiver(ra);
        try {
            ch1.connect("testNoViewIsReceivedAferClose");
            ((Channel)ch2).connect("testNoViewIsReceivedAferClose");
            Util.sleep(200L);
            ((Channel)ch2).close();
            Util.sleep(1000L);
            assert (!ra.receivedViewWhenDisconnected) : "Received view where not member";
        }
        catch (Throwable throwable) {
            Util.close(ch1, ch2);
            throw throwable;
        }
        Util.close(ch1, ch2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={TimeoutException.class})
    public void testReceiveTimeout() throws Exception, TimeoutException {
        JChannel ch1 = this.createChannel(true, 2);
        try {
            ch1.connect("testReceiveTimeout");
            ch1.receive(1000L);
            ch1.receive(2000L);
        }
        finally {
            Util.close((Channel)ch1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={NullPointerException.class})
    public void testNullMessage() throws Exception {
        JChannel ch1 = this.createChannel(true, 2);
        try {
            ch1.connect("testNullMessage");
            ch1.send(null);
        }
        finally {
            Util.close((Channel)ch1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrdering() throws Exception {
        int NUM = 100;
        JChannel ch = this.createChannel(true, 2);
        MyReceiver receiver = new MyReceiver(100);
        ch.setReceiver(receiver);
        try {
            ch.connect("testOrdering");
            for (int i = 1; i <= 100; ++i) {
                ch.send(new Message(null, null, new Integer(i)));
            }
            receiver.waitForCompletion();
            List<Integer> nums = receiver.getNums();
            ChannelTest.checkMonotonicallyIncreasingNumbers(nums);
        }
        finally {
            Util.close((Channel)ch);
        }
    }

    private static void checkMonotonicallyIncreasingNumbers(List<Integer> nums) {
        int current = -1;
        for (int num : nums) {
            if (current < 0) {
                current = num;
                continue;
            }
            assert (++current == num) : "list is " + nums;
        }
    }

    private static class MyViewChecker
    extends ReceiverAdapter {
        private boolean receivedViewWhenDisconnected;
        private final Channel ch;

        public MyViewChecker(Channel ch) {
            this.ch = ch;
        }

        public void viewAccepted(View new_view) {
            this.receivedViewWhenDisconnected = !new_view.containsMember(this.ch.getAddress());
        }
    }

    private static class ViewChecker
    extends ReceiverAdapter {
        final Channel channel;
        boolean success = true;
        String reason = "";

        public ViewChecker(Channel channel) {
            this.channel = channel;
        }

        public String getReason() {
            return this.reason;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void viewAccepted(View new_view) {
            View view = this.channel.getView();
            String str = "viewAccepted(): channel's view=" + view + "\nreceived view=" + new_view;
            if (view != null && !view.equals(new_view)) {
                this.success = false;
                this.reason = this.reason + str + "\n";
            }
        }
    }

    private static class ConnectedChecker
    extends ReceiverAdapter {
        boolean connected = false;
        final Channel channel;

        public ConnectedChecker(Channel channel) {
            this.channel = channel;
        }

        public boolean isConnected() {
            return this.connected;
        }

        public void viewAccepted(View new_view) {
            this.connected = this.channel.isConnected();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReceiver
    extends ReceiverAdapter {
        final List<Integer> nums = new LinkedList<Integer>();
        final int expected;

        public MyReceiver(int expected) {
            this.expected = expected;
        }

        public List<Integer> getNums() {
            return this.nums;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForCompletion() throws InterruptedException {
            List<Integer> list = this.nums;
            synchronized (list) {
                while (this.nums.size() < this.expected) {
                    this.nums.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receive(Message msg) {
            Integer num = (Integer)msg.getObject();
            List<Integer> list = this.nums;
            synchronized (list) {
                this.nums.add(num);
                if (this.nums.size() >= this.expected) {
                    this.nums.notifyAll();
                }
            }
        }
    }
}

