/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.FD;
import org.jgroups.protocols.FD_ALL;
import org.jgroups.protocols.MERGE2;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.GossipRouter;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Promise;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"stack-independent", "gossip-router"}, sequential=true)
public class TUNNEL_Test
extends ChannelTestBase {
    private JChannel channel;
    private JChannel coordinator;
    private static final String GROUP = "TUNNEL_Test";
    private GossipRouter gossipRouter;
    private static final String props = "tunnel.xml";

    @BeforeClass
    void startRouter() throws Exception {
        String bind_addr = Util.getProperty("jgroups.bind_addr");
        if (bind_addr == null) {
            StackType type = Util.getIpStackType();
            bind_addr = type == StackType.IPv6 ? "::1" : "127.0.0.1";
        }
        this.gossipRouter = new GossipRouter(12001, bind_addr);
        this.gossipRouter.start();
    }

    @AfterClass(alwaysRun=true)
    void stopRouter() throws Exception {
        this.gossipRouter.stop();
    }

    @AfterMethod(alwaysRun=true)
    void tearDown() throws Exception {
        Util.close(this.channel, this.coordinator);
    }

    public void testNullLocalAddress_TUNNEL() throws Exception {
        this.channel = new JChannel(props);
        TUNNEL_Test.setProps(this.channel);
        this.channel.connect(GROUP);
        assert (this.channel.getAddress() != null);
        this.channel.disconnect();
        assert (this.channel.getAddress() == null);
    }

    public void testDisconnectConnectOne_Default() throws Exception {
        this.channel = new JChannel(props);
        TUNNEL_Test.setProps(this.channel);
        this.channel.connect("DisconnectTest.testgroup-1");
        this.channel.disconnect();
        this.channel.connect("DisconnectTest.testgroup-2");
        View view = this.channel.getView();
        assert (view.size() == 1);
        assert (view.containsMember(this.channel.getAddress()));
    }

    public void testDisconnectConnectTwo_Default() throws Exception {
        this.coordinator = new JChannel(props);
        TUNNEL_Test.setProps(this.coordinator);
        this.channel = new JChannel(props);
        TUNNEL_Test.setProps(this.channel);
        this.coordinator.connect(GROUP);
        this.channel.connect("DisconnectTest.testgroup-1");
        this.channel.disconnect();
        this.channel.connect(GROUP);
        View view = this.channel.getView();
        assert (view.size() == 2);
        assert (view.containsMember(this.channel.getAddress()));
        assert (view.containsMember(this.coordinator.getAddress()));
    }

    public void testDisconnectConnectSendTwo_Default() throws Exception {
        Promise<Message> msgPromise = new Promise<Message>();
        this.coordinator = new JChannel(props);
        TUNNEL_Test.setProps(this.coordinator);
        this.coordinator.connect(GROUP);
        this.coordinator.setReceiver(new PromisedMessageListener(msgPromise));
        this.channel = new JChannel(props);
        TUNNEL_Test.setProps(this.channel);
        this.channel.connect("DisconnectTest.testgroup-1");
        this.channel.disconnect();
        this.channel.connect(GROUP);
        this.channel.send(new Message(null, null, (Serializable)((Object)"payload")));
        Message msg = msgPromise.getResult(20000L);
        assert (msg != null);
        assert ("payload".equals(msg.getObject()));
    }

    public void testDisconnectConnectOne_TUNNEL() throws Exception {
        this.channel = new JChannel(props);
        TUNNEL_Test.setProps(this.channel);
        this.channel.connect("DisconnectTest.testgroup-1");
        this.channel.disconnect();
        this.channel.connect("DisconnectTest.testgroup-2");
        View view = this.channel.getView();
        assert (view.size() == 1);
        assert (view.containsMember(this.channel.getAddress()));
    }

    public void testFailureDetection() throws Exception {
        View view;
        this.coordinator = new JChannel(props);
        this.coordinator.setName("coord");
        TUNNEL_Test.setProps(this.coordinator);
        this.coordinator.connect(GROUP);
        this.channel = new JChannel(props);
        this.channel.setName("participant");
        TUNNEL_Test.setProps(this.channel);
        this.channel.connect(GROUP);
        System.out.println("shutting down the participant channel");
        Util.shutdown(this.channel);
        GMS coord_gms = (GMS)this.coordinator.getProtocolStack().findProtocol(GMS.class);
        if (coord_gms != null) {
            coord_gms.setLevel("trace");
        }
        long end_time = System.currentTimeMillis() + 10000L;
        while (System.currentTimeMillis() < end_time && (view = this.coordinator.getView()).size() != 1) {
            Util.sleep(500L);
        }
        view = this.coordinator.getView();
        assert (view.size() == 1) : "coordinator's view is " + view + ", but we expected a view of 1 member";
        if (coord_gms != null) {
            coord_gms.setLevel("warn");
        }
    }

    public void testConnectThree() throws Exception {
        this.coordinator = new JChannel(props);
        TUNNEL_Test.setProps(this.coordinator);
        this.channel = new JChannel(props);
        TUNNEL_Test.setProps(this.channel);
        this.coordinator.connect(GROUP);
        this.channel.connect(GROUP);
        JChannel third = new JChannel(props);
        third.connect(GROUP);
        View view = this.channel.getView();
        assert (this.channel.getView().size() == 3);
        assert (third.getView().size() == 3);
        assert (view.containsMember(this.channel.getAddress()));
        assert (view.containsMember(this.coordinator.getAddress()));
        Util.close((Channel)third);
    }

    public void testDisconnectConnectTwo_TUNNEL() throws Exception {
        this.coordinator = new JChannel(props);
        TUNNEL_Test.setProps(this.coordinator);
        this.coordinator.connect(GROUP);
        this.channel = new JChannel(props);
        TUNNEL_Test.setProps(this.channel);
        this.channel.connect("DisconnectTest.testgroup-1");
        this.channel.disconnect();
        this.channel.connect(GROUP);
        Thread.sleep(1000L);
        View view = this.channel.getView();
        assert (view.size() == 2);
        assert (view.containsMember(this.channel.getAddress()));
        assert (view.containsMember(this.coordinator.getAddress()));
    }

    public void testDisconnectConnectSendTwo_TUNNEL() throws Exception {
        Promise<Message> msgPromise = new Promise<Message>();
        this.coordinator = new JChannel(props);
        TUNNEL_Test.setProps(this.coordinator);
        this.coordinator.connect(GROUP);
        this.coordinator.setReceiver(new PromisedMessageListener(msgPromise));
        this.channel = new JChannel(props);
        TUNNEL_Test.setProps(this.channel);
        this.channel.connect("DisconnectTest.testgroup-1");
        this.channel.disconnect();
        this.channel.connect(GROUP);
        this.channel.send(new Message(null, null, (Serializable)((Object)"payload")));
        Message msg = msgPromise.getResult(20000L);
        assert (msg != null);
        assert ("payload".equals(msg.getObject()));
    }

    private static void setProps(JChannel channel) {
        FD_ALL fd_all;
        FD fd;
        ProtocolStack stack = channel.getProtocolStack();
        MERGE2 merge = (MERGE2)stack.findProtocol(MERGE2.class);
        if (merge != null) {
            merge.setMinInterval(1000L);
            merge.setMaxInterval(3000L);
        }
        if ((fd = (FD)stack.findProtocol(FD.class)) != null) {
            fd.setTimeout(1000L);
            fd.setMaxTries(2);
        }
        if ((fd_all = (FD_ALL)stack.findProtocol(FD_ALL.class)) != null) {
            fd_all.setTimeout(2000L);
            fd_all.setInterval(600L);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PromisedMessageListener
    extends ReceiverAdapter {
        private final Promise<Message> promise;

        public PromisedMessageListener(Promise<Message> promise) {
            this.promise = promise;
        }

        @Override
        public void receive(Message msg) {
            this.promise.setResult(msg);
        }
    }
}

