/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.blocks.ReplicatedHashMap;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"flush"}, sequential=true)
public class ReplicatedHashMapStartupTest
extends ChannelTestBase {
    public void testConcurrentStartup4Members() {
        ArrayList<ReplicatedHashMap<Address, Integer>> channels = new ArrayList<ReplicatedHashMap<Address, Integer>>(4);
        try {
            this.concurrentStartupHelper(channels, 4);
        }
        catch (Exception e) {
            this.log.warn("Exception while running testConcurrentStartup4Members", e);
            for (ReplicatedHashMap replicatedHashMap : channels) {
                replicatedHashMap.stop();
                Util.sleep(1000L);
            }
        }
    }

    public void testConcurrentStartup8Members() {
        ArrayList<ReplicatedHashMap<Address, Integer>> channels = new ArrayList<ReplicatedHashMap<Address, Integer>>(8);
        try {
            this.concurrentStartupHelper(channels, 8);
        }
        catch (Exception e) {
            this.log.warn("Exception while running testConcurrentStartup8Members", e);
            for (ReplicatedHashMap replicatedHashMap : channels) {
                replicatedHashMap.stop();
                Util.sleep(1000L);
            }
        }
    }

    protected void concurrentStartupHelper(List<ReplicatedHashMap<Address, Integer>> channels, int channelCount) throws Exception {
        MyNotification n = new MyNotification();
        JChannel first = null;
        for (int i = 0; i < channelCount; ++i) {
            JChannel c;
            if (i == 0) {
                c = this.createChannel(true, channelCount);
                ReplicatedHashMapStartupTest.modifyGMS(c);
                first = c;
            } else {
                c = this.createChannel(first);
            }
            ReplicatedHashMap map = new ReplicatedHashMap(c);
            channels.add(map);
            map.addNotifier(n);
            map.setBlockingUpdates(true);
        }
        for (ReplicatedHashMap<Address, Integer> map : channels) {
            map.getChannel().connect("ReplicatedHashMapStartupTest");
            map.start(0L);
            map.put(map.getChannel().getAddress(), new Integer(1));
            Util.sleep(100L);
        }
        boolean converged = false;
        int timeoutToConverge = 120;
        for (int counter = 0; counter < timeoutToConverge && !converged; ++counter) {
            ReplicatedHashMap<Address, Integer> map;
            Iterator<ReplicatedHashMap<Address, Integer>> i$ = channels.iterator();
            while (i$.hasNext() && (converged = (map = i$.next()).getChannel().getView().size() == channelCount)) {
            }
            TimeUnit.SECONDS.sleep(1L);
        }
        for (ReplicatedHashMap<Address, Integer> map : channels) {
            Assert.assertEquals((int)map.getChannel().getView().size(), (int)channelCount, (String)"Correct view");
        }
        for (ReplicatedHashMap<Address, Integer> map : channels) {
            map.removeNotifier(n);
        }
        for (ReplicatedHashMap<Address, Integer> map : channels) {
            Assert.assertEquals((int)map.size(), (int)channelCount, (String)"Correct size");
        }
        this.log.info("stopping replicated hash maps...");
        for (ReplicatedHashMap<Address, Integer> map : channels) {
            map.stop();
            Util.sleep(1000L);
        }
    }

    private static void modifyGMS(JChannel c) {
        ProtocolStack stack = c.getProtocolStack();
        GMS gms = (GMS)stack.findProtocol(GMS.class);
        if (gms != null) {
            gms.setLogCollectMessages(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyNotification<K extends Serializable, V extends Serializable>
    implements ReplicatedHashMap.Notification<K, V> {
        private MyNotification() {
        }

        @Override
        public void contentsCleared() {
        }

        @Override
        public void contentsSet(Map<K, V> new_entries) {
        }

        @Override
        public void entryRemoved(K key) {
        }

        @Override
        public void entrySet(K key, V value) {
        }

        @Override
        public void viewChange(View view, Vector<Address> new_mbrs, Vector<Address> old_mbrs) {
            ReplicatedHashMapStartupTest.this.log.info("Got view in ReplicatedHashMap notifier " + view);
        }
    }
}

