/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import org.jgroups.Address;
import org.jgroups.BlockEvent;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.util.Util;
import org.testng.annotations.Test;

@Test(groups={"stack-independent"}, sequential=true)
public class VirtualSynchronyTest {
    private static final String CHANNEL_PROPS = "flush-udp.xml";
    private static final int INITIAL_NUMBER_OF_MEMBERS = 5;
    private int runningTime = 50000;
    private Random r = new Random();

    public void testVSynch() throws Exception {
        long start = System.currentTimeMillis();
        boolean running = true;
        ArrayList<GroupMemberThread> members = new ArrayList<GroupMemberThread>();
        for (int i = 0; i < 5; ++i) {
            GroupMemberThread member = new GroupMemberThread("Member");
            member.start();
            members.add(member);
            Util.sleep(this.getRandomDelayInSeconds(4, 6) * 1000);
        }
        while (running) {
            if (this.r.nextBoolean()) {
                Util.sleep(this.getRandomDelayInSeconds(3, 8) * 1000);
                GroupMemberThread member = new GroupMemberThread("Member");
                member.start();
                members.add(member);
            } else if (members.size() > 1) {
                Util.sleep(this.getRandomDelayInSeconds(3, 8) * 1000);
                GroupMemberThread unluckyBastard = (GroupMemberThread)members.get(this.r.nextInt(members.size()));
                members.remove(unluckyBastard);
                unluckyBastard.setRunning(false);
            }
            running = System.currentTimeMillis() - start <= (long)this.runningTime;
            System.out.println("Running time " + (System.currentTimeMillis() - start) / 1000L + " secs");
        }
        System.out.println("Done, Virtual Synchrony satisfied in all tests ");
    }

    protected int getRandomDelayInSeconds(int from, int to) {
        return from + this.r.nextInt(to - from);
    }

    private static class VSynchPayload
    implements Serializable {
        public ViewId viewId;
        public int msgViewCount;
        public Address member;
        private static final long serialVersionUID = -3684761509882737012L;

        public VSynchPayload(ViewId viewId, int numbreOfMessagesInView, Address a) {
            this.viewId = viewId;
            this.msgViewCount = numbreOfMessagesInView;
            this.member = a;
        }

        public String toString() {
            return "[member=" + this.member + ",viewId=" + this.viewId.getId() + ",msgCount=" + this.msgViewCount + "]";
        }
    }

    private static class GroupMemberThread
    extends Thread {
        JChannel ch = null;
        int numberOfMessagesInView = 0;
        View currentView;
        View prevView;
        List payloads = new ArrayList();
        VSynchPayload payload;
        volatile boolean running = true;
        Random r = new Random();
        int messagesSentPerView = this.r.nextInt(25);

        public GroupMemberThread(String name) {
            super(name);
        }

        public String getAddress() {
            if (this.ch != null && this.ch.isConnected()) {
                return this.ch.getAddress().toString();
            }
            return "disconnected " + this.getName();
        }

        public void setRunning(boolean b) {
            this.running = b;
            System.out.println("Disconnect " + this.getAddress());
            if (this.ch != null) {
                this.ch.close();
            }
        }

        public void run() {
            try {
                this.ch = new JChannel(VirtualSynchronyTest.CHANNEL_PROPS);
                this.ch.connect("vsynchtest");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            while (this.running) {
                Object msgReceived = null;
                try {
                    msgReceived = this.ch.receive(0L);
                    if (!this.running) continue;
                    if (msgReceived instanceof View) {
                        this.gotView(msgReceived);
                    }
                    if (msgReceived instanceof Message) {
                        this.gotMessage(msgReceived);
                    }
                    if (!(msgReceived instanceof BlockEvent)) continue;
                    this.ch.blockOk();
                }
                catch (TimeoutException e) {
                }
                catch (Exception e) {
                    this.ch.close();
                    this.running = false;
                }
            }
        }

        private void gotMessage(Object msgReceived) {
            Message msg = (Message)msgReceived;
            Object m = msg.getObject();
            if (m instanceof VSynchPayload) {
                VSynchPayload pay = (VSynchPayload)m;
                if (this.prevView != null && this.prevView.getVid().equals(pay.viewId)) {
                    boolean receivedAllPayloads;
                    this.payloads.add(pay);
                    boolean bl = receivedAllPayloads = this.payloads.size() == this.prevView.getMembers().size() || this.payloads.size() == this.currentView.getMembers().size();
                    if (receivedAllPayloads) {
                        VSynchPayload first = (VSynchPayload)this.payloads.get(0);
                        ListIterator i = this.payloads.listIterator(1);
                        while (i.hasNext()) {
                            VSynchPayload p = (VSynchPayload)i.next();
                            assert (first.msgViewCount == p.msgViewCount) : "Member " + p + " and " + first + " failed VS";
                        }
                        System.out.println("VS ok, all " + this.payloads.size() + " members in " + this.prevView.getVid() + " view have received " + first.msgViewCount + " messages.\nAll messages sent in " + this.prevView.getVid() + " were delivered in " + this.prevView.getVid());
                    }
                }
            } else if (m instanceof String) {
                assert (this.currentView.getVid().getId() == Long.parseLong((String)m)) : this.ch.getAddress() + " received message from the wrong view. Message sender was " + msg.getSrc();
                ++this.numberOfMessagesInView;
            }
        }

        private void gotView(Object msg) throws ChannelNotConnectedException, ChannelClosedException {
            View tmpView = (View)msg;
            if (this.currentView != null) {
                this.payload = new VSynchPayload(this.currentView.getVid(), this.numberOfMessagesInView, this.ch.getAddress());
                this.ch.send(tmpView.getMembers().get(0), null, this.payload);
            }
            this.numberOfMessagesInView = 0;
            this.payloads.clear();
            this.prevView = this.currentView;
            this.currentView = tmpView;
            for (int i = 0; i < this.messagesSentPerView; ++i) {
                this.ch.send(null, null, (Serializable)((Object)Long.toString(this.currentView.getVid().getId())));
            }
        }
    }
}

