/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.ENCRYPT;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=false)
public class ENCRYPTAsymmetricTest {
    @BeforeClass
    public static void initProvider() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static void testInitNoProperties() throws Exception {
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.init();
        assert ("RSA".equals(encrypt.getAsymAlgorithm()));
        assert (encrypt.getAsymInit() == 512);
        assert ("RSA".equals(encrypt.getKpair().getPublic().getAlgorithm()));
        assert ("X.509".equals(encrypt.getKpair().getPublic().getFormat()));
        assert (encrypt.getKpair().getPublic().getEncoded() != null);
        assert ("AES".equals(encrypt.getSymAlgorithm()));
        assert (encrypt.getSymInit() == 128);
        assert ("AES".equals(encrypt.getDesKey().getAlgorithm()));
        assert ("RAW".equals(encrypt.getDesKey().getFormat()));
        assert (encrypt.getDesKey().getEncoded() != null);
        System.out.println("Provider:" + encrypt.getAsymCipher().getProvider());
        assert (encrypt.getAsymCipher() != null);
        assert (encrypt.getSymDecodingCipher() != null);
        assert (encrypt.getSymEncodingCipher() != null);
    }

    public static void testInitBCAsymProperties() throws Exception {
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.asymAlgorithm = "RSA";
        encrypt.asymProvider = "BC";
        encrypt.init();
        assert ("RSA".equals(encrypt.getAsymAlgorithm()));
        assert (encrypt.getAsymInit() == 512);
        assert ("RSA".equals(encrypt.getKpair().getPublic().getAlgorithm()));
        assert ("X.509".equals(encrypt.getKpair().getPublic().getFormat()));
        assert (encrypt.getKpair().getPublic().getEncoded() != null);
        assert (encrypt.getAsymCipher() != null);
    }

    @Test(expectedExceptions={Exception.class})
    public static void testInitIDEAProperties() throws Exception {
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.symAlgorithm = "IDEA";
        encrypt.symInit = 128;
        encrypt.init();
    }

    public static void testInitAESProperties() throws Exception {
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.symAlgorithm = "AES";
        encrypt.symInit = 128;
        encrypt.init();
        assert ("AES".equals(encrypt.getSymAlgorithm())) : "expected AES but was " + encrypt.getSymAlgorithm();
        Util.assertEquals(128, encrypt.getSymInit());
        Util.assertEquals("AES", encrypt.getDesKey().getAlgorithm());
        Util.assertEquals("RAW", encrypt.getDesKey().getFormat());
        Util.assertNotNull(encrypt.getDesKey().getEncoded());
        Util.assertNotNull(encrypt.getSymDecodingCipher());
        Util.assertNotNull(encrypt.getSymEncodingCipher());
    }

    public static void testViewChangeBecomeKeyserver() throws Exception {
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.init();
        MockAddress tempAddress = new MockAddress("encrypt");
        encrypt.setLocal_addr(tempAddress);
        MockObserver observer = new MockObserver();
        encrypt.setObserver(observer);
        Cipher cipher = encrypt.getSymEncodingCipher();
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.reset();
        digest.update(encrypt.getDesKey().getEncoded());
        String symVersion = new String(digest.digest(), "UTF-8");
        encrypt.keyServer = false;
        Message msg = new Message();
        msg.setBuffer(cipher.doFinal("hello".getBytes()));
        msg.putHeader("encrypt", new ENCRYPT.EncryptHeader(0, symVersion));
        Event evt = new Event(1, msg);
        encrypt.up(evt);
        Util.assertTrue(observer.getUpMessages().isEmpty());
        Vector<Address> tempVector = new Vector<Address>();
        tempVector.add(tempAddress);
        View tempView = new View(new ViewId(tempAddress, 1L), tempVector);
        Event event = new Event(6, tempView);
        encrypt.up(event);
        Message msg2 = new Message();
        msg2.setBuffer(cipher.doFinal("hello2".getBytes()));
        msg2.putHeader("encrypt", new ENCRYPT.EncryptHeader(0, symVersion));
        Event evt2 = new Event(1, msg2);
        encrypt.up(evt2);
        Util.assertEquals(3, observer.getUpMessages().size());
        Event sent = (Event)observer.getUpMessages().get("message1");
        Util.assertEquals("hello", new String(((Message)sent.getArg()).getBuffer()));
        sent = (Event)observer.getUpMessages().get("message2");
        Util.assertEquals("hello2", new String(((Message)sent.getArg()).getBuffer()));
    }

    public static void testViewChangeNewKeyServer() throws Exception {
        ENCRYPT peer = new ENCRYPT();
        peer.init();
        ENCRYPT server = new ENCRYPT();
        server.init();
        server.keyServer = true;
        MockObserver serverObserver = new MockObserver();
        server.setObserver(serverObserver);
        MockAddress serverAddress = new MockAddress("server");
        server.setLocal_addr(serverAddress);
        Vector<Address> serverVector = new Vector<Address>();
        serverVector.add(serverAddress);
        View tempView = new View(new ViewId(serverAddress, 1L), serverVector);
        Event serverEvent = new Event(6, tempView);
        server.up(serverEvent);
        MockAddress peerAddress = new MockAddress("peer");
        peer.setLocal_addr(peerAddress);
        MockObserver peerObserver = new MockObserver();
        peer.setObserver(peerObserver);
        peer.keyServer = false;
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.reset();
        digest.update(server.getDesKey().getEncoded());
        String symVersion = new String(digest.digest(), "UTF-8");
        Cipher cipher = server.getSymEncodingCipher();
        Message msg = new Message();
        msg.setBuffer(cipher.doFinal("hello".getBytes()));
        msg.putHeader("encrypt", new ENCRYPT.EncryptHeader(0, symVersion));
        Event evt = new Event(1, msg);
        peer.up(evt);
        Util.assertTrue(peerObserver.getUpMessages().isEmpty());
        peer.up(serverEvent);
        Util.assertEquals(serverAddress, peer.getKeyServerAddr());
        Event sent = (Event)peerObserver.getDownMessages().get("message0");
        Util.assertEquals(((ENCRYPT.EncryptHeader)((Message)sent.getArg()).getHeader("encrypt")).getType(), (short)1);
        Util.assertEquals(new String(((Message)sent.getArg()).getBuffer()), new String(peer.getKpair().getPublic().getEncoded()));
        server.up(sent);
        Event reply = (Event)serverObserver.getDownMessages().get("message1");
        Util.assertEquals(((ENCRYPT.EncryptHeader)((Message)reply.getArg()).getHeader("encrypt")).getType(), (short)3);
        assert (!peer.getDesKey().equals(server.getDesKey()));
        peer.up(reply);
        Util.assertEquals(peer.getDesKey(), server.getDesKey());
        Message msg2 = new Message();
        msg2.setBuffer(cipher.doFinal("hello2".getBytes()));
        msg2.putHeader("encrypt", new ENCRYPT.EncryptHeader(0, symVersion));
        Event evt2 = new Event(1, msg2);
        peer.up(evt2);
        Util.assertEquals(3, peerObserver.getUpMessages().size());
        Event tempEvt = (Event)peerObserver.getUpMessages().get("message2");
        Util.assertEquals("hello", new String(((Message)tempEvt.getArg()).getBuffer()));
        tempEvt = (Event)peerObserver.getUpMessages().get("message3");
        Util.assertEquals("hello2", new String(((Message)tempEvt.getArg()).getBuffer()));
    }

    public static void testViewChangeNewKeyServerNewKey() throws Exception {
        ENCRYPT peer = new ENCRYPT();
        peer.init();
        ENCRYPT server = new ENCRYPT();
        server.init();
        ENCRYPT peer2 = new ENCRYPT();
        peer2.init();
        server.keyServer = true;
        MockObserver serverObserver = new MockObserver();
        server.setObserver(serverObserver);
        MockAddress serverAddress = new MockAddress("server");
        server.setLocal_addr(serverAddress);
        Vector<Address> serverVector = new Vector<Address>();
        serverVector.add(serverAddress);
        View tempView = new View(new ViewId(serverAddress, 1L), serverVector);
        Event serverEvent = new Event(6, tempView);
        server.up(serverEvent);
        MockAddress peerAddress = new MockAddress("peer");
        peer.setLocal_addr(peerAddress);
        MockObserver peerObserver = new MockObserver();
        peer.setObserver(peerObserver);
        peer.keyServer = false;
        MockAddress peer2Address = new MockAddress("peer2");
        peer2.setLocal_addr(peer2Address);
        MockObserver peer2Observer = new MockObserver();
        peer2.setObserver(peer2Observer);
        peer2.keyServer = false;
        peer2.setKeyServerAddr(serverAddress);
        Message msg = new Message();
        msg.setBuffer("hello".getBytes());
        Event evt = new Event(1, msg);
        server.down(evt);
        Event encEvt = (Event)serverObserver.getDownMessages().get("message1");
        peer.up(encEvt);
        Util.assertTrue(peerObserver.getUpMessages().isEmpty());
        Vector<Address> peerVector = new Vector<Address>();
        peerVector.add(peer2Address);
        View tempPeerView = new View(new ViewId(peer2Address, 1L), peerVector);
        Event event = new Event(6, tempPeerView);
        peer.up(event);
        Util.assertEquals(peer2Address, peer.getKeyServerAddr());
        Event sent = (Event)peerObserver.getDownMessages().get("message0");
        Util.assertEquals(((ENCRYPT.EncryptHeader)((Message)sent.getArg()).getHeader("encrypt")).getType(), (short)1);
        Util.assertEquals(new String(((Message)sent.getArg()).getBuffer()), new String(peer.getKpair().getPublic().getEncoded()));
        Vector<Address> peer2Vector = new Vector<Address>();
        peer2Vector.add(peer2Address);
        View tempPeer2View = new View(new ViewId(peer2Address, 1L), peer2Vector);
        Event event2 = new Event(6, tempPeer2View);
        peer2.up(event2);
        peer2.up(sent);
        Event reply = (Event)peer2Observer.getDownMessages().get("message1");
        Util.assertEquals(((ENCRYPT.EncryptHeader)((Message)reply.getArg()).getHeader("encrypt")).getType(), (short)3);
        assert (!peer.getDesKey().equals(peer2.getDesKey()));
        assert (!server.getDesKey().equals(peer2.getDesKey()));
        peer.up(reply);
        Util.assertEquals(peer.getDesKey(), peer2.getDesKey());
        assert (!server.getDesKey().equals(peer.getDesKey()));
        Message msg2 = new Message();
        msg2.setBuffer("hello2".getBytes());
        Event evt2 = new Event(1, msg2);
        peer2.down(evt2);
        Event Evt2 = (Event)peer2Observer.getDownMessages().get("message2");
        peer.up(Evt2);
        Util.assertEquals(2, peerObserver.getUpMessages().size());
        Event tempEvt = (Event)peerObserver.getUpMessages().get("message2");
        Util.assertEquals("hello2", new String(((Message)tempEvt.getArg()).getBuffer()));
    }

    static class MockAddress
    implements Address {
        private static final long serialVersionUID = -479331506050129599L;
        String name;

        public MockAddress(String name) {
            this.name = name;
        }

        public MockAddress() {
        }

        public boolean isMulticastAddress() {
            return false;
        }

        public int size() {
            return 0;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public int compareTo(Address o) {
            return -1;
        }

        public boolean equals(Object obj) {
            MockAddress address = (MockAddress)obj;
            return address.name.equals(this.name);
        }

        public void writeTo(DataOutputStream out) throws IOException {
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        }
    }

    static class MockObserver
    implements ENCRYPT.Observer {
        private Map upMessages = new HashMap();
        private Map downMessages = new HashMap();
        private int counter = 0;

        MockObserver() {
        }

        private void storeUp(Event evt) {
            this.upMessages.put("message" + this.counter++, evt);
        }

        private void storeDown(Event evt) {
            this.downMessages.put("message" + this.counter++, evt);
        }

        public void up(Event evt) {
            this.storeUp(evt);
        }

        public void setProtocol(Protocol prot) {
        }

        public void passUp(Event evt) {
            this.storeUp(evt);
        }

        public void down(Event evt) {
        }

        public void passDown(Event evt) {
            this.storeDown(evt);
        }

        protected Map getUpMessages() {
            return this.upMessages;
        }

        protected void setUpMessages(Map upMessages) {
            this.upMessages = upMessages;
        }

        protected Map getDownMessages() {
            return this.downMessages;
        }

        protected void setDownMessages(Map downMessages) {
            this.downMessages = downMessages;
        }
    }
}

