/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.protocols.DISCARD_PAYLOAD;
import org.jgroups.stack.Protocol;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"stack-dependent"}, sequential=true)
public class NAKACK_Test
extends ChannelTestBase {
    JChannel c1;
    JChannel c2;
    JChannel c3;

    @BeforeMethod
    public void setUp() throws Exception {
        this.c1 = this.createChannel(true, 3);
        this.c2 = this.createChannel(this.c1);
        this.c3 = this.createChannel(this.c1);
    }

    @AfterMethod
    public void tearDown() throws Exception {
        Util.close(this.c3, this.c2, this.c1);
    }

    @Test
    public void testOutOfBandMessages() throws Exception {
        MyReceiver receiver1 = new MyReceiver();
        MyReceiver receiver2 = new MyReceiver();
        MyReceiver receiver3 = new MyReceiver();
        this.c1.setReceiver(receiver1);
        this.c2.setReceiver(receiver2);
        this.c3.setReceiver(receiver3);
        this.c1.getProtocolStack().insertProtocol((Protocol)new DISCARD_PAYLOAD(), 2, "NAKACK");
        this.c1.connect("NAKACK_OOB_Test");
        this.c2.connect("NAKACK_OOB_Test");
        this.c3.connect("NAKACK_OOB_Test");
        assert (this.c3.getView().getMembers().size() == 3) : "view is " + this.c3.getView() + ", expected view of 3 members";
        for (int i = 1; i <= 5; ++i) {
            Message msg = new Message(null, null, new Long(i));
            if (i == 4) {
                msg.setFlag((byte)1);
            }
            System.out.println("-- sending message #" + i);
            this.c1.send(msg);
            Util.sleep(100L);
        }
        Collection<Long> seqnos1 = receiver1.getSeqnos();
        Collection<Long> seqnos2 = receiver2.getSeqnos();
        Collection<Long> seqnos3 = receiver3.getSeqnos();
        long target_time = System.currentTimeMillis() + 20000L;
        while (seqnos1.size() < 5 || seqnos2.size() < 5 || seqnos3.size() < 5) {
            Util.sleep(500L);
            if (target_time > System.currentTimeMillis()) continue;
        }
        System.out.println("sequence numbers:");
        System.out.println("c1: " + seqnos1);
        System.out.println("c2: " + seqnos2);
        System.out.println("c3: " + seqnos3);
        NAKACK_Test.checkOrder(seqnos1, seqnos2, seqnos3);
    }

    private static void checkOrder(Collection<Long> ... lists) throws Exception {
        for (Collection<Long> list : lists) {
            list.remove(4L);
            long prev_val = 0L;
            for (long val : list) {
                if (val <= prev_val) {
                    throw new Exception("elements are not ordered in list: " + list);
                }
                prev_val = val;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyReceiver
    extends ReceiverAdapter {
        Collection<Long> seqnos = new ConcurrentLinkedQueue<Long>();

        public Collection<Long> getSeqnos() {
            return this.seqnos;
        }

        @Override
        public void receive(Message msg) {
            if (msg != null) {
                Long num = (Long)msg.getObject();
                this.seqnos.add(num);
            }
        }

        public int size() {
            return this.seqnos.size();
        }
    }
}

