/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.debug.Simulator;
import org.jgroups.protocols.pbcast.NAKACK;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Digest;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.UUID;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class NakackTest {
    static final int NUM_PEERS = 3;
    static final int NUM_MSGS = 1000;
    static final int WAIT_TIMEOUT = 10;
    static final int MSGS_PER_STATUS_LINE = 100;
    static boolean notFIFO = false;
    static boolean allMsgsReceived = false;
    Address[] addresses = new Address[3];
    Vector<Address> members = null;
    View view;
    Simulator[] simulators = new Simulator[3];
    NAKACK[] layers = new NAKACK[3];
    Protocol[][] stacks = new Protocol[3][];
    Thread[] threads = new Thread[3];
    boolean[] isSender = new boolean[3];
    static final Object all_msgs_recd = new Object();

    @BeforeMethod
    public void setUp() throws Exception {
        int i;
        int i2;
        this.isSender[0] = false;
        this.isSender[1] = true;
        this.isSender[2] = true;
        for (i2 = 0; i2 < this.addresses.length; ++i2) {
            UUID uuid = UUID.randomUUID();
            UUID.add(uuid, "node-" + i2);
            this.addresses[i2] = uuid;
        }
        this.members = new Vector();
        this.members.addAll(Arrays.asList(this.addresses).subList(0, 3));
        this.view = new View(this.addresses[0], 1L, this.members);
        for (i2 = 0; i2 < 3; ++i2) {
            this.simulators[i2] = new Simulator();
            this.simulators[i2].setLocalAddress(this.addresses[i2]);
            this.simulators[i2].setView(this.view);
            this.layers[i2] = new NAKACK();
            this.layers[i2].setUseMcastXmit(true);
            this.stacks[i2] = new Protocol[]{this.layers[i2]};
            this.simulators[i2].setProtocolStack(this.stacks[i2]);
        }
        for (i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 3; ++j) {
                if (i2 == j) {
                    this.simulators[i2].addMember(this.addresses[j]);
                    continue;
                }
                this.simulators[i2].addMember(this.addresses[j], this.simulators[j]);
            }
        }
        Simulator.Receiver[] receivers = new Simulator.Receiver[3];
        for (i = 0; i < 3; ++i) {
            receivers[i] = this.isSender[i] ? new SenderPeer(this.simulators[i]) : new ReceiverPeer(this.simulators[i]);
            this.simulators[i].setReceiver(receivers[i]);
        }
        for (i = 0; i < 3; ++i) {
            this.simulators[i].start();
        }
        MutableDigest digest = new MutableDigest(3);
        for (Address addr : this.addresses) {
            digest.add(new Digest(addr, 0L, 0L));
        }
        for (int i3 = 0; i3 < 3; ++i3) {
            this.layers[i3].down(new Event(41, digest));
        }
    }

    @AfterMethod
    public void tearDown() throws Exception {
        for (int i = 0; i < 3; ++i) {
            this.simulators[i].stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReceptionOfAllMessages() {
        for (int i = 0; i < 3; ++i) {
            this.threads[i] = new MyNAKACKPeer(this.simulators[i], this.isSender[i]);
            this.threads[i].start();
        }
        Object i = all_msgs_recd;
        synchronized (i) {
            try {
                all_msgs_recd.wait(10000L);
            }
            catch (InterruptedException e) {
                System.out.println("main thread interrupted");
            }
        }
        try {
            for (int i2 = 0; i2 < 3; ++i2) {
                this.threads[i2].join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)allMsgsReceived, (String)"Incorrect number of messages received by the receiver thread");
        Assert.assertFalse((boolean)notFIFO, (String)"Sequenece numbers for a peer not in correct order");
    }

    static class MyNAKACKPeer
    extends Thread {
        Simulator s = null;
        boolean sender = false;

        public MyNAKACKPeer(Simulator s, boolean sender) {
            this.s = s;
            this.sender = sender;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.sender) {
                Address address = this.s.getLocalAddress();
                for (int i = 1; i <= 1000; ++i) {
                    Message msg = new Message(null, address, new Long(i));
                    Event evt = new Event(1, msg);
                    this.s.send(evt);
                    if (i % 100 != 0) continue;
                    System.out.println("<" + address + ">:" + " ==> " + i);
                }
            }
            if (!this.sender) {
                Object object = all_msgs_recd;
                synchronized (object) {
                    try {
                        all_msgs_recd.wait(10000L);
                    }
                    catch (InterruptedException e) {
                        System.out.println("main thread interrupted");
                    }
                }
            }
        }
    }

    static class ReceiverPeer
    implements Simulator.Receiver {
        Simulator simulator = null;
        int num_mgs_received = 0;
        long starting_seqno;
        long last_seqno = this.starting_seqno = 1L;
        Hashtable<Address, Long> senders = new Hashtable();
        Message msg;
        Address sender;
        Long s;
        long received_seqno;

        ReceiverPeer(Simulator s) {
            this.simulator = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void receive(Event evt) {
            block10: {
                if (evt.getType() == 1) {
                    this.msg = (Message)evt.getArg();
                    this.sender = this.msg.getSrc();
                    this.s = this.senders.get(this.sender);
                    if (this.s == null) {
                        this.s = new Long(this.starting_seqno);
                        this.senders.put(this.sender, this.s);
                    }
                    this.last_seqno = this.s;
                    try {
                        this.s = (Long)this.msg.getObject();
                        this.received_seqno = this.s;
                        ++this.num_mgs_received;
                        if (this.received_seqno == this.last_seqno) {
                            this.senders.put(this.sender, new Long(this.last_seqno + 1L));
                        } else {
                            notFIFO = true;
                            Assert.fail((String)("FAIL: received msg #" + this.received_seqno + ", expected " + this.last_seqno));
                        }
                        Address address = this.simulator.getLocalAddress();
                        if (this.received_seqno % 100L == 0L && this.received_seqno > 0L) {
                            System.out.println("<" + address + ">:" + "PASS: received msg #" + this.received_seqno + " from " + this.sender);
                        }
                        if (this.num_mgs_received < 2000) break block10;
                        allMsgsReceived = true;
                        Object object = all_msgs_recd;
                        synchronized (object) {
                            all_msgs_recd.notifyAll();
                        }
                    }
                    catch (Exception ex) {
                        System.out.println(ex.toString());
                    }
                }
            }
        }

        public int getNumberOfReceivedMessages() {
            return this.num_mgs_received;
        }
    }

    static class SenderPeer
    implements Simulator.Receiver {
        Simulator simulator = null;
        int num_mgs_received = 0;

        SenderPeer(Simulator s) {
            this.simulator = s;
        }

        public void receive(Event evt) {
            if (evt.getType() == 1) {
                ++this.num_mgs_received;
                if (this.num_mgs_received % 100 == 0) {
                    System.out.println("<" + this.simulator.getLocalAddress() + ">:" + "<== " + this.num_mgs_received);
                }
            }
        }

        public int getNumberOfReceivedMessages() {
            return this.num_mgs_received;
        }
    }
}

