/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.TimeoutException;
import org.jgroups.protocols.TP;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class UnicastLoopbackTest
extends ChannelTestBase {
    JChannel channel = null;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.channel = this.createChannel(true, 1);
    }

    @AfterMethod
    protected void tearDown() throws Exception {
        Util.close((Channel)this.channel);
    }

    public void testUnicastMsgsWithLoopback() throws Exception {
        long TIMEOUT = 2000L;
        int NUM = 1000;
        long num_msgs_sent_before = 0L;
        long num_msgs_sent_after = 0L;
        Promise<Boolean> p = new Promise<Boolean>();
        MyReceiver receiver = new MyReceiver(1000, p);
        this.channel.setReceiver(receiver);
        this.channel.connect("demo-group");
        Address local_addr = this.channel.getAddress();
        UnicastLoopbackTest.setLoopbackProperty(this.channel, true);
        num_msgs_sent_before = UnicastLoopbackTest.getNumMessagesSentViaNetwork(this.channel);
        for (int i = 1; i <= 1000; ++i) {
            this.channel.send(new Message(local_addr, null, new Integer(i)));
            if (i % 100 != 0) continue;
            System.out.println("-- sent " + i);
        }
        num_msgs_sent_after = UnicastLoopbackTest.getNumMessagesSentViaNetwork(this.channel);
        System.out.println("num msgs before: " + num_msgs_sent_before + ", num msgs after: " + num_msgs_sent_after);
        assert (num_msgs_sent_before <= num_msgs_sent_after);
        assert (num_msgs_sent_after < 100L);
        try {
            p.getResultWithTimeout(2000L);
        }
        catch (TimeoutException te) {
            Assert.fail((String)"Test timed out before all messages were received");
        }
    }

    private static long getNumMessagesSentViaNetwork(JChannel ch) throws Exception {
        TP transport = ch.getProtocolStack().getTransport();
        if (transport == null) {
            throw new Exception("transport layer is not present - check default stack configuration");
        }
        return transport.getNumMessagesSent();
    }

    private static void setLoopbackProperty(JChannel ch, boolean loopback) throws Exception {
        TP transport = ch.getProtocolStack().getTransport();
        if (transport == null) {
            throw new Exception("transport layer is not present - check default stack configuration");
        }
        if (loopback && transport.isLoopback() || !loopback && !transport.isLoopback()) {
            return;
        }
        transport.setLoopback(loopback);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReceiver
    extends ReceiverAdapter {
        private final int numExpected;
        private int numReceived;
        private final Promise<Boolean> p;

        public MyReceiver(int numExpected, Promise<Boolean> p) {
            this.numExpected = numExpected;
            this.numReceived = 0;
            this.p = p;
        }

        @Override
        public void receive(Message msg) {
            Integer num = (Integer)msg.getObject();
            ++this.numReceived;
            if (num != null && num % 100 == 0) {
                System.out.println("-- received " + num);
            }
            if (this.numReceived >= this.numExpected) {
                this.p.setResult(Boolean.TRUE);
            }
        }

        public int getNumMsgsReceived() {
            return this.numReceived;
        }
    }
}

