/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.List;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jgroups.ChannelException;
import org.jgroups.ChannelFactory;
import org.jgroups.JChannelFactory;
import org.jgroups.View;
import org.jgroups.blocks.ReplicatedHashMap;
import org.jgroups.persistence.PersistenceFactory;

public class ReplicatedHashMapDemo
extends Frame
implements WindowListener,
ActionListener,
ReplicatedHashMap.Notification {
    static final String groupname = "HashMapDemo";
    ReplicatedHashMap<String, Float> map = null;
    final JButton get = new JButton("Get");
    final JButton set = new JButton("Set");
    final JButton quit = new JButton("Quit");
    final JButton get_all = new JButton("All");
    final JButton delete = new JButton("Delete");
    final JLabel stock = new JLabel("Key");
    final JLabel value = new JLabel("Value");
    final JLabel err_msg = new JLabel("Error");
    final JTextField stock_field = new JTextField();
    final JTextField value_field = new JTextField();
    final List listbox = new List();
    final Font default_font = new Font("Helvetica", 0, 12);

    public ReplicatedHashMapDemo() {
        this.addWindowListener(this);
    }

    private void showMsg(String msg) {
        this.err_msg.setText(msg);
        this.err_msg.setVisible(true);
    }

    private void clearMsg() {
        this.err_msg.setVisible(false);
    }

    private void removeItem() {
        int index = this.listbox.getSelectedIndex();
        if (index == -1) {
            this.showMsg("No item selected in listbox to be deleted !");
            return;
        }
        String s = this.listbox.getSelectedItem();
        String key = s.substring(0, s.indexOf(58, 0));
        if (key != null) {
            this.map.remove(key);
        }
    }

    private void showAll() {
        if (this.listbox.getItemCount() > 0) {
            this.listbox.removeAll();
        }
        if (this.map.isEmpty()) {
            return;
        }
        this.clearMsg();
        for (Map.Entry<String, Float> entry : this.map.entrySet()) {
            String key = entry.getKey();
            Float val = entry.getValue();
            if (val == null) continue;
            this.listbox.add(key + ": " + val.toString());
        }
    }

    public void start(ChannelFactory factory, String props, boolean persist) throws ChannelException {
        this.map = new ReplicatedHashMap(groupname, factory, props, persist, 10000L);
        this.map.addNotifier(this);
        this.setLayout(null);
        this.setSize(400, 300);
        this.setFont(this.default_font);
        this.stock.setBounds(new Rectangle(10, 30, 60, 30));
        this.value.setBounds(new Rectangle(10, 60, 60, 30));
        this.stock_field.setBounds(new Rectangle(100, 30, 100, 30));
        this.value_field.setBounds(new Rectangle(100, 60, 100, 30));
        this.listbox.setBounds(new Rectangle(210, 30, 150, 160));
        this.err_msg.setBounds(new Rectangle(10, 200, 350, 30));
        this.err_msg.setFont(new Font("Helvetica", 2, 12));
        this.err_msg.setForeground(Color.red);
        this.err_msg.setVisible(false);
        this.get.setBounds(new Rectangle(10, 250, 60, 30));
        this.set.setBounds(new Rectangle(80, 250, 60, 30));
        this.quit.setBounds(new Rectangle(150, 250, 60, 30));
        this.get_all.setBounds(new Rectangle(220, 250, 60, 30));
        this.delete.setBounds(new Rectangle(290, 250, 80, 30));
        this.get.addActionListener(this);
        this.set.addActionListener(this);
        this.quit.addActionListener(this);
        this.get_all.addActionListener(this);
        this.delete.addActionListener(this);
        this.add(this.stock);
        this.add(this.value);
        this.add(this.stock_field);
        this.add(this.value_field);
        this.add(this.err_msg);
        this.add(this.get);
        this.add(this.set);
        this.add(this.quit);
        this.add(this.get_all);
        this.add(this.delete);
        this.add(this.listbox);
        this._setTitle();
        this.showAll();
        this.setVisible(true);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        try {
            if (command.equals("Get")) {
                String stock_name = this.stock_field.getText();
                if (stock_name == null || stock_name.length() == 0) {
                    this.showMsg("Key is empty !");
                    return;
                }
                this.showMsg("Looking up value for " + stock_name + ':');
                Float val = (Float)this.map.get(stock_name);
                if (val != null) {
                    this.value_field.setText(val.toString());
                    this.clearMsg();
                } else {
                    this.value_field.setText("");
                    this.showMsg("Value for " + stock_name + " not found");
                }
            } else if (command.equals("Set")) {
                String stock_name = this.stock_field.getText();
                String stock_val = this.value_field.getText();
                if (stock_name == null || stock_val == null || stock_name.length() == 0 || stock_val.length() == 0) {
                    this.showMsg("Both key and value have to be present to create a new entry");
                    return;
                }
                Float val = new Float(stock_val);
                this.map.put(stock_name, val);
                this.showMsg("Key " + stock_name + " set to " + val);
            } else if (command.equals("All")) {
                this.showAll();
            } else if (command.equals("Quit")) {
                this.setVisible(false);
                System.exit(0);
            } else if (command.equals("Delete")) {
                this.removeItem();
            } else {
                System.out.println("Unknown action");
            }
        }
        catch (Exception ex) {
            this.value_field.setText("");
            this.showMsg(ex.toString());
        }
    }

    public void entrySet(Serializable key, Serializable value) {
        this.showAll();
    }

    public void entryRemoved(Serializable key) {
        this.showAll();
    }

    public void contentsSet(Map m) {
        System.out.println("new contents: " + m);
    }

    public void contentsCleared() {
        System.out.println("contents cleared");
    }

    public void viewChange(View view, Vector new_mbrs, Vector old_mbrs) {
        System.out.println("** view: " + view);
        this._setTitle();
    }

    private void _setTitle() {
        int num = this.map.getChannel().getView().getMembers().size();
        this.setTitle("ReplicatedHashMapDemo: " + num + " server(s)");
    }

    public static void main(String[] args) {
        ReplicatedHashMapDemo client = new ReplicatedHashMapDemo();
        boolean persist = false;
        String props = "udp.xml";
        try {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if ("-persist".equals(arg) && i + 1 < args.length) {
                    persist = true;
                    PersistenceFactory.getInstance().createManager(args[++i]);
                    continue;
                }
                if ("-props".equals(arg)) {
                    props = args[++i];
                    continue;
                }
                ReplicatedHashMapDemo.help();
                return;
            }
        }
        catch (Exception e) {
            ReplicatedHashMapDemo.help();
            return;
        }
        try {
            JChannelFactory factory = new JChannelFactory(props);
            client.start(factory, props, persist);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static void help() {
        System.out.println("ReplicatedHashMapDemo [-help] [-persist] [-props <properties>]");
    }
}

