/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import org.jgroups.Address;
import org.jgroups.ChannelException;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class MySpaceTest {
    private final boolean sender;
    private final String props;
    private final int sleep;
    private JChannel ch;
    private final int MIN_SIZE;
    private final int MAX_SIZE;
    private final int FIXED_SIZE;
    private int seqno = 1;
    private static final String NAME = "MySpace";
    private final Map<Integer, Map<Address, Long>> stats = new ConcurrentHashMap<Integer, Map<Address, Long>>();

    public MySpaceTest(boolean sender, String props, int sleep, int min, int max, int fixed) {
        this.sender = sender;
        this.props = props;
        this.sleep = sleep;
        this.MIN_SIZE = min;
        this.MAX_SIZE = max;
        this.FIXED_SIZE = fixed;
    }

    public void start() throws Exception {
        this.ch = new JChannel(this.props);
        this.ch.setReceiver(new MyReceiver(this.ch));
        this.ch.connect("MySpaceCluster");
        MBeanServer server = Util.getMBeanServer();
        if (server == null) {
            System.err.println("No MBeanServers found;\nMySpaceTest needs to be run with an MBeanServer present, or inside JDK 5");
        }
        JmxConfigurator.registerChannel(this.ch, server, "jgroups", this.ch.getClusterName(), true);
        if (this.sender) {
            this.ch.setOpt(3, false);
            System.out.println("min=" + Util.printBytes(this.MIN_SIZE) + ", max=" + Util.printBytes(this.MAX_SIZE) + ", sleep time=" + this.sleep);
            while (true) {
                Util.sleepRandom(this.sleep);
                this.sendMessage();
            }
        }
    }

    private void sendMessage() throws ChannelException {
        int size = (int)Util.random(this.MAX_SIZE);
        size = Math.max(size, this.MIN_SIZE);
        if (this.FIXED_SIZE > 0) {
            size = this.FIXED_SIZE;
        }
        byte[] buf = new byte[size];
        Message msg = new Message(null, null, buf);
        Vector<Address> mbrs = this.ch.getView().getMembers();
        long current_time = System.currentTimeMillis();
        ConcurrentHashMap<Address, Long> map = new ConcurrentHashMap<Address, Long>();
        for (Address mbr : mbrs) {
            map.put(mbr, current_time);
        }
        this.stats.put(this.seqno, map);
        MyHeader hdr = new MyHeader(MyHeader.Type.DATA, this.seqno, size);
        msg.putHeader(NAME, hdr);
        System.out.println("\n[" + new Date() + "] --> sending #" + this.seqno + ": " + Util.printBytes(size));
        this.ch.send(msg);
        ++this.seqno;
    }

    public static void main(String[] args) throws Exception {
        boolean sender = false;
        int sleep = 10000;
        int min = 100000;
        int max = 100000000;
        int fixed = 0;
        String props = "udp.xml";
        for (int i = 0; i < args.length; ++i) {
            String tmp = args[i];
            if (tmp.equalsIgnoreCase("-sender")) {
                sender = true;
                continue;
            }
            if (tmp.equalsIgnoreCase("-props")) {
                props = args[++i];
                continue;
            }
            if (tmp.equalsIgnoreCase("-sleep")) {
                sleep = Integer.parseInt(args[++i]);
                continue;
            }
            if (tmp.equalsIgnoreCase("-min")) {
                min = Integer.parseInt(args[++i]);
                continue;
            }
            if (tmp.equalsIgnoreCase("-max")) {
                max = Integer.parseInt(args[++i]);
                continue;
            }
            if (tmp.equalsIgnoreCase("-fixed")) {
                fixed = Integer.parseInt(args[++i]);
                continue;
            }
            if (tmp.equalsIgnoreCase("-bind_addr")) {
                System.setProperty("jgroups.bind_addr", args[++i]);
                continue;
            }
            MySpaceTest.help();
            return;
        }
        ClassConfigurator.add((short)10000, MyHeader.class);
        new MySpaceTest(sender, props, sleep, min, max, fixed).start();
    }

    static void help() {
        System.out.println("MySpaceTest [-sender] [-props <props>] [-bind_addr <addr>] [-sleep <time in ms>] [-min <size>] [-max <size>] [-fixed <size>]");
    }

    public static class MyHeader
    extends Header
    implements Streamable {
        private static final long serialVersionUID = -8796883857099720796L;
        private Type type;
        private int seqno;
        private int size;

        public MyHeader() {
            this.type = Type.DATA;
            this.seqno = -1;
            this.size = -1;
        }

        public MyHeader(Type type, int seqno, int size) {
            this.type = type;
            this.seqno = seqno;
            this.size = size;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeUTF(this.type.name());
            out.writeInt(this.seqno);
            out.writeInt(this.size);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            String name = in.readUTF();
            this.type = Type.valueOf(name);
            this.seqno = in.readInt();
            this.size = in.readInt();
        }

        public int size() {
            int retval = 8;
            return retval += this.type.name().length() + 2;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("type=" + (Object)((Object)this.type));
            switch (this.type) {
                case DATA: {
                    sb.append(", seqno=" + this.seqno + ", size=" + Util.printBytes(this.size));
                    break;
                }
                case CONFIRMATION: {
                    sb.append(", seqno=" + this.seqno);
                }
            }
            return sb.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Type {
            DATA,
            CONFIRMATION;

        }
    }

    private class MyReceiver
    extends ReceiverAdapter {
        private final JChannel channel;

        public MyReceiver(JChannel channel) {
            this.channel = channel;
        }

        public void viewAccepted(View new_view) {
            this.log("view: " + new_view);
        }

        public void receive(Message msg) {
            int len = msg.getLength();
            MyHeader hdr = (MyHeader)msg.getHeader(MySpaceTest.NAME);
            switch (hdr.type) {
                case DATA: {
                    this.log("<-- received #" + hdr.seqno + ": " + Util.printBytes(len) + " from " + msg.getSrc());
                    if (hdr.size != len) {
                        System.err.println("hdr.size (" + hdr.size + ") != length (" + len + ")");
                    }
                    this.sendConfirmation(msg.getSrc(), hdr.seqno, hdr.size);
                    break;
                }
                case CONFIRMATION: {
                    this.handleConfirmation(msg.getSrc(), hdr.seqno);
                    break;
                }
                default: {
                    System.err.println("received invalid header: " + hdr);
                }
            }
        }

        private void handleConfirmation(Address sender, int seqno) {
            Map map = (Map)MySpaceTest.this.stats.get(seqno);
            if (map == null) {
                System.err.println("no map for seqno #" + seqno);
                return;
            }
            Long start_time = (Long)map.remove(sender);
            if (start_time != null) {
                long diff = System.currentTimeMillis() - start_time;
                System.out.println("time for #" + seqno + ": " + sender + ": " + diff + "ms");
            }
            if (map.isEmpty()) {
                MySpaceTest.this.stats.remove(seqno);
            }
        }

        private void sendConfirmation(Address dest, int seqno, int size) {
            Message rsp = new Message(dest, null, null);
            rsp.setFlag((byte)1);
            MyHeader rsp_hdr = new MyHeader(MyHeader.Type.CONFIRMATION, seqno, size);
            rsp.putHeader(MySpaceTest.NAME, rsp_hdr);
            try {
                this.channel.send(rsp);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        private void log(String msg) {
            System.out.println(msg);
        }
    }
}

