/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.MergeView;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.mux.MuxHeader;
import org.jgroups.mux.ServiceInfo;
import org.jgroups.protocols.COMPRESS;
import org.jgroups.protocols.ENCRYPT;
import org.jgroups.protocols.FC;
import org.jgroups.protocols.FD;
import org.jgroups.protocols.FD_SOCK;
import org.jgroups.protocols.FragHeader;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.SEQUENCER;
import org.jgroups.protocols.TpHeader;
import org.jgroups.protocols.UNICAST;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.protocols.pbcast.NakAckHeader;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.protocols.pbcast.STATE_TRANSFER;
import org.jgroups.stack.GossipData;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Digest;
import org.jgroups.util.MergeId;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.Streamable;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class SizeTest {
    public static void testTpHeader() throws Exception {
        SizeTest._testSize(new TpHeader("DemoChannel"));
    }

    public static void testPingHeader() throws Exception {
        SizeTest._testSize(new PingHeader(1, "bla"));
        SizeTest._testSize(new PingHeader(2, new PingData()));
        SizeTest._testSize(new PingHeader(2, (PingData)null));
        SizeTest._testSize(new PingHeader(2, (String)null));
        SizeTest._testSize(new PingHeader(2, new PingData(Util.createRandomAddress(), null, true)));
        Address self = Util.createRandomAddress();
        PingData rsp = new PingData(self, Util.createView(self, 1L, self), true);
        SizeTest._testSize(new PingHeader(2, rsp));
        rsp = new PingData(self, Util.createView(self, 1L, self, Util.createRandomAddress(), Util.createRandomAddress()), true);
        SizeTest._testSize(new PingHeader(2, rsp));
    }

    public static void testPingData() throws Exception {
        UUID own = UUID.randomUUID();
        UUID coord = UUID.randomUUID();
        IpAddress physical_addr_1 = new IpAddress("127.0.0.1", 7500);
        IpAddress physical_addr_2 = new IpAddress("192.168.1.5", 6000);
        IpAddress physical_addr_3 = new IpAddress("192.134.2.1", 6655);
        Address self = Util.createRandomAddress();
        PingData data = new PingData(null, null, false);
        SizeTest._testSize(data);
        data = new PingData(own, Util.createView(coord, 22L, coord, Util.createRandomAddress()), false);
        SizeTest._testSize(data);
        data = new PingData(null, null, false, "node-1", null);
        SizeTest._testSize(data);
        data = new PingData(own, Util.createView(coord, 22L, coord), false, "node-1", null);
        SizeTest._testSize(data);
        data = new PingData(own, Util.createView(coord, 22L, coord), false, "node-1", new ArrayList<PhysicalAddress>(7));
        SizeTest._testSize(data);
        data = new PingData(null, null, false, "node-1", new ArrayList<PhysicalAddress>(7));
        SizeTest._testSize(data);
        ArrayList<PhysicalAddress> list = new ArrayList<PhysicalAddress>();
        list.add(physical_addr_1);
        list.add(physical_addr_2);
        list.add(physical_addr_3);
        data = new PingData(null, null, false, "node-1", list);
        SizeTest._testSize(data);
        list.clear();
        list.add(new IpAddress("127.0.0.1", 7500));
        data = new PingData(null, null, false, "node-1", list);
        SizeTest._testSize(data);
        View view = Util.createView(coord, 322649L, coord, own, UUID.randomUUID());
        data.setView(view);
        SizeTest._testSize(data);
        data = new PingData(self, Util.createView(self, 1L, self), true, "logical-name", null);
        SizeTest._testSize(data);
    }

    public static void testGossipData() throws Exception {
        UUID own = UUID.randomUUID();
        UUID coord = UUID.randomUUID();
        UUID.add(own, "own");
        UUID.add(coord, "coord");
        IpAddress physical_addr_1 = new IpAddress("127.0.0.1", 7500);
        IpAddress physical_addr_2 = new IpAddress("192.168.1.5", 6000);
        IpAddress physical_addr_3 = new IpAddress("192.134.2.1", 6655);
        SizeTest._testSize(new GossipData());
        GossipData data = new GossipData(1);
        SizeTest._testSize(data);
        data = new GossipData(1, "DemoCluster", (Address)own, (List<Address>)null, null);
        SizeTest._testSize(data);
        data = new GossipData(1, "DemoCluster", (Address)own, Arrays.asList(own, coord), null);
        SizeTest._testSize(data);
        data = new GossipData(1, "DemoCluster", (Address)own, Arrays.asList(own, coord), Arrays.asList(physical_addr_1, physical_addr_2, physical_addr_3));
        SizeTest._testSize(data);
        ArrayList<PhysicalAddress> list = new ArrayList<PhysicalAddress>();
        list.add(physical_addr_1);
        list.add(physical_addr_2);
        list.add(physical_addr_3);
        data = new GossipData(1, "DemoCluster", (Address)own, Arrays.asList(own, coord), list);
        SizeTest._testSize(data);
        data = new GossipData(1, "demo", (Address)own, "logical_name", null);
        SizeTest._testSize(data);
        data = new GossipData(1, "demo", (Address)own, new byte[]{98, 101, 108, 97});
        SizeTest._testSize(data);
        byte[] buffer = new byte[10];
        buffer[2] = 66;
        buffer[3] = 101;
        buffer[4] = 108;
        buffer[5] = 97;
        data = new GossipData(1, "demo", own, buffer, 2, 4);
        SizeTest._testSize(data);
    }

    public static void testDigest() throws Exception {
        Address addr = Util.createRandomAddress();
        MutableDigest mutableDigest = new MutableDigest(2);
        mutableDigest.add(addr, 100L, 200L, 205L);
        mutableDigest.add(Util.createRandomAddress(), 102L, 104L, 105L);
        SizeTest._testSize(mutableDigest);
        Digest digest = new Digest();
        SizeTest._testSize(digest);
        digest = new Digest(10);
        SizeTest._testSize(digest);
        digest = new Digest(Util.createRandomAddress(), 10L, 45L, 50L);
        SizeTest._testSize(digest);
    }

    public static void testNakackHeader() throws Exception {
        SizeTest._testSize(new NakAckHeader(1, 322649L));
        SizeTest._testSize(new NakAckHeader(2, 100L, 104L, Util.createRandomAddress()));
        SizeTest._testSize(new NakAckHeader(3, 100L, 104L, Util.createRandomAddress()));
        SizeTest._testSize(new NakAckHeader(3, 322649L));
    }

    public static void testFdHeaders() throws Exception {
        FD.FdHeader hdr = new FD.FdHeader(1);
        SizeTest._testSize(hdr);
        IpAddress a1 = new IpAddress("127.0.0.1", 5555);
        IpAddress a2 = new IpAddress("127.0.0.1", 6666);
        Vector<Address> suspects = new Vector<Address>();
        suspects.add(a1);
        suspects.add(a2);
        hdr = new FD.FdHeader(2, suspects, a1);
        SizeTest._testSize(hdr);
        FD_SOCK.FdHeader sockhdr = new FD_SOCK.FdHeader(13);
        SizeTest._testSize(sockhdr);
        sockhdr = new FD_SOCK.FdHeader(10, new IpAddress("127.0.0.1", 5555));
        SizeTest._testSize(sockhdr);
        HashSet<Address> tmp = new HashSet<Address>();
        tmp.add(a1);
        tmp.add(a2);
        sockhdr = new FD_SOCK.FdHeader(10, tmp);
        SizeTest._testSize(sockhdr);
        Hashtable<Address, IpAddress> cache = new Hashtable<Address, IpAddress>();
        cache.put(a1, a2);
        cache.put(a2, a1);
        sockhdr = new FD_SOCK.FdHeader(10, cache);
        SizeTest._testSize(sockhdr);
    }

    public static void testFdSockHeaders() throws Exception {
        FD_SOCK.FdHeader hdr = new FD_SOCK.FdHeader(13);
        SizeTest._testSize(hdr);
        hdr = new FD_SOCK.FdHeader(13, new IpAddress("127.0.0.1", 4567));
        SizeTest._testSize(hdr);
        HashSet<Address> set = new HashSet<Address>();
        set.add(new IpAddress(3452));
        set.add(new IpAddress("127.0.0.1", 5000));
        hdr = new FD_SOCK.FdHeader(13, set);
        SizeTest._testSize(hdr);
        Hashtable<Address, IpAddress> map = new Hashtable<Address, IpAddress>();
        map.put(new IpAddress("127.0.0.1", 5000), new IpAddress(4553));
        map.put(new IpAddress("127.0.0.1", 6000), new IpAddress(4523));
        map.put(new IpAddress(7000), new IpAddress(4553));
        hdr = new FD_SOCK.FdHeader(13, map);
        SizeTest._testSize(hdr);
        hdr = new FD_SOCK.FdHeader(12, new IpAddress("127.0.0.1", 4567), new IpAddress("127.0.0.1", 4567));
        SizeTest._testSize(hdr);
    }

    public static void testUnicastHeader() throws Exception {
        UNICAST.UnicastHeader hdr = new UNICAST.UnicastHeader(0, 322649L);
        SizeTest._testSize(hdr);
        hdr = new UNICAST.UnicastHeader(0, 322649L, System.currentTimeMillis());
        SizeTest._testSize(hdr);
        hdr = new UNICAST.UnicastHeader(0, 322649L, System.currentTimeMillis(), true);
        SizeTest._testSize(hdr);
    }

    public static void testStableHeader() throws Exception {
        UUID addr = UUID.randomUUID();
        HashMap<Address, Digest.Entry> map = new HashMap<Address, Digest.Entry>();
        map.put(addr, new Digest.Entry(100L, 200L, 205L));
        Digest digest = new Digest(map);
        STABLE.StableHeader hdr = new STABLE.StableHeader(1, digest);
        SizeTest._testSize(hdr);
        hdr = new STABLE.StableHeader(2, null);
        SizeTest._testSize(hdr);
    }

    public static void testStableHeader2() throws Exception {
        IpAddress addr = new IpAddress("127.0.0.1", 5555);
        MutableDigest digest = new MutableDigest(2);
        digest.add(addr, 100L, 200L, 205L);
        STABLE.StableHeader hdr = new STABLE.StableHeader(1, digest);
        SizeTest._testSize(hdr);
        hdr = new STABLE.StableHeader(2, null);
        SizeTest._testSize(hdr);
    }

    public static void testSequencerHeader() throws Exception {
        IpAddress addr = new IpAddress("127.0.0.1", 5555);
        SEQUENCER.SequencerHeader hdr = new SEQUENCER.SequencerHeader(1, addr, 1L);
        SizeTest._testSize(hdr);
        hdr = new SEQUENCER.SequencerHeader(2, null, -1L);
        SizeTest._testSize(hdr);
    }

    public static void testAddressVector() throws Exception {
        Vector<Address> v = new Vector<Address>();
        SizeTest._testSize(v);
        v.add(new IpAddress(1111));
        SizeTest._testSize(v);
        v.add(new IpAddress(2222));
        SizeTest._testSize(v);
    }

    public static void testViewId() throws Exception {
        ViewId vid = new ViewId();
        SizeTest._testSize(vid);
        vid = new ViewId(new IpAddress(5555));
        SizeTest._testSize(vid);
        vid = new ViewId(new IpAddress(5555), 322649L);
        SizeTest._testSize(vid);
    }

    public static void testMergeId() throws Exception {
        MergeId id = MergeId.create(UUID.randomUUID());
        System.out.println("id = " + id);
        SizeTest._testSize(id);
        id = MergeId.create(UUID.randomUUID());
        System.out.println("id = " + id);
        SizeTest._testSize(id);
        UUID addr = UUID.randomUUID();
        id = MergeId.create(addr);
        System.out.println("id = " + id);
        SizeTest._testSize(id);
        id = MergeId.create(addr);
        System.out.println("id = " + id);
        SizeTest._testSize(id);
        id = MergeId.create(addr);
        System.out.println("id = " + id);
        SizeTest._testSize(id);
    }

    public static void testView() throws Exception {
        View v = new View();
        SizeTest._testSize(v);
        ViewId vid = new ViewId(UUID.randomUUID(), 322649L);
        Vector<Address> mbrs = new Vector<Address>();
        v = new View(vid, mbrs);
        SizeTest._testSize(v);
        mbrs.add(UUID.randomUUID());
        SizeTest._testSize(v);
        mbrs.add(UUID.randomUUID());
        SizeTest._testSize(v);
    }

    public static void testViewPayload() throws Exception {
        View v = new View();
        v.addPayload("name", "Bela Ban");
        SizeTest._testSize(v);
        ViewId vid = new ViewId(UUID.randomUUID(), 322649L);
        Vector<Address> mbrs = new Vector<Address>();
        v = new View(vid, mbrs);
        v.addPayload("id", 322649);
        v.addPayload("name", "Michelle");
        SizeTest._testSize(v);
        mbrs.add(UUID.randomUUID());
        SizeTest._testSize(v);
        mbrs.add(UUID.randomUUID());
        SizeTest._testSize(v);
    }

    public static void testMergeView() throws Exception {
        MergeView v = new MergeView();
        SizeTest._testSize(v);
        ViewId vid = new ViewId(UUID.randomUUID(), 322649L);
        Vector<Address> mbrs = new Vector<Address>();
        v = new MergeView(vid, mbrs, null);
        SizeTest._testSize(v);
        mbrs.add(UUID.randomUUID());
        SizeTest._testSize(v);
        mbrs.add(UUID.randomUUID());
        SizeTest._testSize(v);
    }

    public static void testMergeView2() throws Exception {
        Address a = Util.createRandomAddress();
        Address b = Util.createRandomAddress();
        Address c = Util.createRandomAddress();
        Address d = Util.createRandomAddress();
        Address e = Util.createRandomAddress();
        Address f = Util.createRandomAddress();
        Vector<Address> m1 = new Vector<Address>();
        Vector<Address> m2 = new Vector<Address>();
        Vector<Address> m3 = new Vector<Address>();
        Vector<Address> all = new Vector<Address>();
        Vector<View> subgroups = new Vector<View>();
        m1.add(a);
        m1.add(b);
        m1.add(c);
        m2.add(d);
        m3.add(e);
        m3.add(f);
        all.add(a);
        all.add(b);
        all.add(c);
        all.add(d);
        all.add(e);
        all.add(f);
        View v1 = new View(a, 1L, m1);
        View v2 = new View(d, 2L, m2);
        View v3 = new View(e, 3L, m3);
        subgroups.add(v1);
        subgroups.add(v2);
        subgroups.add(v3);
        MergeView view_all = new MergeView(a, 5L, all, subgroups);
        System.out.println("MergeView: " + view_all);
        SizeTest._testSize(view_all);
    }

    public static void testMergeView3() throws Exception {
        IpAddress a = new IpAddress(1000);
        IpAddress b = new IpAddress(2000);
        IpAddress c = new IpAddress(3000);
        IpAddress d = new IpAddress(4000);
        IpAddress e = new IpAddress(5000);
        IpAddress f = new IpAddress(6000);
        Vector<Address> m1 = new Vector<Address>();
        Vector<Address> m2 = new Vector<Address>();
        Vector<Address> m3 = new Vector<Address>();
        Vector<Address> all = new Vector<Address>();
        Vector<View> subgroups = new Vector<View>();
        m1.add(a);
        m1.add(b);
        m1.add(c);
        m2.add(d);
        m3.add(e);
        m3.add(f);
        all.add(a);
        all.add(b);
        all.add(c);
        all.add(d);
        all.add(e);
        all.add(f);
        View v1 = new View(a, 1L, m1);
        MergeView v2 = new MergeView(d, 2L, m2, new Vector<View>());
        View v3 = new View(e, 3L, m3);
        MergeView v4 = new MergeView(e, 4L, m3, null);
        subgroups.add(v1);
        subgroups.add(v2);
        subgroups.add(v3);
        subgroups.add(v4);
        MergeView view_all = new MergeView(a, 5L, all, subgroups);
        System.out.println("MergeView: " + view_all);
        SizeTest._testSize(view_all);
    }

    public static void testJoinRsp() throws Exception {
        Vector<Address> members = new Vector<Address>();
        members.add(new IpAddress(1111));
        members.add(new IpAddress(2222));
        View v = new View(new IpAddress(1234), 322649L, members);
        MutableDigest d = new MutableDigest(3);
        d.add(new IpAddress(3524), 1L, 2L, 3L);
        d.add(new IpAddress(1324), 3L, 4L, 5L);
        JoinRsp rsp = new JoinRsp();
        SizeTest._testSize(rsp);
        rsp = new JoinRsp(v, d);
        SizeTest._testSize(rsp);
        rsp = new JoinRsp("this is a failure");
        SizeTest._testSize(rsp);
    }

    public static void testGmsHeader() throws Exception {
        UUID addr = UUID.randomUUID();
        GMS.GmsHeader hdr = new GMS.GmsHeader(1, addr);
        SizeTest._testSize(hdr);
        Vector<Address> members = new Vector<Address>();
        members.add(addr);
        members.add(addr);
        View v = new View(addr, 33L, members);
        hdr = new GMS.GmsHeader(2, v);
        SizeTest._testSize(hdr);
        ArrayList<Address> mbrs = new ArrayList<Address>();
        Collections.addAll(mbrs, UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID());
        hdr = new GMS.GmsHeader(6, mbrs);
    }

    public static void testFCHeader() throws Exception {
        FC.FcHeader hdr = new FC.FcHeader(1);
        SizeTest._testSize(hdr);
    }

    public static void testFragHeader() throws Exception {
        FragHeader hdr = new FragHeader(322649L, 1, 10);
        SizeTest._testSize(hdr);
    }

    public static void testCompressHeader() throws Exception {
        COMPRESS.CompressHeader hdr = new COMPRESS.CompressHeader(2002);
        SizeTest._testSize(hdr);
    }

    public static void testStateHeader() throws Exception {
        IpAddress addr = new IpAddress("127.0.0.1", 5555);
        STATE_TRANSFER.StateHeader hdr = new STATE_TRANSFER.StateHeader(1, addr, 322649L, null);
        SizeTest._testSize(hdr);
        hdr = new STATE_TRANSFER.StateHeader(1, addr, 322649L, null, "my_state");
        SizeTest._testSize(hdr);
        MutableDigest digest = new MutableDigest(2);
        digest.add(addr, 100L, 200L, 205L);
        digest.add(new IpAddress(2314), 102L, 104L, 105L);
        hdr = new STATE_TRANSFER.StateHeader(2, addr, 322649L, digest);
        SizeTest._testSize(hdr);
        hdr = new STATE_TRANSFER.StateHeader(2, addr, 322649L, digest, "my_state");
        SizeTest._testSize(hdr);
    }

    public static void testEncryptHeader() throws Exception {
        ENCRYPT.EncryptHeader hdr = new ENCRYPT.EncryptHeader(1, null);
        SizeTest._testSize(hdr);
        hdr = new ENCRYPT.EncryptHeader(2, "Hello world");
        SizeTest._testSize(hdr);
    }

    public static void testIpAddress() throws Exception {
        IpAddress addr = new IpAddress();
        SizeTest._testSize(addr);
    }

    public static void testIpAddress1() throws Exception {
        IpAddress addr = new IpAddress("127.0.0.1", 5555);
        SizeTest._testSize(addr);
    }

    public static void testIpAddressWithHighPort() throws Exception {
        IpAddress addr = new IpAddress("127.0.0.1", 65535);
        SizeTest._testSize(addr);
    }

    public static void testIpAddress2() throws Exception {
        IpAddress addr = new IpAddress(3456);
        SizeTest._testSize(addr);
    }

    public static void testIpAddress3() throws Exception {
        IpAddress addr = new IpAddress(5555, false);
        SizeTest._testSize(addr);
    }

    public static void testIpAddressWithAdditionalData() throws Exception {
        IpAddress addr = new IpAddress(5555, false);
        addr.setAdditionalData("bela".getBytes());
        SizeTest._testSize(addr);
    }

    public static void testWriteAddress() throws IOException, IllegalAccessException, InstantiationException {
        UUID uuid = UUID.randomUUID();
        SizeTest._testWriteAddress(uuid);
        uuid.setAdditionalData("Bela Ban".getBytes());
        SizeTest._testWriteAddress(uuid);
        IpAddress addr = new IpAddress(7500);
        SizeTest._testWriteAddress(addr);
        addr = new IpAddress("127.0.0.1", 5678);
        SizeTest._testWriteAddress(addr);
        addr.setAdditionalData("Bela Ban".getBytes());
        SizeTest._testWriteAddress(addr);
    }

    private static void _testWriteAddress(Address addr) throws IOException, InstantiationException, IllegalAccessException {
        int len = Util.size(addr);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(output);
        Util.writeAddress(addr, out);
        out.flush();
        byte[] buf = output.toByteArray();
        out.close();
        System.out.println("\nlen=" + len + ", serialized length=" + buf.length);
        assert (len == buf.length);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buf));
        Address new_addr = Util.readAddress(in);
        System.out.println("old addr=" + addr + "\nnew addr=" + new_addr);
        assert (addr.equals(new_addr));
    }

    public static void testWriteAddresses() throws IOException, IllegalAccessException, InstantiationException {
        ArrayList<Address> list = new ArrayList<Address>();
        for (int i = 0; i < 3; ++i) {
            list.add(UUID.randomUUID());
        }
        SizeTest._testWriteAddresses(list);
        list.clear();
        list.add(new IpAddress(7500));
        list.add(new IpAddress("192.168.1.5", 4444));
        list.add(new IpAddress("127.0.0.1", 5674));
        SizeTest._testWriteAddresses(list);
    }

    private static void _testWriteAddresses(List<Address> list) throws IOException, InstantiationException, IllegalAccessException {
        long len = Util.size(list);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(output);
        Util.writeAddresses(list, out);
        out.flush();
        byte[] buf = output.toByteArray();
        out.close();
        System.out.println("\nlen=" + len + ", serialized length=" + buf.length);
        assert (len == (long)buf.length);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buf));
        Collection<? extends Address> new_list = Util.readAddresses(in, ArrayList.class);
        System.out.println("old list=" + list + "\nnew list=" + new_list);
        assert (((Object)list).equals(new_list));
    }

    public static void testUUID() throws Exception {
        UUID uuid = UUID.randomUUID();
        System.out.println("uuid = " + uuid);
        SizeTest._testSize(uuid);
        uuid = UUID.randomUUID();
        byte[] buf = Util.streamableToByteBuffer(uuid);
        UUID uuid2 = (UUID)Util.streamableFromByteBuffer(UUID.class, buf);
        System.out.println("uuid:  " + uuid);
        System.out.println("uuid2: " + uuid2);
        assert (uuid.equals(uuid2));
        int hash1 = uuid.hashCode();
        int hash2 = uuid2.hashCode();
        System.out.println("hash 1: " + hash1);
        System.out.println("hash 2: " + hash2);
        assert (hash1 == hash2);
        uuid.setAdditionalData("bela ban".getBytes());
        SizeTest._testSize(uuid);
    }

    public static void testRequestCorrelatorHeader() throws Exception {
        RequestCorrelator.Header hdr = new RequestCorrelator.Header(0, 322649L, false, "HelloWorld");
        SizeTest._testSize(hdr);
        hdr = new RequestCorrelator.Header(1, 322649L, true, "bla");
        LinkedList<Address> l = new LinkedList<Address>();
        l.add(new IpAddress(1111));
        l.add(new IpAddress(2222));
        hdr.dest_mbrs = l;
        SizeTest._testSize(hdr);
        hdr = new RequestCorrelator.Header(1, 322649L, true, "bla");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(output);
        hdr.writeTo(out);
        out.flush();
        byte[] buf = output.toByteArray();
        out.close();
        ByteArrayInputStream input = new ByteArrayInputStream(buf);
        DataInputStream in = new DataInputStream(input);
        hdr = new RequestCorrelator.Header();
        hdr.readFrom(in);
        Assert.assertEquals((long)322649L, (long)hdr.id);
        assert (hdr.rsp_expected);
        Assert.assertEquals((String)"bla", (String)hdr.corrName);
        Assert.assertEquals((byte)1, (byte)hdr.type);
    }

    public static void testServiceInfo() throws Exception {
        ServiceInfo si = new ServiceInfo();
        SizeTest._testSize(si);
    }

    public static void testMuxHeader() throws Exception {
        MuxHeader hdr = new MuxHeader();
        SizeTest._testSize(hdr);
        hdr = new MuxHeader("bla");
        SizeTest._testSize(hdr);
        ServiceInfo si = new ServiceInfo();
        hdr = new MuxHeader(si);
        SizeTest._testSize(hdr);
        SizeTest._testSize(new MuxHeader(si));
    }

    private static void _testSize(Digest digest) throws Exception {
        long len = digest.serializedSize();
        byte[] serialized_form = Util.streamableToByteBuffer(digest);
        System.out.println("digest = " + digest);
        System.out.println("size=" + len + ", serialized size=" + serialized_form.length);
        assert (len == (long)serialized_form.length);
    }

    private static void _testSize(Header hdr) throws Exception {
        long size = hdr.size();
        byte[] serialized_form = Util.streamableToByteBuffer((Streamable)((Object)hdr));
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        Assert.assertEquals((long)serialized_form.length, (long)size);
    }

    private static void _testSize(Address addr) throws Exception {
        long size = addr.size();
        byte[] serialized_form = Util.streamableToByteBuffer(addr);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        Assert.assertEquals((long)serialized_form.length, (long)size);
    }

    private static void _testSize(ViewId vid) throws Exception {
        long size = vid.serializedSize();
        byte[] serialized_form = Util.streamableToByteBuffer(vid);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        Assert.assertEquals((long)serialized_form.length, (long)size);
    }

    private static void _testSize(MergeId id) throws Exception {
        long size = id.size();
        byte[] serialized_form = Util.streamableToByteBuffer(id);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        assert ((long)serialized_form.length == size);
    }

    private static void _testSize(View v) throws Exception {
        long size = v.serializedSize();
        byte[] serialized_form = Util.streamableToByteBuffer(v);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        Assert.assertEquals((long)serialized_form.length, (long)size);
    }

    private static void _testSize(Collection<Address> coll) throws Exception {
        long size = Util.size(coll);
        byte[] serialized_form = Util.collectionToByteBuffer(coll);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        Assert.assertEquals((long)serialized_form.length, (long)size);
    }

    private static void _testSize(JoinRsp rsp) throws Exception {
        long size = rsp.serializedSize();
        byte[] serialized_form = Util.streamableToByteBuffer(rsp);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        Assert.assertEquals((long)serialized_form.length, (long)size);
    }

    private static void _testSize(PingData data) throws Exception {
        System.out.println("\ndata: " + data);
        long size = data.size();
        byte[] serialized_form = Util.streamableToByteBuffer(data);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        assert ((long)serialized_form.length == size) : "serialized length=" + serialized_form.length + ", size=" + size;
    }

    private static void _testSize(GossipData data) throws Exception {
        System.out.println("\ndata: " + data);
        long size = data.size();
        byte[] serialized_form = Util.streamableToByteBuffer(data);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        assert ((long)serialized_form.length == size) : "serialized length=" + serialized_form.length + ", size=" + size;
    }

    private static void _testSize(ServiceInfo si) throws Exception {
        long size = si.size();
        byte[] serialized_form = Util.streamableToByteBuffer(si);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        Assert.assertEquals((long)serialized_form.length, (long)size);
    }

    private static void _testSize(MuxHeader hdr) throws Exception {
        long size = hdr.size();
        byte[] serialized_form = Util.streamableToByteBuffer(hdr);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        Assert.assertEquals((long)serialized_form.length, (long)size);
    }
}

