/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.TUNNEL;
import org.jgroups.stack.GossipRouter;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-independent", "known-failures", "gossip-router"}, sequential=true)
public class TUNNEL_Test2
extends ChannelTestBase {
    private JChannel channel;
    private JChannel coordinator;
    private GossipRouter gr1;
    private GossipRouter gr2;
    private static final String props = "tunnel.xml";
    private static String bindAddress = "127.0.0.1";

    @BeforeMethod
    void startRouter() throws Exception {
        this.gr1 = new GossipRouter(12003, bindAddress);
        this.gr1.start();
        this.gr2 = new GossipRouter(12004, bindAddress);
        this.gr2.start();
    }

    @AfterMethod
    void tearDown() throws Exception {
        Util.close(this.channel, this.coordinator);
        Util.sleep(1000L);
        this.gr1.stop();
        this.gr2.stop();
    }

    private void modifyChannel(JChannel ... channels) throws Exception {
        for (JChannel c : channels) {
            ProtocolStack stack = c.getProtocolStack();
            TUNNEL t = (TUNNEL)stack.getBottomProtocol();
            String s = bindAddress + "[" + this.gr1.getPort() + "],";
            s = s + bindAddress + "[" + this.gr2.getPort() + "]";
            t.setGossipRouterHosts(s);
            t.init();
        }
    }

    public void testSimpleConnect() throws Exception {
        this.channel = new JChannel(props);
        this.modifyChannel(this.channel);
        this.channel.connect("testSimpleConnect");
        assert (this.channel.getLocalAddress() != null);
        assert (this.channel.getView().size() == 1);
        this.channel.disconnect();
        assert (this.channel.getLocalAddress() == null);
        assert (this.channel.getView() == null);
    }

    public void testConnectTwoChannels() throws Exception {
        this.coordinator = new JChannel(props);
        this.channel = new JChannel(props);
        this.modifyChannel(this.channel, this.coordinator);
        this.coordinator.connect("testConnectTwoChannels");
        this.channel.connect("testConnectTwoChannels");
        View view = this.channel.getView();
        assert (view.size() == 2);
        assert (view.containsMember(this.channel.getLocalAddress()));
        assert (view.containsMember(this.coordinator.getLocalAddress()));
        this.channel.disconnect();
        Util.sleep(1000L);
        view = this.coordinator.getView();
        assert (view.size() == 1);
        assert (view.containsMember(this.coordinator.getLocalAddress()));
    }

    public void testConnectTwoChannelsBothGRDownReconnect() throws Exception {
        this.coordinator = new JChannel(props);
        this.channel = new JChannel(props);
        this.modifyChannel(this.channel, this.coordinator);
        this.coordinator.connect("testConnectTwoChannelsBothGRDownReconnect");
        this.channel.connect("testConnectTwoChannelsBothGRDownReconnect");
        Util.sleep(1000L);
        this.gr1.stop();
        this.gr2.stop();
        Util.sleep(3000L);
        this.gr1.start();
        this.gr2.start();
        Util.sleep(3000L);
        View view = this.coordinator.getView();
        assert (view.size() == 2);
        assert (view.containsMember(this.coordinator.getLocalAddress()));
        assert (view.containsMember(this.channel.getLocalAddress()));
        view = this.channel.getView();
        assert (view.size() == 2);
        assert (view.containsMember(this.coordinator.getLocalAddress()));
        assert (view.containsMember(this.channel.getLocalAddress()));
    }

    public void testConnectThreeChannelsWithGRDown() throws Exception {
        JChannel third = null;
        this.coordinator = new JChannel(props);
        this.channel = new JChannel(props);
        this.modifyChannel(this.channel, this.coordinator);
        this.coordinator.connect("testConnectThreeChannelsWithGRDown");
        this.channel.connect("testConnectThreeChannelsWithGRDown");
        third = new JChannel(props);
        this.modifyChannel(third);
        third.connect("testConnectThreeChannelsWithGRDown");
        Util.sleep(1000L);
        View view = this.channel.getView();
        assert (this.channel.getView().size() == 3);
        assert (third.getView().size() == 3);
        assert (view.containsMember(this.channel.getLocalAddress()));
        assert (view.containsMember(this.coordinator.getLocalAddress()));
        this.gr2.stop();
        Util.sleep(1000L);
        view = this.channel.getView();
        assert (this.channel.getView().size() == 3);
        assert (third.getView().size() == 3);
        assert (third.getView().containsMember(this.channel.getLocalAddress()));
        assert (third.getView().containsMember(this.coordinator.getLocalAddress()));
    }

    public void testConnectSendMessage() throws Exception {
        Promise<Message> msgPromise = new Promise<Message>();
        this.coordinator = new JChannel(props);
        this.modifyChannel(this.coordinator);
        this.coordinator.connect("testConnectSendMessage");
        this.coordinator.setReceiver(new PromisedMessageListener(msgPromise));
        this.channel = new JChannel(props);
        this.modifyChannel(this.channel);
        this.channel.connect("testConnectSendMessage");
        this.channel.send(new Message(null, null, (Serializable)((Object)"payload")));
        Message msg = msgPromise.getResult(20000L);
        assert (msg != null);
        assert ("payload".equals(msg.getObject()));
    }

    public void testConnectSendMessageSecondGRDown() throws Exception {
        Promise<Message> msgPromise = new Promise<Message>();
        this.coordinator = new JChannel(props);
        this.modifyChannel(this.coordinator);
        this.coordinator.connect("testConnectSendMessageSecondGRDown");
        this.coordinator.setReceiver(new PromisedMessageListener(msgPromise));
        this.channel = new JChannel(props);
        this.modifyChannel(this.channel);
        this.channel.connect("testConnectSendMessageSecondGRDown");
        Util.sleep(1000L);
        this.gr2.stop();
        this.channel.send(new Message(null, null, (Serializable)((Object)"payload")));
        View view = this.coordinator.getView();
        assert (view.size() == 2);
        assert (view.containsMember(this.coordinator.getLocalAddress()));
        assert (view.containsMember(this.channel.getLocalAddress()));
        view = this.channel.getView();
        assert (view.size() == 2);
        assert (view.containsMember(this.coordinator.getLocalAddress()));
        assert (view.containsMember(this.channel.getLocalAddress()));
        Message msg = msgPromise.getResult(20000L);
        assert (msg != null);
        assert ("payload".equals(msg.getObject()));
    }

    public void testConnectSendMessageBothGRDown() throws Exception {
        Promise<Message> msgPromise = new Promise<Message>();
        this.coordinator = new JChannel(props);
        this.modifyChannel(this.coordinator);
        this.coordinator.connect("testConnectSendMessageBothGRDown");
        this.coordinator.setReceiver(new PromisedMessageListener(msgPromise));
        this.channel = new JChannel(props);
        this.modifyChannel(this.channel);
        this.channel.connect("testConnectSendMessageBothGRDown");
        Util.sleep(1000L);
        this.gr1.stop();
        this.gr2.stop();
        Util.sleep(3000L);
        this.gr1.start();
        this.gr2.start();
        Util.sleep(3000L);
        this.channel.send(new Message(null, null, (Serializable)((Object)"payload")));
        View view = this.coordinator.getView();
        assert (view.size() == 2);
        assert (view.containsMember(this.coordinator.getLocalAddress()));
        assert (view.containsMember(this.channel.getLocalAddress()));
        view = this.channel.getView();
        assert (view.size() == 2);
        assert (view.containsMember(this.coordinator.getLocalAddress()));
        assert (view.containsMember(this.channel.getLocalAddress()));
        Message msg = msgPromise.getResult(20000L);
        assert (msg != null);
        assert ("payload".equals(msg.getObject()));
    }

    public void testConnectSendMessageBothGRDownOnlyOneUp() throws Exception {
        Promise<Message> msgPromise = new Promise<Message>();
        this.coordinator = new JChannel(props);
        this.modifyChannel(this.coordinator);
        this.coordinator.connect("testConnectSendMessageBothGRDownOnlyOneUp");
        this.coordinator.setReceiver(new PromisedMessageListener(msgPromise));
        this.channel = new JChannel(props);
        this.modifyChannel(this.channel);
        this.channel.connect("testConnectSendMessageBothGRDownOnlyOneUp");
        Util.sleep(1000L);
        this.gr1.stop();
        this.gr2.stop();
        this.gr1.start();
        Util.sleep(6000L);
        this.channel.send(new Message(null, null, (Serializable)((Object)"payload")));
        View view = this.coordinator.getView();
        assert (view.size() == 2);
        assert (view.containsMember(this.coordinator.getLocalAddress()));
        assert (view.containsMember(this.channel.getLocalAddress()));
        view = this.channel.getView();
        assert (view.size() == 2);
        assert (view.containsMember(this.coordinator.getLocalAddress()));
        assert (view.containsMember(this.channel.getLocalAddress()));
        Message msg = msgPromise.getResult(20000L);
        assert (msg != null);
        assert ("payload".equals(msg.getObject()));
    }

    public void testConnectSendMessageFirstGRDown() throws Exception {
        Promise<Message> msgPromise = new Promise<Message>();
        this.coordinator = new JChannel(props);
        this.modifyChannel(this.coordinator);
        this.coordinator.connect("testConnectSendMessageFirstGRDown");
        this.coordinator.setReceiver(new PromisedMessageListener(msgPromise));
        this.channel = new JChannel(props);
        this.modifyChannel(this.channel);
        this.channel.connect("testConnectSendMessageFirstGRDown");
        Util.sleep(1000L);
        this.gr1.stop();
        this.channel.send(new Message(null, null, (Serializable)((Object)"payload")));
        View view = this.coordinator.getView();
        assert (view.size() == 2);
        assert (view.containsMember(this.coordinator.getLocalAddress()));
        assert (view.containsMember(this.channel.getLocalAddress()));
        view = this.channel.getView();
        assert (view.size() == 2);
        assert (view.containsMember(this.coordinator.getLocalAddress()));
        assert (view.containsMember(this.channel.getLocalAddress()));
        Message msg = msgPromise.getResult(20000L);
        assert (msg != null);
        assert ("payload".equals(msg.getObject()));
    }

    static {
        try {
            bindAddress = Util.getBindAddress(null).getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PromisedMessageListener
    extends ReceiverAdapter {
        private final Promise<Message> promise;

        public PromisedMessageListener(Promise<Message> promise) {
            this.promise = promise;
        }

        @Override
        public void receive(Message msg) {
            this.promise.setResult(msg);
        }
    }
}

