/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.nio.ByteBuffer;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.debug.Simulator;
import org.jgroups.protocols.FRAG2;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-independent"})
public class FRAG2_Test
extends ChannelTestBase {
    private IpAddress a1;
    private Vector<Address> members;
    private View v;
    private Simulator s = null;
    private AtomicInteger num_done = new AtomicInteger(0);
    private Sender[] senders = null;
    public static final int SIZE = 10000;
    public static final int NUM_MSGS = 10;
    public static final int NUM_THREADS = 100;

    @BeforeMethod
    void setUp() throws Exception {
        this.a1 = new IpAddress(1111);
        this.members = new Vector();
        this.members.add(this.a1);
        this.v = new View(this.a1, 1L, this.members);
        this.s = new Simulator();
        this.s.setLocalAddress(this.a1);
        this.s.setView(this.v);
        this.s.addMember(this.a1);
        FRAG2 frag = new FRAG2();
        frag.setFragSize(512);
        Protocol[] stack = new Protocol[]{frag};
        this.s.setProtocolStack(stack);
        this.s.start();
    }

    @AfterMethod
    void tearDown() throws Exception {
        this.s.stop();
    }

    public void testFragmentation() throws InterruptedException {
        Sender sender;
        int i;
        Receiver r = new Receiver();
        this.s.setReceiver(r);
        this.senders = new Sender[100];
        for (i = 0; i < this.senders.length; ++i) {
            this.senders[i] = new Sender(i);
        }
        for (i = 0; i < this.senders.length; ++i) {
            sender = this.senders[i];
            sender.start();
        }
        for (i = 0; i < this.senders.length; ++i) {
            sender = this.senders[i];
            sender.join(5000L);
            if (!sender.isAlive()) continue;
            System.err.println("sender #" + i + " could not be joined (still alive): sender is " + sender);
            System.out.println("stack trace:\n" + Util.dumpThreads());
        }
        int sent = 0;
        int received = 0;
        int corrupted = 0;
        for (int i2 = 0; i2 < this.senders.length; ++i2) {
            Sender sender2 = this.senders[i2];
            received += sender2.getNumReceived();
            sent += sender2.getNumSent();
            corrupted += sender2.getNumCorrupted();
        }
        System.out.println("sent: " + sent + ", received: " + received + ", corrupted: " + corrupted);
        assert (sent == received) : "sent and received should be the same (sent=" + sent + ", received=" + received + ")";
        assert (corrupted == 0) : "we should have 0 corrupted messages";
    }

    class Receiver
    implements Simulator.Receiver {
        int received = 0;

        Receiver() {
        }

        public void receive(Event evt) {
            if (evt.getType() == 1) {
                ++this.received;
                Message msg = (Message)evt.getArg();
                byte[] data = msg.getBuffer();
                ByteBuffer buf = ByteBuffer.wrap(data);
                int id = buf.getInt();
                Sender sender = FRAG2_Test.this.senders[id];
                sender.verify(buf);
            }
        }
    }

    class Sender
    extends Thread {
        int id;
        int num_sent;
        int num_received;
        int num_corrupted;
        volatile boolean done;

        public int getIdent() {
            return this.id;
        }

        public int getNumReceived() {
            return this.num_received;
        }

        public int getNumSent() {
            return this.num_sent;
        }

        public int getNumCorrupted() {
            return this.num_corrupted;
        }

        public Sender(int id) {
            super("sender #" + id);
            this.id = -1;
            this.num_sent = 0;
            this.num_received = 0;
            this.num_corrupted = 0;
            this.done = false;
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] buf = this.createBuffer(this.id);
            for (int i = 0; i < 10; ++i) {
                Message msg = new Message(null, null, buf);
                Event evt = new Event(1, msg);
                FRAG2_Test.this.s.send(evt);
                ++this.num_sent;
            }
            Sender sender = this;
            synchronized (sender) {
                try {
                    while (!this.done) {
                        this.wait(500L);
                    }
                    FRAG2_Test.this.num_done.incrementAndGet();
                    System.out.println("thread #" + this.id + " is done (" + FRAG2_Test.this.num_done.get() + ")");
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }

        private byte[] createBuffer(int id) {
            ByteBuffer buf = ByteBuffer.allocate(10000);
            int elements = 2500;
            for (int i = 0; i < elements; ++i) {
                buf.putInt(id);
            }
            return buf.array();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void verify(ByteBuffer buf) {
            boolean corrupted = false;
            int num_elements = 2499;
            for (int i = 0; i < num_elements; ++i) {
                int tmp = buf.getInt();
                if (tmp == this.id) continue;
                corrupted = true;
                break;
            }
            if (corrupted) {
                ++this.num_corrupted;
            } else {
                ++this.num_received;
            }
            if (this.num_corrupted + this.num_received >= 10) {
                Sender sender = this;
                synchronized (sender) {
                    this.done = true;
                    this.notify();
                }
            }
        }

        public String toString() {
            return this.id + ": num_sent=" + this.num_sent + ", num_received=" + this.num_received + ", done=" + this.done;
        }
    }
}

