/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.LinkedList;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.tests.ChannelTestBase;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=false)
public class UnicastUnitTest
extends ChannelTestBase {
    JChannel ch1;
    JChannel ch2 = null;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.ch1 = this.createChannel(true, 2);
        this.ch2 = this.createChannel(this.ch1);
    }

    @AfterMethod
    protected void tearDown() throws Exception {
        if (this.ch2 != null) {
            this.ch2.close();
        }
        if (this.ch1 != null) {
            this.ch1.close();
        }
    }

    @Test
    public void testUnicastMessageInCallbackExistingMember() throws Exception {
        this.ch1.connect("UnicastUnitTest");
        MyReceiver receiver = new MyReceiver(this.ch1);
        this.ch1.setReceiver(receiver);
        this.ch2.connect("UnicastUnitTest");
        Exception ex = receiver.getEx();
        if (ex != null) {
            throw ex;
        }
        this.ch1.setReceiver(null);
    }

    private static class MyReceiver
    extends ReceiverAdapter {
        Channel channel;
        Exception ex;

        public MyReceiver(Channel channel) {
            this.channel = channel;
        }

        public Exception getEx() {
            return this.ex;
        }

        public void viewAccepted(View new_view) {
            Address local_addr = this.channel.getAddress();
            ChannelTestBase.assertNotNull(local_addr);
            System.out.println("[" + local_addr + "]: " + new_view);
            LinkedList<Address> members = new LinkedList<Address>(new_view.getMembers());
            ChannelTestBase.assertEquals("members=" + members + ", local_addr=" + local_addr, 2, members.size());
            members.remove(local_addr);
            ChannelTestBase.assertEquals(1, members.size());
            Address dest = (Address)members.get(0);
            Message unicast_msg = new Message(dest, null, null);
            try {
                this.channel.send(unicast_msg);
            }
            catch (Exception e) {
                this.ex = e;
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }
}

