/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.ExposedDataOutputStream;
import org.jgroups.util.Triple;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class MarshallerPool {
    final int pool_size;
    final int INITIAL_SIZE;
    final ExposedByteArrayOutputStream[] outs;
    final ExposedDataOutputStream[] outputs;
    final Lock[] locks;

    public MarshallerPool(int pool_size, int initial_size) {
        int i;
        this.pool_size = pool_size;
        this.INITIAL_SIZE = initial_size;
        this.outs = new ExposedByteArrayOutputStream[pool_size];
        for (i = 0; i < this.outs.length; ++i) {
            this.outs[i] = new ExposedByteArrayOutputStream(this.INITIAL_SIZE);
        }
        this.outputs = new ExposedDataOutputStream[pool_size];
        for (i = 0; i < this.outputs.length; ++i) {
            this.outputs[i] = new ExposedDataOutputStream(this.outs[i]);
        }
        this.locks = new Lock[pool_size];
        for (i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new ReentrantLock();
        }
    }

    public Triple<Lock, ExposedByteArrayOutputStream, ExposedDataOutputStream> getOutputStream() {
        int index = (int)Util.random(this.pool_size) - 1;
        return new Triple<Lock, ExposedByteArrayOutputStream, ExposedDataOutputStream>(this.locks[index], this.outs[index], this.outputs[index]);
    }

    public int[] getCapacities() {
        int[] retval = new int[this.pool_size];
        for (int i = 0; i < this.outs.length; ++i) {
            retval[i] = this.outs[i].getCapacity();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        for (int i = 0; i < this.pool_size; ++i) {
            try {
                this.locks[i].tryLock(2000L, TimeUnit.MILLISECONDS);
                Util.close(this.outputs[i]);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            finally {
                if (((ReentrantLock)this.locks[i]).isHeldByCurrentThread()) {
                    this.locks[i].unlock();
                }
            }
        }
    }
}

