/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.cluster.jgroups;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jgroups.Address;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.util.Util;
import org.ow2.orchestra.cluster.ClusterDescription;
import org.ow2.orchestra.cluster.JmxServer;
import org.ow2.orchestra.cluster.Server;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGroupsClusterDescription
implements ClusterDescription {
    private static final Logger LOG = Logger.getLogger(JGroupsClusterDescription.class.getName());
    private final JChannel channel;
    private final Map<Address, Server> servers = new HashMap<Address, Server>();

    public JGroupsClusterDescription(Properties orchestraProperties) {
        this(orchestraProperties, null);
    }

    public JGroupsClusterDescription(Properties orchestraProperties, String jGroupsConfiguration) {
        String jmxObjectName = orchestraProperties.getProperty("orchestra.jmx.objectName");
        String jmxServiceUrl = orchestraProperties.getProperty("orchestra.jmx.serviceUrl");
        try {
            jmxServiceUrl = jmxServiceUrl.replace("localhost", InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        final JmxServer localServer = new JmxServer(jmxServiceUrl, jmxObjectName);
        try {
            this.channel = new JChannel(jGroupsConfiguration);
            this.channel.setReceiver(new ExtendedReceiverAdapter(){

                public void receive(Message msg) {
                    Object obj;
                    Address src = msg.getSrc();
                    try {
                        obj = Util.objectFromByteBuffer(msg.getBuffer());
                    }
                    catch (Exception e) {
                        Misc.fastDynamicLog((Logger)LOG, (Level)Level.SEVERE, (String)"received invalid message %s", (Object[])new Object[]{msg});
                        return;
                    }
                    if (!(obj instanceof Server)) {
                        Misc.fastDynamicLog((Logger)LOG, (Level)Level.SEVERE, (String)"received invalid message %s", (Object[])new Object[]{msg});
                        return;
                    }
                    JGroupsClusterDescription.this.servers.put(src, (Server)obj);
                    Misc.fastDynamicLog((Logger)LOG, (Level)Level.INFO, (String)"received message %s -> %s", (Object[])new Object[]{msg, obj});
                    if (msg.getDest() == null) {
                        try {
                            Message replyMsg = new Message();
                            replyMsg.setBuffer(Util.objectToByteBuffer(localServer));
                            replyMsg.setDest(src);
                            JGroupsClusterDescription.this.channel.send(replyMsg);
                        }
                        catch (Exception e) {
                            Misc.fastDynamicLog((Logger)LOG, (Level)Level.SEVERE, (String)"exception while sending reply", (Object[])new Object[0]);
                        }
                    }
                }

                public void viewAccepted(View view) {
                    Misc.fastDynamicLog((Logger)LOG, (Level)Level.FINE, (String)"Cluster refreshed: %s", (Object[])new Object[]{view});
                    JGroupsClusterDescription.this.servers.keySet().retainAll(view.getMembers());
                }
            });
            this.channel.connect("orchestra-cluster");
            Message msg = new Message();
            msg.setBuffer(Util.objectToByteBuffer(localServer));
            this.channel.send(msg);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException((Throwable)e);
        }
    }

    public Collection<Server> getOrchestraServers() {
        return this.servers.values();
    }
}

