/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jgroups.Address;
import org.jgroups.BlockEvent;
import org.jgroups.Channel;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.GetStateEvent;
import org.jgroups.JChannel;
import org.jgroups.SetStateEvent;
import org.jgroups.UnblockEvent;
import org.jgroups.View;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.BasicTCP;
import org.jgroups.protocols.TCPPING;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.UDP;
import org.jgroups.protocols.pbcast.FLUSH;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.ResourceManager;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"base"}, sequential=true)
public class ChannelTestBase {
    protected String channel_conf = "udp.xml";
    protected boolean use_blocking = false;
    protected boolean use_flush = false;
    private String bind_addr = null;
    protected final Log log = LogFactory.getLog(this.getClass());

    @BeforeClass
    @Parameters(value={"channel.conf", "use_blocking"})
    protected void initializeBase(@Optional(value="udp.xml") String chconf, @Optional(value="false") String use_blocking) throws Exception {
        Test annotation = this.getClass().getAnnotation(Test.class);
        if (annotation == null) {
            throw new Exception("Test is not marked with @Test annotation");
        }
        StackType type = Util.getIpStackType();
        this.bind_addr = type == StackType.IPv6 ? "::1" : "127.0.0.1";
        List<String> groups = Arrays.asList(annotation.groups());
        boolean testRequiresFlush = groups.contains("flush");
        this.use_blocking = testRequiresFlush || Boolean.parseBoolean(use_blocking);
        this.use_flush = testRequiresFlush;
        this.channel_conf = chconf;
        boolean ignore_systemprops = Util.isBindAddressPropertyIgnored();
        this.bind_addr = Util.getProperty(new String[]{"jgroups.bind_addr", "bind.address"}, null, "bind_addr", ignore_systemprops, this.bind_addr);
    }

    @BeforeMethod
    protected static void startTestHeader(Method m) {
        System.out.println("\n================ Starting test " + m.getName() + " ================\n");
    }

    @AfterClass(alwaysRun=true)
    protected void nullifyInstanceFields() {
        Class<?> current = this.getClass();
        while (current.getSuperclass() != null) {
            Field[] fields;
            for (Field f : fields = current.getDeclaredFields()) {
                try {
                    if (Modifier.isStatic(f.getModifiers()) || f.getDeclaringClass().isPrimitive()) continue;
                    f.setAccessible(true);
                    f.set(this, null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            current = current.getSuperclass();
        }
    }

    protected String getBindAddress() {
        return this.bind_addr;
    }

    protected boolean useBlocking() {
        return this.use_blocking;
    }

    protected void setUseBlocking(boolean flag) {
        this.use_blocking = flag;
    }

    protected boolean useFlush() {
        return this.use_flush;
    }

    protected static final void assertTrue(boolean condition) {
        Util.assertTrue(condition);
    }

    protected static final void assertTrue(String message, boolean condition) {
        Util.assertTrue(message, condition);
    }

    protected static final void assertFalse(boolean condition) {
        Util.assertFalse(condition);
    }

    protected static final void assertFalse(String message, boolean condition) {
        Util.assertFalse(message, condition);
    }

    protected static final void assertEquals(String message, Object val1, Object val2) {
        Util.assertEquals(message, val1, val2);
    }

    protected static final void assertEquals(Object val1, Object val2) {
        Util.assertEquals(null, val1, val2);
    }

    protected static final void assertNotNull(String message, Object val) {
        Util.assertNotNull(message, val);
    }

    protected static final void assertNotNull(Object val) {
        Util.assertNotNull(null, val);
    }

    protected static final void assertNull(String message, Object val) {
        Util.assertNull(message, val);
    }

    protected static final void assertNull(Object val) {
        Util.assertNotNull(null, val);
    }

    protected JChannel createChannel(boolean unique, int num) throws Exception {
        return (JChannel)new DefaultChannelTestFactory().createChannel(unique, num);
    }

    protected JChannel createChannel(boolean unique, int num, String name) throws Exception {
        JChannel ch = (JChannel)new DefaultChannelTestFactory().createChannel(unique, num);
        ch.setName(name);
        return ch;
    }

    protected JChannel createChannel() throws Exception {
        return new DefaultChannelTestFactory().createChannel();
    }

    protected JChannel createChannel(boolean unique) throws Exception {
        return this.createChannel(unique, 2);
    }

    protected JChannel createChannel(JChannel ch) throws Exception {
        return (JChannel)new DefaultChannelTestFactory().createChannel(ch);
    }

    protected JChannel createChannel(JChannel ch, String name) throws Exception {
        JChannel retval = (JChannel)new DefaultChannelTestFactory().createChannel(ch);
        retval.setName(name);
        return retval;
    }

    protected static String getUniqueClusterName() {
        return ChannelTestBase.getUniqueClusterName(null);
    }

    protected static String getUniqueClusterName(String base_name) {
        return ResourceManager.getUniqueClusterName(base_name);
    }

    protected void logChannelResources(Channel ch) {
        ProtocolStack stack = ch.getProtocolStack();
        TP transport = stack.getTransport();
        if (transport instanceof UDP) {
            this.log.debug("(udp.mcast_addr, udp.mcast_port) = (" + ((UDP)transport).getMulticastAddress() + ", " + ((UDP)transport).getMulticastPort() + ")");
        } else if (transport instanceof BasicTCP) {
            this.log.debug("(tcp.bind_port, tcp.port_range) = (" + transport.getBindPort() + ", " + transport.getPortRange() + ")");
        } else {
            throw new IllegalStateException("Only UDP and TCP are supported as transport protocols");
        }
    }

    protected static void checkEventStateTransferSequence(EventSequence receiver) {
        List<Object> events = receiver.getEvents();
        ChannelTestBase.assertNotNull(events);
        String validSequence = "([b][vgs]*[u])+";
        try {
            ChannelTestBase.assertTrue("Invalid event sequence " + events, ChannelTestBase.validateEventString(ChannelTestBase.translateEventTrace(events), "([b][vgs]*[u])+"));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)("Invalid event sequence " + events));
        }
    }

    protected static String translateEventTrace(List<Object> et) throws Exception {
        StringBuilder eventString = new StringBuilder();
        for (Object obj : et) {
            if (obj instanceof BlockEvent) {
                eventString.append("b");
                continue;
            }
            if (obj instanceof UnblockEvent) {
                eventString.append("u");
                continue;
            }
            if (obj instanceof SetStateEvent) {
                eventString.append("s");
                continue;
            }
            if (obj instanceof GetStateEvent) {
                eventString.append("g");
                continue;
            }
            if (obj instanceof View) {
                eventString.append("v");
                continue;
            }
            throw new Exception("Unrecognized event type in event trace");
        }
        String s = eventString.toString();
        while (s.endsWith("b")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    protected static boolean validateEventString(String eventString, String spec) {
        Pattern pattern = null;
        Matcher matcher = null;
        pattern = Pattern.compile(spec);
        matcher = pattern.matcher(eventString);
        if (matcher.find()) {
            if (matcher.start() != 0 || matcher.end() != eventString.length()) {
                System.err.println("event string invalid (proper substring matched): event string = " + eventString + ", specification = " + spec + "matcher.start() " + matcher.start() + " matcher.end() " + matcher.end());
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    protected abstract class PushChannelApplicationWithSemaphore
    extends ChannelApplication {
        protected Semaphore semaphore;

        public PushChannelApplicationWithSemaphore(String name, Semaphore semaphore) throws Exception {
            super(name);
            this.semaphore = semaphore;
        }

        public PushChannelApplicationWithSemaphore(JChannel copySource, String name, Semaphore semaphore) throws Exception {
            super(copySource, name);
            this.semaphore = semaphore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean acquired = false;
            try {
                acquired = this.semaphore.tryAcquire(60000L, TimeUnit.MILLISECONDS);
                if (!acquired) {
                    throw new Exception(this.channel.getAddress() + ": cannot acquire semaphore");
                }
                this.useChannel();
            }
            catch (Exception e) {
                this.exception = e;
            }
            finally {
                if (acquired) {
                    this.semaphore.release();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class ChannelApplication
    extends ExtendedReceiverAdapter
    implements EventSequence,
    Runnable {
        protected Channel channel;
        protected Thread thread;
        protected Throwable exception;
        protected List<Object> events;

        public ChannelApplication(String name) throws Exception {
            this.channel = ChannelTestBase.this.createChannel(true, 4);
            this.init(name);
        }

        public ChannelApplication(JChannel copySource, String name) throws Exception {
            this.channel = ChannelTestBase.this.createChannel(copySource);
            this.init(name);
        }

        protected void init(String name) {
            this.events = Collections.synchronizedList(new LinkedList());
            this.channel.setName(name);
            this.channel.setReceiver(this);
        }

        protected abstract void useChannel() throws Exception;

        @Override
        public void run() {
            try {
                this.useChannel();
            }
            catch (Exception e) {
                ChannelTestBase.this.log.error(this.channel.getName() + ": " + e.getLocalizedMessage(), e);
                this.exception = e;
            }
        }

        public List<Address> getMembers() {
            Vector<Address> result = null;
            View v = this.channel.getView();
            if (v != null) {
                result = v.getMembers();
            }
            return result;
        }

        public Address getLocalAddress() {
            return this.channel.getAddress();
        }

        public void start() {
            this.thread = new Thread((Runnable)this, this.getName());
            this.thread.start();
        }

        public Channel getChannel() {
            return this.channel;
        }

        @Override
        public String getName() {
            return this.channel != null ? this.channel.getName() : "n/a";
        }

        public void cleanup() {
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
            }
            try {
                this.channel.close();
            }
            catch (Throwable t) {
                ChannelTestBase.this.log.warn("Exception while closing channel " + this.getName(), t);
            }
        }

        @Override
        public List<Object> getEvents() {
            return this.events;
        }

        @Override
        public void block() {
            this.events.add(new BlockEvent());
        }

        @Override
        public byte[] getState() {
            this.events.add(new GetStateEvent(null, null));
            return null;
        }

        @Override
        public void getState(OutputStream ostream) {
            this.events.add(new GetStateEvent(null, null));
        }

        @Override
        public byte[] getState(String state_id) {
            this.events.add(new GetStateEvent(null, state_id));
            return null;
        }

        @Override
        public void getState(String state_id, OutputStream ostream) {
            this.events.add(new GetStateEvent(null, state_id));
        }

        @Override
        public void setState(byte[] state) {
            this.events.add(new SetStateEvent(null, null));
        }

        @Override
        public void setState(InputStream istream) {
            this.events.add(new SetStateEvent(null, null));
        }

        @Override
        public void setState(String state_id, byte[] state) {
            this.events.add(new SetStateEvent(null, null));
        }

        @Override
        public void setState(String state_id, InputStream istream) {
            this.events.add(new SetStateEvent(null, null));
        }

        @Override
        public void unblock() {
            this.events.add(new UnblockEvent());
        }

        @Override
        public void viewAccepted(View new_view) {
            this.events.add(new_view);
            ChannelTestBase.this.log.info(this.getLocalAddress() + ": view=" + new_view);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface EventSequence {
        public List<Object> getEvents();

        public String getName();
    }

    protected class DefaultChannelTestFactory {
        protected DefaultChannelTestFactory() {
        }

        public JChannel createChannel() throws Exception {
            return this.createChannel(ChannelTestBase.this.channel_conf);
        }

        public Channel createChannel(boolean unique, int num) throws Exception {
            JChannel c = this.createChannel(ChannelTestBase.this.channel_conf);
            if (unique) {
                this.makeUnique(c, num);
            }
            if (ChannelTestBase.this.log.isDebugEnabled()) {
                ChannelTestBase.this.log.debug("Modifying channel resources:");
                ChannelTestBase.this.logChannelResources(c);
            }
            return c;
        }

        public Channel createChannel(JChannel ch) throws Exception {
            HashMap<Integer, Boolean> channelOptions = new HashMap<Integer, Boolean>();
            boolean useBlocking = (Boolean)ch.getOpt(0);
            channelOptions.put(0, useBlocking);
            ChannelTestBase.this.log.info("Using configuration file " + ChannelTestBase.this.channel_conf);
            JChannel retval = new JChannel(ch);
            for (Map.Entry entry : channelOptions.entrySet()) {
                Integer key = (Integer)entry.getKey();
                Object value = entry.getValue();
                retval.setOpt(key, value);
            }
            if (ChannelTestBase.this.useFlush()) {
                Util.addFlush(retval, new FLUSH());
            }
            if (ChannelTestBase.this.log.isDebugEnabled()) {
                ChannelTestBase.this.log.debug("Creating cloned channel with resources:");
                ChannelTestBase.this.logChannelResources(retval);
            }
            return retval;
        }

        private JChannel createChannel(String configFile) throws Exception {
            HashMap<Integer, Boolean> channelOptions = new HashMap<Integer, Boolean>();
            channelOptions.put(0, ChannelTestBase.this.useBlocking());
            ChannelTestBase.this.log.info("Using configuration file " + configFile);
            JChannel ch = new JChannel(configFile);
            for (Map.Entry entry : channelOptions.entrySet()) {
                Integer key = (Integer)entry.getKey();
                Object value = entry.getValue();
                ch.setOpt(key, value);
            }
            if (ChannelTestBase.this.useFlush()) {
                Util.addFlush(ch, new FLUSH());
            }
            if (ChannelTestBase.this.log.isDebugEnabled()) {
                ChannelTestBase.this.log.debug("Creating channel with resources:");
                ChannelTestBase.this.logChannelResources(ch);
            }
            return ch;
        }

        protected void makeUnique(Channel channel, int num) throws Exception {
            String str = Util.getProperty(new String[]{"jgroups.udp.mcast_addr", "jboss.partition.udpGroup"}, null, "mcast_addr", false, null);
            if (str != null) {
                this.makeUnique(channel, num, str);
            } else {
                this.makeUnique(channel, num, null);
            }
        }

        protected void makeUnique(Channel channel, int num, String mcast_address) throws Exception {
            ProtocolStack stack = channel.getProtocolStack();
            TP transport = stack.getTransport();
            if (transport instanceof UDP) {
                short mcast_port = ResourceManager.getNextMulticastPort(InetAddress.getByName(ChannelTestBase.this.bind_addr));
                ((UDP)transport).setMulticastPort(mcast_port);
                if (mcast_address != null) {
                    ((UDP)transport).setMulticastAddress(InetAddress.getByName(mcast_address));
                } else {
                    String mcast_addr = ResourceManager.getNextMulticastAddress();
                    ((UDP)transport).setMulticastAddress(InetAddress.getByName(mcast_addr));
                }
            } else if (transport instanceof BasicTCP) {
                List<Short> ports = ResourceManager.getNextTcpPorts(InetAddress.getByName(ChannelTestBase.this.bind_addr), num);
                transport.setBindPort(ports.get(0).shortValue());
                transport.setPortRange(num);
                Protocol ping = stack.findProtocol(TCPPING.class);
                if (ping == null) {
                    throw new IllegalStateException("TCP stack must consist of TCP:TCPPING - other config are not supported");
                }
                LinkedList<String> initial_hosts = new LinkedList<String>();
                for (short port : ports) {
                    initial_hosts.add(ChannelTestBase.this.bind_addr + "[" + port + "]");
                }
                String tmp = Util.printListWithDelimiter(initial_hosts, ",");
                List<IpAddress> init_hosts = Util.parseCommaDelimitedHosts(tmp, 1);
                ((TCPPING)ping).setInitialHosts(init_hosts);
            } else {
                throw new IllegalStateException("Only UDP and TCP are supported as transport protocols");
            }
        }
    }
}

