/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.DELAY_JOIN_REQ;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class JoinTest
extends ChannelTestBase {
    JChannel c1;
    JChannel c2;

    @BeforeMethod
    public void setUp() throws Exception {
        this.c1 = this.createChannel(true, 2);
        this.c2 = this.createChannel(this.c1);
    }

    @AfterMethod
    public void tearDown() throws Exception {
        Util.close(this.c2, this.c1);
    }

    @Test
    public void testSingleJoin() throws ChannelException {
        this.c1.connect("JoinTest");
        View v = this.c1.getView();
        assert (v != null);
        assert (v.size() == 1);
    }

    @Test
    public void testJoinsOnTwoChannels() throws ChannelException {
        this.c1.connect("JoinTest");
        this.c2.connect("JoinTest");
        Util.sleep(2000L);
        View v1 = this.c1.getView();
        View v2 = this.c2.getView();
        System.out.println("v1=" + v1 + ", v2=" + v2);
        assert (v1 != null);
        assert (v2 != null);
        assert (v1.size() == 2);
        assert (v2.size() == 2);
        assert (v1.equals(v2));
    }

    @Test
    public void testJoinsOnTwoChannelsAndSend() throws ChannelException {
        this.c1.connect("JoinTest");
        this.c2.connect("JoinTest");
        MyReceiver r1 = new MyReceiver("c1");
        MyReceiver r2 = new MyReceiver("c2");
        this.c1.setReceiver(r1);
        this.c2.setReceiver(r2);
        Message m1 = new Message(null, null, (Serializable)((Object)"message-1"));
        Message m2 = new Message(null, null, (Serializable)((Object)"message-2"));
        this.c1.connect("JoinTest-2");
        View view = this.c1.getView();
        assert (view.size() == 2) : "c1's view: " + view;
        this.c2.connect("JoinTest-2");
        view = this.c2.getView();
        assert (view.size() == 2) : "c2's view: " + view;
        Util.sleep(200L);
        view = this.c1.getView();
        assert (view.size() == 2) : "c1's view: " + view;
        this.c1.send(m1);
        this.c2.send(m2);
        Util.sleep(1500L);
        List<String> c1_list = r1.getMsgs();
        List<String> c2_list = r2.getMsgs();
        System.out.println("c1: " + c1_list.size() + " msgs, c2: " + c2_list.size() + " msgs");
        assert (c1_list.size() == 2) : "cl_list: " + c1_list;
        assert (c2_list.size() == 2) : "c2_list: " + c2_list;
        assert (c1_list.contains("message-1"));
        assert (c2_list.contains("message-1"));
        assert (c1_list.contains("message-2"));
        assert (c2_list.contains("message-2"));
    }

    @Test
    public void testDelayedJoinResponse() throws Exception {
        long JOIN_TIMEOUT = 2000L;
        long DELAY_JOIN_REQ2 = 4000L;
        long DISCOVERY_TIMEOUT = 5000L;
        long TOLERANCE = 1000L;
        this._testDelayedJoinResponse(5000L, 2000L, 4000L, 1000L);
    }

    @Test
    public void testDelayedJoinResponse2() throws Exception {
        long JOIN_TIMEOUT = 2000L;
        long DELAY_JOIN_REQ2 = 4000L;
        long DISCOVERY_TIMEOUT = 5000L;
        long TOLERANCE = 1000L;
        this._testDelayedJoinResponse(5000L, 2000L, 4000L, 1000L);
    }

    @Test
    public void testDelayedJoinResponse3() throws Exception {
        long JOIN_TIMEOUT = 5000L;
        long DELAY_JOIN_REQ2 = 4000L;
        long DISCOVERY_TIMEOUT = 5000L;
        long TOLERANCE = 1000L;
        this._testDelayedJoinResponse(5000L, 5000L, 4000L, 1000L);
    }

    @Test
    public void testDelayedJoinResponse4() throws Exception {
        long JOIN_TIMEOUT = 1000L;
        long DELAY_JOIN_REQ2 = 4000L;
        long DISCOVERY_TIMEOUT = 2000L;
        long TOLERANCE = 1000L;
        this._testDelayedJoinResponse(2000L, 1000L, 4000L, 1000L);
    }

    void _testDelayedJoinResponse(long discovery_timeout, long join_timeout, long delay_join_req, long tolerance) throws Exception {
        Discovery discovery;
        this.c1.connect("JoinTest");
        this.c2.connect("JoinTest");
        ProtocolStack stack = this.c2.getProtocolStack();
        GMS gms = (GMS)stack.findProtocol("GMS");
        if (gms != null) {
            gms.setJoinTimeout(join_timeout);
        }
        if ((discovery = (Discovery)stack.findProtocol(Discovery.class)) != null) {
            discovery.setNumInitialMembers(10);
            discovery.setTimeout(discovery_timeout);
        }
        stack = this.c1.getProtocolStack();
        DELAY_JOIN_REQ delay = new DELAY_JOIN_REQ();
        delay.setDelay(delay_join_req);
        stack.insertProtocol((Protocol)delay, 2, "GMS");
        System.out.println(new Date() + ": joining c2");
        long start = System.currentTimeMillis();
        this.c2.connect("JoinTest-2");
        long stop = System.currentTimeMillis();
        long join_time = stop - start;
        long tolerated_join_time = discovery_timeout + delay_join_req + tolerance;
        System.out.println(new Date() + ": joining of c2 took " + join_time + " ms (should have taken not more than " + tolerated_join_time + " ms)");
        assert (join_time <= tolerated_join_time) : "join time (" + join_time + ") was > tolerated join time (" + tolerated_join_time + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReceiver
    extends ReceiverAdapter {
        private final String name;
        private final List<String> msgs;

        public MyReceiver(String name) {
            this.name = name;
            this.msgs = Collections.synchronizedList(new ArrayList());
        }

        public List<String> getMsgs() {
            return this.msgs;
        }

        public void clear() {
            this.msgs.clear();
        }

        @Override
        public void receive(Message msg) {
            String s = (String)msg.getObject();
            this.msgs.add(s);
            System.out.println("[" + this.name + "] received " + s + " from " + msg.getSrc());
        }

        @Override
        public void viewAccepted(View new_view) {
            System.out.println("[" + this.name + "] view: " + new_view);
        }
    }
}

