/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Arrays;
import java.util.List;
import org.jgroups.conf.PropertyConverter;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.stack.Protocol;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, sequential=false)
public class PropertyConvertersTest {
    public static void testPrimitiveTypes() throws Exception {
        PropertyConverters.Default conv = new PropertyConverters.Default();
        PropertyConvertersTest.check(null, Boolean.TYPE, "true", true, conv);
        PropertyConvertersTest.check(null, Integer.TYPE, "322649", 322649, conv);
        PropertyConvertersTest.check(null, Long.TYPE, "322649", 322649L, conv);
    }

    public static void testLongArray() throws Exception {
        PropertyConverters.LongArray conv = new PropertyConverters.LongArray();
        long[] array = new long[]{1L, 2L, 3L, 4L, 5L};
        PropertyConvertersTest.checkArray(null, array.getClass(), "1,2,3,4,5", array, conv);
    }

    public static void testNetworkList() throws Exception {
        PropertyConverters.NetworkInterfaceList conv = new PropertyConverters.NetworkInterfaceList();
        Object tmp = conv.convert(null, List.class, "bela", "lo", false);
        String str = conv.toString(tmp);
        System.out.println("str = " + str);
        assert (str.equals("lo"));
    }

    private static void check(Protocol protocol, Class<?> type, String prop, Object result, PropertyConverter converter) throws Exception {
        Object tmp = converter.convert(protocol, type, "bela", prop, false);
        assert (tmp.equals(result)) : " conversion result: " + tmp + " (" + tmp.getClass() + ")" + ", expected result: " + result + " (" + result.getClass() + ")";
        String output = converter.toString(tmp);
        assert (output.equals(prop)) : "output=" + output + ", prop=" + prop;
    }

    private static void checkArray(Protocol protocol, Class<?> type, String prop, Object result, PropertyConverter converter) throws Exception {
        Object tmp = converter.convert(protocol, type, "bela", prop, false);
        assert (Arrays.equals((long[])tmp, (long[])result)) : " conversion result: " + tmp + " (" + tmp.getClass() + ")" + ", expected result: " + result + " (" + result.getClass() + ")";
        String output = converter.toString(tmp);
        assert (output.equals(prop)) : "output=" + output + ", prop=" + prop;
    }
}

