/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jgroups.logging.Log;

public class JDKLogImpl
implements Log {
    private final Logger logger;

    public JDKLogImpl(String category) {
        this.logger = Logger.getLogger(category);
    }

    public JDKLogImpl(Class category) {
        this.logger = Logger.getLogger(category.toString());
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public void trace(String msg) {
        this.logger.log(Level.FINER, msg);
    }

    public void trace(Object msg) {
        this.logger.log(Level.FINER, msg.toString());
    }

    public void debug(String msg) {
        this.logger.log(Level.FINE, msg);
    }

    public void info(String msg) {
        this.logger.log(Level.INFO, msg);
    }

    public void warn(String msg) {
        this.logger.log(Level.WARNING, msg);
    }

    public void error(String msg) {
        this.logger.log(Level.SEVERE, msg);
    }

    public void fatal(String msg) {
        this.logger.log(Level.SEVERE, msg);
    }

    public void trace(Object msg, Throwable t) {
        this.logger.log(Level.FINER, msg.toString(), t);
    }

    public void trace(String msg, Throwable t) {
        this.logger.log(Level.FINER, msg, t);
    }

    public void debug(String msg, Throwable t) {
        this.logger.log(Level.FINE, msg, t);
    }

    public void info(String msg, Throwable t) {
        this.logger.log(Level.INFO, msg, t);
    }

    public void warn(String msg, Throwable t) {
        this.logger.log(Level.WARNING, msg, t);
    }

    public void error(String msg, Throwable t) {
        this.logger.log(Level.SEVERE, msg, t);
    }

    public void fatal(String msg, Throwable t) {
        this.logger.log(Level.SEVERE, msg, t);
    }

    public String getLevel() {
        Level level = this.logger.getLevel();
        return level != null ? level.toString() : "off";
    }

    public void setLevel(String level) {
        Level new_level = JDKLogImpl.strToLevel(level);
        if (new_level != null) {
            this.logger.setLevel(new_level);
        }
    }

    private static Level strToLevel(String level) {
        if (level == null) {
            return null;
        }
        if ((level = level.toLowerCase().trim()).equals("fatal")) {
            return Level.SEVERE;
        }
        if (level.equals("error")) {
            return Level.SEVERE;
        }
        if (level.equals("warn")) {
            return Level.WARNING;
        }
        if (level.equals("warning")) {
            return Level.WARNING;
        }
        if (level.equals("info")) {
            return Level.INFO;
        }
        if (level.equals("debug")) {
            return Level.FINE;
        }
        if (level.equals("trace")) {
            return Level.FINER;
        }
        return null;
    }
}

