/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.jgroups.util.Range;
import org.jgroups.util.Seqno;
import org.jgroups.util.SeqnoComparator;
import org.jgroups.util.SeqnoRange;
import org.jgroups.util.Util;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, sequential=false)
public class SeqnoTest {
    public static void testConstructor() {
        SeqnoRange range = new SeqnoRange(10L, 10L);
        System.out.println(SeqnoTest.print(range));
        assert (range.size() == 1);
        assert (range.getLow() == 10L);
        assert (range.getHigh() == 10L);
        assert (range.contains(10L));
        assert (!range.contains(11L));
        range = new SeqnoRange(10L, 15L);
        System.out.println(SeqnoTest.print(range));
        assert (range.size() == 6);
        assert (range.getLow() == 10L);
        assert (range.getHigh() == 15L);
        assert (range.contains(10L));
        assert (range.contains(14L));
    }

    public static void testSetAndGetWith1Seqno() {
        SeqnoRange range = new SeqnoRange(10L, 10L);
        assert (((Seqno)range).getNumberOfMissingMessages() == 1);
        assert (((Seqno)range).getNumberOfReceivedMessages() == 0);
        ((Seqno)range).set(10L);
        assert (((Seqno)range).getNumberOfMissingMessages() == 0);
        assert (((Seqno)range).getNumberOfReceivedMessages() == 1);
        assert (((Seqno)range).get(10L));
        ((Seqno)range).clear(10L);
        assert (!((Seqno)range).get(10L));
        assert (((Seqno)range).getNumberOfMissingMessages() == 1);
        assert (((Seqno)range).getNumberOfReceivedMessages() == 0);
    }

    public static void testSetAndGetWith5Seqnos() {
        SeqnoRange range = new SeqnoRange(10L, 15L);
        System.out.println("range=" + SeqnoTest.print(range));
        assert (range.size() == 6);
        assert (range.getNumberOfMissingMessages() == 6);
        assert (range.getNumberOfReceivedMessages() == 0);
        range.set(10L);
        assert (range.getNumberOfMissingMessages() == 5);
        assert (range.getNumberOfReceivedMessages() == 1);
        assert (range.get(10L));
        range.set(13L);
        assert (range.size() == 6);
        assert (range.getNumberOfMissingMessages() == 4);
        assert (range.getNumberOfReceivedMessages() == 2);
        range.set(13L);
        assert (range.size() == 6);
        assert (range.getNumberOfMissingMessages() == 4);
        assert (range.getNumberOfReceivedMessages() == 2);
        System.out.println("range=" + SeqnoTest.print(range));
        Collection<Range> xmits = range.getMessagesToRetransmit();
        Collection<Range> cleared_bits = range.getBits(false);
        System.out.println("xmits = " + xmits);
        System.out.println("cleared_bits = " + cleared_bits);
        assert (((Object)xmits).equals(cleared_bits));
    }

    public static void testSet() {
        SeqnoRange range = new SeqnoRange(10L, 15L);
        range.set(11L, 12L, 13L, 14L);
        System.out.println("range=" + SeqnoTest.print(range));
        assert (range.size() == 6);
        assert (range.getNumberOfReceivedMessages() == 4);
        assert (range.getNumberOfMissingMessages() == 2);
        Collection<Range> xmits = range.getMessagesToRetransmit();
        assert (xmits.size() == 2);
        Iterator<Range> it = xmits.iterator();
        Range r = it.next();
        assert (r.low == 10L && r.high == 10L);
        r = it.next();
        assert (r.low == 15L && r.high == 15L);
        range = new SeqnoRange(10L, 15L);
        range.set(10L, 11L, 12L, 13L, 14L);
        System.out.println("range=" + SeqnoTest.print(range));
        assert (range.size() == 6);
        assert (range.getNumberOfReceivedMessages() == 5);
        assert (range.getNumberOfMissingMessages() == 1);
        xmits = range.getMessagesToRetransmit();
        assert (xmits.size() == 1);
        it = xmits.iterator();
        r = it.next();
        assert (r.low == 15L && r.high == 15L);
        range = new SeqnoRange(10L, 15L);
        range.set(11L, 12L, 13L, 14L, 15L);
        System.out.println("range=" + SeqnoTest.print(range));
        assert (range.size() == 6);
        assert (range.getNumberOfReceivedMessages() == 5);
        assert (range.getNumberOfMissingMessages() == 1);
        xmits = range.getMessagesToRetransmit();
        assert (xmits.size() == 1);
        it = xmits.iterator();
        r = it.next();
        assert (r.low == 10L && r.high == 10L);
        range = new SeqnoRange(10L, 15L);
        range.set(10L, 11L, 12L, 13L, 14L, 15L);
        System.out.println("range=" + SeqnoTest.print(range));
        assert (range.size() == 6);
        assert (range.getNumberOfReceivedMessages() == 6);
        assert (range.getNumberOfMissingMessages() == 0);
        xmits = range.getMessagesToRetransmit();
        assert (xmits.isEmpty());
        range = new SeqnoRange(10L, 15L);
        range.set(11L, 12L, 14L, 15L);
        System.out.println("range=" + SeqnoTest.print(range));
        assert (range.size() == 6);
        assert (range.getNumberOfReceivedMessages() == 4);
        assert (range.getNumberOfMissingMessages() == 2);
        xmits = range.getMessagesToRetransmit();
        assert (xmits.size() == 2);
        it = xmits.iterator();
        r = it.next();
        assert (r.low == 10L && r.high == 10L);
        r = it.next();
        assert (r.low == 13L && r.high == 13L);
        range.set(13L);
        assert (range.getNumberOfReceivedMessages() == 5);
        assert (range.getNumberOfMissingMessages() == 1);
        xmits = range.getMessagesToRetransmit();
        it = xmits.iterator();
        r = it.next();
        assert (r.low == 10L && r.high == 10L);
        range.set(10L);
        System.out.println("range=" + SeqnoTest.print(range));
        assert (range.getNumberOfReceivedMessages() == 6);
        assert (range.getNumberOfMissingMessages() == 0);
        xmits = range.getMessagesToRetransmit();
        assert (xmits.isEmpty());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public static void testSetOfInvalidIndex() {
        SeqnoRange range = new SeqnoRange(10L, 10L);
        range.set(9L);
    }

    public static void testCompareTo() {
        Seqno[] ranges;
        TreeMap<Seqno, Seqno> map = new TreeMap<Seqno, Seqno>(new SeqnoComparator());
        for (Seqno range : ranges = new Seqno[]{new SeqnoRange(900L, 905L), new Seqno(222L), new SeqnoRange(700L, 800L), new SeqnoRange(23L, 200L)}) {
            map.put(range, range);
        }
        System.out.println("map = " + map.keySet());
        assert (map.size() == ranges.length);
        for (long num : new long[]{0L, 1L, 201L, 202L, 223L, 1000L}) {
            SeqnoTest.checkNull(map, num);
        }
        SeqnoTest.checkInRange(map, 23L, 23L, 200L);
        SeqnoTest.checkInRange(map, 100L, 23L, 200L);
        SeqnoTest.checkInRange(map, 200L, 23L, 200L);
        SeqnoTest.checkInRange(map, 222L, 222L, 222L);
        SeqnoTest.checkInRange(map, 750L, 700L, 800L);
        SeqnoTest.checkInRange(map, 905L, 900L, 905L);
    }

    public static void testCompareTo2() {
        Seqno[] ranges;
        TreeMap<Seqno, Seqno> map = new TreeMap<Seqno, Seqno>(new SeqnoComparator());
        for (Seqno range : ranges = new Seqno[]{new SeqnoRange(900L, 905L), new Seqno(550L), new Seqno(222L), new SeqnoRange(700L, 800L), new Seqno(650L), new SeqnoRange(23L, 200L)}) {
            map.put(range, range);
        }
        System.out.println("map = " + map.keySet());
        assert (map.size() == 6);
        for (long num : new long[]{0L, 1L, 201L, 202L, 223L, 1000L}) {
            SeqnoTest.checkNull(map, num);
        }
        SeqnoTest.checkInRange(map, 550L, 550L, 550L);
        SeqnoTest.checkInRange(map, 650L, 650L, 650L);
        SeqnoTest.checkInRange(map, 23L, 23L, 200L);
        SeqnoTest.checkInRange(map, 100L, 23L, 200L);
        SeqnoTest.checkInRange(map, 200L, 23L, 200L);
        SeqnoTest.checkInRange(map, 222L, 222L, 222L);
        SeqnoTest.checkInRange(map, 750L, 700L, 800L);
        SeqnoTest.checkInRange(map, 905L, 900L, 905L);
    }

    public static void testLargeRange() {
        int num;
        SeqnoRange range = new SeqnoRange(0L, 1500L);
        TreeSet<Integer> sorted_set = new TreeSet<Integer>();
        for (int i = 0; i < 500; ++i) {
            num = (int)Util.random(1499L);
            sorted_set.add(num);
        }
        Iterator i$ = sorted_set.iterator();
        while (i$.hasNext()) {
            num = (Integer)i$.next();
            range.set((long)num);
        }
        int num_set = sorted_set.size();
        System.out.println("set " + num_set + " bits");
        assert (range.getNumberOfReceivedMessages() == num_set);
        Collection<Range> missing = range.getMessagesToRetransmit();
        System.out.println("missing = " + missing);
    }

    public static void testRemovalFromTreeMap() {
        Seqno range;
        Seqno[] ranges;
        TreeMap<Seqno, Seqno> map = new TreeMap<Seqno, Seqno>(new SeqnoComparator());
        for (Seqno range2 : ranges = new Seqno[]{new SeqnoRange(900L, 905L), new Seqno(222L), new Seqno(500L), new SeqnoRange(700L, 800L), new Seqno(801L), new SeqnoRange(23L, 200L)}) {
            map.put(range2, range2);
        }
        System.out.println("map = " + map.keySet());
        assert (map.size() == ranges.length);
        for (Seqno r : ranges) {
            range = (Seqno)map.get(r);
            assert (range != null);
            assert (range == r);
        }
        for (Seqno r : ranges) {
            range = (Seqno)map.remove(r);
            assert (range != null);
            assert (range == r);
        }
        assert (map.isEmpty());
    }

    public static void testRemovalFromHashMap() {
        Seqno range;
        Seqno[] ranges;
        ConcurrentHashMap<Seqno, Seqno> map = new ConcurrentHashMap<Seqno, Seqno>();
        for (Seqno range2 : ranges = new Seqno[]{new SeqnoRange(900L, 905L), new Seqno(222L), new SeqnoRange(700L, 800L), new SeqnoRange(23L, 200L), new Seqno(201L), new Seqno(205L)}) {
            map.put(range2, range2);
        }
        System.out.println("map = " + map.keySet());
        assert (map.size() == ranges.length);
        for (Seqno r : ranges) {
            range = (Seqno)map.get(r);
            assert (range != null);
            assert (range == r);
        }
        for (Seqno r : ranges) {
            range = (Seqno)map.remove(r);
            assert (range != null);
            assert (range == r);
        }
        assert (map.isEmpty());
    }

    private static void checkInRange(Map<Seqno, Seqno> map, long seqno, long from, long to) {
        Seqno val = map.get(new Seqno(seqno, true));
        System.out.println("seqno=" + seqno + ", val = " + val);
        assert (val != null);
        assert (val.contains(seqno));
        assert (val.getLow() == from);
        if (val instanceof SeqnoRange) assert (((SeqnoRange)val).getHigh() == to);
    }

    private static void checkNull(Map<Seqno, Seqno> map, long seqno) {
        Seqno val = map.get(new Seqno(seqno, true));
        assert (val == null);
    }

    private static String print(Seqno seqno) {
        StringBuilder sb = new StringBuilder();
        sb.append(seqno.toString());
        sb.append(", size= " + seqno.size());
        if (seqno instanceof SeqnoRange) {
            sb.append(", received=" + ((SeqnoRange)seqno).printBits(true) + " (" + seqno.getNumberOfReceivedMessages() + ")");
            sb.append(", missing=" + ((SeqnoRange)seqno).printBits(false) + " (" + seqno.getNumberOfMissingMessages() + ")");
        }
        return sb.toString();
    }
}

