/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.tests.perf.Configuration;
import org.jgroups.tests.perf.Receiver;
import org.jgroups.tests.perf.Transport;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

public class IPerf
implements Receiver {
    private final Configuration config;
    private final ConcurrentMap<Object, Entry> receiver_table = new ConcurrentHashMap<Object, Entry>();
    private Transport transport = null;
    private ResultSet results = null;
    private final Set<Object> members = new HashSet<Object>();
    private static final NumberFormat f = NumberFormat.getNumberInstance();

    public IPerf(Configuration config) {
        this.config = config;
    }

    public void start() throws Exception {
        this.transport = (Transport)Class.forName(this.config.getTransport()).newInstance();
        this.transport.create(this.config);
        this.transport.setReceiver(this);
        this.transport.start();
        this.members.add(this.transport.getLocalAddress());
        byte[] buf = IPerf.createRegisterMessage();
        this.transport.send(null, buf, false);
        if (this.config.isSender()) {
            this.send();
            this.transport.stop();
            this.transport.destroy();
        } else {
            System.out.println("Transport " + this.transport.getClass().getName() + " started at " + new Date());
            System.out.println("Listening on " + this.transport.getLocalAddress());
        }
    }

    public void receive(Object sender, byte[] payload) {
        ByteBuffer buf = ByteBuffer.wrap(payload);
        byte b = buf.get();
        Type type = Type.getType(b);
        switch (type) {
            case START: {
                this.receiver_table.remove(sender);
                this.receiver_table.putIfAbsent(sender, new Entry());
                break;
            }
            case DATA: {
                Entry entry = (Entry)this.receiver_table.get(sender);
                if (entry == null) {
                    IPerf.err("entry for " + sender + " not found");
                    return;
                }
                int length = buf.getInt();
                entry.total_bytes += length;
                break;
            }
            case STOP: {
                Entry entry = (Entry)this.receiver_table.get(sender);
                if (entry == null) {
                    IPerf.err("entry for " + sender + " not found");
                    return;
                }
                if (entry.stop_time == 0L) {
                    entry.stop_time = System.currentTimeMillis();
                }
                System.out.println("result for " + sender + ": " + entry);
                this.sendResult(sender, entry);
                break;
            }
            case RESULT: {
                long total_time = buf.getLong();
                long total_bytes = buf.getLong();
                this.results.add(sender, total_time, total_bytes);
                break;
            }
            case REGISTER: {
                this.members.add(sender);
            }
        }
    }

    private void send() throws Exception {
        int size = this.config.getSize();
        long time = this.config.getTime();
        int chunk_size = this.config.getChunkSize();
        this.results = new ResultSet(this.members, size);
        byte[] buf = IPerf.createStartMessage();
        this.transport.send(null, buf, false);
        if (time > 0L) {
            ByteBuffer buffer = IPerf.createDataBuffer(chunk_size);
            buffer.put(Type.DATA.getByte());
            buffer.putInt(chunk_size);
            buf = buffer.array();
            long end_time = System.currentTimeMillis() + time;
            while (System.currentTimeMillis() < end_time) {
                this.transport.send(null, buf, false);
            }
        } else {
            int to_send;
            for (int sent = 0; sent < size; sent += to_send) {
                int remaining = size - sent;
                to_send = Math.min(remaining, chunk_size);
                buf = IPerf.createDataMessage(to_send);
                this.transport.send(null, buf, false);
            }
        }
        buf = IPerf.createStopMessage();
        this.transport.send(null, buf, false);
        boolean rc = this.results.block(30000L);
        if (rc) {
            IPerf.log("got all results");
        } else {
            IPerf.err("didnt get all results");
        }
        System.out.println("\nResults:\n" + this.results);
        this.results.reset();
    }

    private static byte[] createRegisterMessage() {
        return IPerf.createMessage(Type.REGISTER);
    }

    private void sendResult(Object destination, Entry entry) {
        ByteBuffer buf = ByteBuffer.allocate(17);
        buf.put(Type.RESULT.getByte());
        buf.putLong(entry.stop_time - entry.start_time);
        buf.putLong(entry.total_bytes);
        try {
            this.transport.send(destination, buf.array(), false);
        }
        catch (Exception e) {
            IPerf.err(e.toString());
        }
    }

    private static byte[] createStartMessage() {
        return IPerf.createMessage(Type.START);
    }

    private static byte[] createDataMessage(int length) {
        ByteBuffer buf = ByteBuffer.allocate(1 + length + 4);
        buf.put(Type.DATA.getByte());
        buf.putInt(length);
        return buf.array();
    }

    private static ByteBuffer createDataBuffer(int length) {
        ByteBuffer buf = ByteBuffer.allocate(1 + length + 4);
        buf.put(Type.DATA.getByte());
        buf.putInt(length);
        return buf;
    }

    private static byte[] createStopMessage() {
        return IPerf.createMessage(Type.STOP);
    }

    private static byte[] createMessage(Type type) {
        ByteBuffer buf = ByteBuffer.allocate(1);
        buf.put(type.getByte());
        return buf.array();
    }

    public static void main(String[] args) throws Exception {
        Configuration config = new Configuration();
        ArrayList<String> unused_args = new ArrayList<String>(args.length);
        for (int i = 0; i < args.length; ++i) {
            String tmp = args[i];
            if (tmp.equalsIgnoreCase("-sender")) {
                config.setSender(true);
                continue;
            }
            if (tmp.equalsIgnoreCase("-size")) {
                config.setSize(Integer.parseInt(args[++i]));
                continue;
            }
            if (tmp.equals("-time")) {
                config.setTime(Long.parseLong(args[++i]));
                continue;
            }
            if (tmp.equals("-chunk_size")) {
                config.setChunkSize(Integer.parseInt(args[++i]));
                continue;
            }
            if (tmp.equals("-transport")) {
                config.setTransport(args[++i]);
                continue;
            }
            if (tmp.equals("-bind_addr")) {
                config.setBindAddress(InetAddress.getByName(args[++i]));
                continue;
            }
            if (tmp.equals("-h") || tmp.equals("-help")) {
                IPerf.help(config.getTransport());
                return;
            }
            unused_args.add(tmp);
        }
        if (!unused_args.isEmpty()) {
            String[] tmp = new String[unused_args.size()];
            for (int i = 0; i < unused_args.size(); ++i) {
                tmp[i] = (String)unused_args.get(i);
            }
            config.setTransportArgs(tmp);
        }
        new IPerf(config).start();
    }

    static void help(String transport) {
        StringBuilder sb = new StringBuilder();
        sb.append("IPerf [-sender] [-bind_addr <addr>] [-transport <class name>] [-size <bytes> | -time <ms>] [-chunk_size <bytes>]");
        try {
            Transport tp = (Transport)Class.forName(transport).newInstance();
            String tmp = tp.help();
            if (tmp != null && tmp.length() > 0) {
                sb.append("\nTransport specific options for " + tp.getClass().getName() + ":\n" + tp.help());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(sb);
    }

    private static void log(String msg) {
        System.out.println(msg);
    }

    private static void err(String msg) {
        System.err.println(msg);
    }

    static {
        f.setGroupingUsed(false);
        f.setMaximumFractionDigits(2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultSet {
        private final Set<Object> not_heard_from;
        private final ConcurrentMap<Object, Tuple<Long, Long>> results = new ConcurrentHashMap<Object, Tuple<Long, Long>>();
        private final Lock lock = new ReentrantLock();
        private final Condition cond = this.lock.newCondition();
        private long expected_bytes = 0L;

        public ResultSet(Collection<Object> not_heard_from, long expected_bytes) {
            this.not_heard_from = new HashSet<Object>(not_heard_from);
            this.expected_bytes = expected_bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Object sender, long time, long total_bytes) {
            this.results.putIfAbsent(sender, new Tuple<Long, Long>(time, total_bytes));
            this.lock.lock();
            try {
                if (this.not_heard_from.remove(sender)) {
                    this.cond.signalAll();
                }
                boolean bl = this.not_heard_from.isEmpty();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean block(long timeout) {
            long target = System.currentTimeMillis() + timeout;
            this.lock.lock();
            try {
                long curr_time;
                while ((curr_time = System.currentTimeMillis()) < target && !this.not_heard_from.isEmpty()) {
                    long wait_time = target - curr_time;
                    try {
                        this.cond.await(wait_time, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                    }
                }
                boolean bl = this.not_heard_from.isEmpty();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        public int size() {
            return this.results.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            this.lock.lock();
            try {
                this.not_heard_from.clear();
                this.results.clear();
                this.cond.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : this.results.entrySet()) {
                Tuple val = (Tuple)entry.getValue();
                sb.append(entry.getKey()).append(" time=" + val.getVal1() + " ms for " + Util.printBytes((Long)val.getVal2()));
                if (this.expected_bytes > 0L) {
                    long total_received_bytes = (Long)val.getVal2();
                    long missing = this.expected_bytes - total_received_bytes;
                    double loss_rate = 100.0 / (double)this.expected_bytes * (double)missing;
                    double throughput = (double)((Long)val.getVal2()).longValue() / ((double)((Long)val.getVal1()).longValue() / 1000.0);
                    sb.append(" (" + Util.printBytes(throughput) + " / sec, loss rate=" + f.format(loss_rate) + "%)");
                }
                sb.append("\n");
            }
            if (!this.not_heard_from.isEmpty()) {
                sb.append("(not heard from " + this.not_heard_from + ")\n");
            }
            return sb.toString();
        }
    }

    private static class Entry {
        private final long start_time = System.currentTimeMillis();
        private long stop_time = 0L;
        private long total_bytes = 0L;

        public String toString() {
            double throughput = (double)this.total_bytes / ((double)(this.stop_time - this.start_time) / 1000.0);
            return this.stop_time - this.start_time + " ms for " + Util.printBytes(this.total_bytes) + " (" + Util.printBytes(throughput) + " / sec)";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        START(1),
        DATA(2),
        STOP(3),
        RESULT(4),
        REGISTER(5);

        final byte b;

        private Type(int i) {
            this.b = (byte)i;
        }

        public byte getByte() {
            return this.b;
        }

        public static Type getType(byte input) {
            switch (input) {
                case 1: {
                    return START;
                }
                case 2: {
                    return DATA;
                }
                case 3: {
                    return STOP;
                }
                case 4: {
                    return RESULT;
                }
                case 5: {
                    return REGISTER;
                }
            }
            throw new IllegalArgumentException("type " + input + " is not valid");
        }
    }
}

