/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.JChannel;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"stack-dependent"}, sequential=false)
public class CloseTest
extends ChannelTestBase {
    private final ThreadLocal<JChannel> ch = new ThreadLocal();
    private final ThreadLocal<JChannel> channel1 = new ThreadLocal();
    private final ThreadLocal<JChannel> c1 = new ThreadLocal();
    private final ThreadLocal<JChannel> c2 = new ThreadLocal();
    private final ThreadLocal<JChannel> c3 = new ThreadLocal();

    @AfterMethod
    void tearDown() throws Exception {
        CloseTest.closeChannel(this.ch);
        CloseTest.closeChannel(this.channel1);
        CloseTest.closeChannel(this.c1);
        CloseTest.closeChannel(this.c2);
        CloseTest.closeChannel(this.c3);
    }

    @Override
    protected boolean useBlocking() {
        return false;
    }

    private static void closeChannel(ThreadLocal<JChannel> local) {
        Channel c = local.get();
        if (c != null && (c.isOpen() || c.isConnected())) {
            c.close();
        }
        local.set(null);
    }

    @Test
    public void testDoubleClose() throws Exception {
        System.out.println("-- creating channel1 --");
        this.channel1.set(this.createChannel(true));
        System.out.println("-- connecting channel1 --");
        this.channel1.get().connect(CloseTest.getUniqueClusterName("CloseTest.testDoubleClose"));
        CloseTest.assertTrue("channel open", this.channel1.get().isOpen());
        CloseTest.assertTrue("channel connected", this.channel1.get().isConnected());
        System.out.println("-- closing channel1 --");
        this.channel1.get().close();
        System.out.println("-- closing channel1 (again) --");
        this.channel1.get().close();
        CloseTest.assertFalse("channel not connected", this.channel1.get().isConnected());
    }

    @Test
    public void testCreationAndClose() throws Exception {
        System.out.println("-- creating channel1 --");
        this.ch.set(this.createChannel(true));
        this.ch.get().connect(CloseTest.getUniqueClusterName("CloseTest.testCreationAndClose"));
        CloseTest.assertTrue("channel open", this.ch.get().isOpen());
        CloseTest.assertTrue("channel connected", this.ch.get().isConnected());
        this.ch.get().close();
        CloseTest.assertFalse("channel not connected", this.ch.get().isConnected());
        this.ch.get().close();
    }

    @Test
    public void testViewChangeReceptionOnChannelCloseByParticipant() throws Exception {
        MyReceiver r1 = new MyReceiver();
        MyReceiver r2 = new MyReceiver();
        this.c1.set(this.createChannel(true));
        this.c1.get().setReceiver(r1);
        System.out.println("-- connecting c1");
        String GROUP = "CloseTest.testViewChangeReceptionOnChannelCloseByParticipant";
        this.c1.get().connect("CloseTest.testViewChangeReceptionOnChannelCloseByParticipant");
        Util.sleep(500L);
        System.out.println("c1: " + r1.getViews());
        Address a1 = this.c1.get().getAddress();
        this.c2.set(this.createChannel(this.c1.get()));
        this.c2.get().setReceiver(r2);
        System.out.println("-- connecting c2");
        r1.clearViews();
        this.c2.get().connect("CloseTest.testViewChangeReceptionOnChannelCloseByParticipant");
        Util.sleep(500L);
        Address a2 = this.c2.get().getAddress();
        System.out.println("c2: " + r2.getViews());
        System.out.println("-- closing c2");
        this.c2.get().close();
        Util.sleep(500L);
        View v = r1.getViews().get(0);
        Vector<Address> members = v.getMembers();
        System.out.println("-- first view of c1: " + v);
        Assert.assertEquals((int)2, (int)members.size());
        CloseTest.assertTrue(members.contains(a1));
        CloseTest.assertTrue(members.contains(a2));
        v = r1.getViews().get(1);
        members = v.getMembers();
        System.out.println("-- second view of c1: " + v);
        assert (1 == members.size());
        assert (members.contains(a1));
        assert (!members.contains(a2));
    }

    @Test
    public void testViewChangeReceptionOnChannelCloseByCoordinator() throws Exception {
        MyReceiver r1 = new MyReceiver();
        MyReceiver r2 = new MyReceiver();
        String GROUP = CloseTest.getUniqueClusterName("CloseTest.testViewChangeReceptionOnChannelCloseByCoordinator");
        this.c1.set(this.createChannel(true));
        this.c1.get().setReceiver(r1);
        this.c1.get().connect(GROUP);
        Util.sleep(500L);
        Address a1 = this.c1.get().getAddress();
        this.c2.set(this.createChannel(this.c1.get()));
        this.c2.get().setReceiver(r2);
        this.c2.get().connect(GROUP);
        Util.sleep(500L);
        Address a2 = this.c2.get().getAddress();
        View v = r2.getViews().get(0);
        Vector<Address> members = v.getMembers();
        assert (2 == members.size());
        assert (members.contains(a2));
        r2.clearViews();
        this.c1.get().close();
        Util.sleep(1000L);
        v = r2.getViews().get(0);
        members = v.getMembers();
        assert (1 == members.size());
        assert (!members.contains(a1));
        assert (members.contains(a2));
        assert (this.c2.get().getNumMessages() == 0);
    }

    @Test
    public void testConnectDisconnectConnectCloseSequence() throws Exception {
        System.out.println("-- creating channel --");
        this.ch.set(this.createChannel(true));
        System.out.println("-- connecting channel to CloseTest--");
        this.ch.get().connect("CloseTest.testConnectDisconnectConnectCloseSequence-CloseTest");
        System.out.println("view is " + this.ch.get().getView());
        System.out.println("-- disconnecting channel --");
        this.ch.get().disconnect();
        Util.sleep(500L);
        System.out.println("-- connecting channel to OtherGroup --");
        this.ch.get().connect("CloseTest.testConnectDisconnectConnectCloseSequence-OtherGroup");
        System.out.println("view is " + this.ch.get().getView());
        System.out.println("-- closing channel --");
        this.ch.get().close();
    }

    @Test
    public void testConnectCloseSequenceWith2Members() throws Exception {
        System.out.println("-- creating channel --");
        this.ch.set(this.createChannel(true));
        System.out.println("-- connecting channel --");
        String GROUP = CloseTest.getUniqueClusterName("CloseTest.testConnectCloseSequenceWith2Members");
        this.ch.get().connect(GROUP);
        System.out.println("view is " + this.ch.get().getView());
        System.out.println("-- creating channel1 --");
        this.channel1.set(this.createChannel(this.ch.get()));
        System.out.println("-- connecting channel1 --");
        this.channel1.get().connect(GROUP);
        System.out.println("view is " + this.channel1.get().getView());
        System.out.println("-- closing channel1 --");
        this.channel1.get().close();
        Util.sleep(2000L);
        System.out.println("-- closing channel --");
        this.ch.get().close();
    }

    @Test
    public void testCreationAndClose2() throws Exception {
        System.out.println("-- creating channel2 --");
        this.ch.set(this.createChannel(true));
        System.out.println("-- connecting channel2 --");
        this.ch.get().connect(CloseTest.getUniqueClusterName("CloseTest.testCreationAndClose2"));
        System.out.println("-- closing channel --");
        this.ch.get().close();
    }

    @Test
    public void testChannelClosedException() throws Exception {
        System.out.println("-- creating channel --");
        this.ch.set(this.createChannel(true));
        System.out.println("-- connecting channel --");
        this.ch.get().connect(CloseTest.getUniqueClusterName("CloseTest.testChannelClosedException"));
        System.out.println("-- closing channel --");
        this.ch.get().close();
        Util.sleep(2000L);
        try {
            this.ch.get().connect(CloseTest.getUniqueClusterName("CloseTest.testChannelClosedException"));
            assert (false);
        }
        catch (ChannelClosedException ex) {
            CloseTest.assertTrue(true);
        }
    }

    @Test
    public void testMultipleConnectsAndDisconnects() throws Exception {
        this.c1.set(this.createChannel(true));
        CloseTest.assertTrue(this.c1.get().isOpen());
        CloseTest.assertFalse(this.c1.get().isConnected());
        String GROUP = CloseTest.getUniqueClusterName("CloseTest.testMultipleConnectsAndDisconnects");
        this.c1.get().connect(GROUP);
        System.out.println("view after c1.connect(): " + this.c1.get().getView());
        CloseTest.assertTrue(this.c1.get().isOpen());
        CloseTest.assertTrue(this.c1.get().isConnected());
        CloseTest.assertServiceAndClusterView(this.c1.get(), 1);
        this.c2.set(this.createChannel(this.c1.get()));
        CloseTest.assertTrue(this.c2.get().isOpen());
        CloseTest.assertFalse(this.c2.get().isConnected());
        this.c2.get().connect(GROUP);
        System.out.println("view after c2.connect(): " + this.c2.get().getView());
        CloseTest.assertTrue(this.c2.get().isOpen());
        CloseTest.assertTrue(this.c2.get().isConnected());
        CloseTest.assertServiceAndClusterView(this.c2.get(), 2);
        Util.sleep(500L);
        CloseTest.assertServiceAndClusterView(this.c1.get(), 2);
        this.c2.get().disconnect();
        System.out.println("view after c2.disconnect(): " + this.c2.get().getView());
        CloseTest.assertTrue(this.c2.get().isOpen());
        CloseTest.assertFalse(this.c2.get().isConnected());
        Util.sleep(500L);
        CloseTest.assertServiceAndClusterView(this.c1.get(), 1);
        this.c2.get().connect(GROUP);
        System.out.println("view after c2.connect(): " + this.c2.get().getView());
        CloseTest.assertTrue(this.c2.get().isOpen());
        CloseTest.assertTrue(this.c2.get().isConnected());
        CloseTest.assertServiceAndClusterView(this.c2.get(), 2);
        Util.sleep(300L);
        CloseTest.assertServiceAndClusterView(this.c1.get(), 2);
        this.c3.set(this.createChannel(this.c1.get()));
        CloseTest.assertTrue(this.c3.get().isOpen());
        CloseTest.assertFalse(this.c3.get().isConnected());
        CloseTest.assertServiceAndClusterView(this.c1.get(), 2);
        CloseTest.assertServiceAndClusterView(this.c2.get(), 2);
        this.c1.get().disconnect();
        Util.sleep(1000L);
        CloseTest.assertTrue(this.c1.get().isOpen());
        CloseTest.assertFalse(this.c1.get().isConnected());
        CloseTest.assertServiceAndClusterView(this.c2.get(), 1);
        CloseTest.assertTrue(this.c3.get().isOpen());
        CloseTest.assertFalse(this.c3.get().isConnected());
        this.c1.get().connect(GROUP);
        System.out.println("view after c1.connect(): " + this.c1.get().getView());
        CloseTest.assertTrue(this.c1.get().isOpen());
        CloseTest.assertTrue(this.c1.get().isConnected());
        CloseTest.assertServiceAndClusterView(this.c1.get(), 2);
        Util.sleep(500L);
        CloseTest.assertServiceAndClusterView(this.c2.get(), 2);
        CloseTest.assertTrue(this.c3.get().isOpen());
        CloseTest.assertFalse(this.c3.get().isConnected());
    }

    private static void assertServiceAndClusterView(Channel ch, int num) {
        View view = ch.getView();
        String msg = "view=" + view;
        CloseTest.assertNotNull(view);
        Assert.assertEquals((int)view.size(), (int)num, (String)msg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReceiver
    extends ReceiverAdapter {
        final List<View> views = new ArrayList<View>();

        private MyReceiver() {
        }

        @Override
        public void viewAccepted(View new_view) {
            this.views.add(new_view);
            System.out.println("new_view = " + new_view);
        }

        public List<View> getViews() {
            return this.views;
        }

        public void clearViews() {
            this.views.clear();
        }
    }
}

