/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Address;
import org.jgroups.stack.DefaultRetransmitter;
import org.jgroups.stack.Retransmitter;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class RetransmitterTest {
    private final Address sender = Util.createRandomAddress();
    private TimeScheduler timer;

    @BeforeMethod
    void initTimer() {
        this.timer = new TimeScheduler();
    }

    @AfterMethod
    void destroyTimer() throws InterruptedException {
        this.timer.stop();
    }

    public void testNoEntry() {
        DefaultRetransmitter xmitter = new DefaultRetransmitter(this.sender, new MyXmitter(), this.timer);
        xmitter.setRetransmitTimeouts(new StaticInterval(1000L, 2000L, 4000L, 8000L));
        int size = ((Retransmitter)xmitter).size();
        System.out.println("xmitter: " + xmitter);
        Assert.assertEquals((int)0, (int)size);
    }

    public void testSingleEntry() {
        DefaultRetransmitter xmitter = new DefaultRetransmitter(this.sender, new MyXmitter(), this.timer);
        xmitter.setRetransmitTimeouts(new StaticInterval(1000L, 2000L, 4000L, 8000L));
        ((Retransmitter)xmitter).add(1L, 1L);
        int size = ((Retransmitter)xmitter).size();
        System.out.println("xmitter: " + xmitter);
        Assert.assertEquals((int)1, (int)size);
    }

    public void testEntry() {
        DefaultRetransmitter xmitter = new DefaultRetransmitter(this.sender, new MyXmitter(), this.timer);
        xmitter.setRetransmitTimeouts(new StaticInterval(1000L, 2000L, 4000L, 8000L));
        ((Retransmitter)xmitter).add(1L, 10L);
        int size = ((Retransmitter)xmitter).size();
        System.out.println("xmitter: " + xmitter);
        Assert.assertEquals((int)10, (int)size);
    }

    public void testMultipleEntries() {
        DefaultRetransmitter xmitter = new DefaultRetransmitter(this.sender, new MyXmitter(), this.timer);
        xmitter.setRetransmitTimeouts(new StaticInterval(1000L, 2000L, 4000L, 8000L));
        ((Retransmitter)xmitter).add(1L, 10L);
        int size = ((Retransmitter)xmitter).size();
        System.out.println("xmitter: " + xmitter);
        Assert.assertEquals((int)10, (int)size);
        ((Retransmitter)xmitter).add(12L, 13L);
        size = ((Retransmitter)xmitter).size();
        System.out.println("xmitter: " + xmitter);
        Assert.assertEquals((int)12, (int)size);
        ((Retransmitter)xmitter).remove(5L);
        size = ((Retransmitter)xmitter).size();
        System.out.println("xmitter: " + xmitter);
        Assert.assertEquals((int)11, (int)size);
        ((Retransmitter)xmitter).remove(13L);
        size = ((Retransmitter)xmitter).size();
        System.out.println("xmitter: " + xmitter);
        Assert.assertEquals((int)10, (int)size);
        ((Retransmitter)xmitter).remove(1L);
        size = ((Retransmitter)xmitter).size();
        System.out.println("xmitter: " + xmitter);
        Assert.assertEquals((int)9, (int)size);
        ((Retransmitter)xmitter).remove(13L);
        size = ((Retransmitter)xmitter).size();
        System.out.println("xmitter: " + xmitter);
        Assert.assertEquals((int)9, (int)size);
        ((Retransmitter)xmitter).remove(12L);
        size = ((Retransmitter)xmitter).size();
        System.out.println("xmitter: " + xmitter);
        Assert.assertEquals((int)8, (int)size);
        for (int i = 8; i >= 0; --i) {
            ((Retransmitter)xmitter).remove(i);
        }
        size = ((Retransmitter)xmitter).size();
        System.out.println("xmitter: " + xmitter);
        Assert.assertEquals((int)2, (int)size);
        ((Retransmitter)xmitter).remove(10L);
        size = ((Retransmitter)xmitter).size();
        System.out.println("xmitter: " + xmitter);
        Assert.assertEquals((int)1, (int)size);
        ((Retransmitter)xmitter).remove(9L);
        size = ((Retransmitter)xmitter).size();
        System.out.println("xmitter: " + xmitter);
        Assert.assertEquals((int)0, (int)size);
    }

    static class MyXmitter
    implements Retransmitter.RetransmitCommand {
        MyXmitter() {
        }

        public void retransmit(long first_seqno, long last_seqno, Address sender) {
        }
    }
}

