/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.Date;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.View;
import org.jgroups.blocks.MembershipListenerAdapter;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.Util;

public class ScaleTest {
    JChannel ch;
    String props = "udp.xml";
    boolean server = true;
    RpcDispatcher disp;
    static NumberFormat f = NumberFormat.getNumberInstance();

    public ScaleTest(String props, boolean server) {
        this.props = props;
        this.server = server;
    }

    public Address getAddress() {
        return this.ch.getAddress();
    }

    public void start() throws ChannelException {
        this.ch = new JChannel(this.props);
        this.disp = new RpcDispatcher((Channel)this.ch, null, (MembershipListener)new MembershipListenerAdapter(){

            public void viewAccepted(View new_view) {
                System.out.println("view=" + new_view);
            }
        }, this);
        this.ch.connect("ScaleTest-Cluster");
        if (!this.server) {
            this.loop();
            Util.close((Channel)this.ch);
        } else {
            System.out.println("ScaleTest started at " + new Date() + ", ready to server requests");
        }
    }

    private void loop() {
        block7: while (true) {
            int input = Util.keyPress(ScaleTest.prompt());
            switch (input) {
                case 49: {
                    View view = this.ch.getView();
                    if (view.size() > 10) {
                        System.out.println(view.getViewId() + ": " + view.size() + " members");
                        break;
                    }
                    System.out.println(view + " (" + view.size() + " members)");
                    break;
                }
                case 50: {
                    try {
                        this.invokeRpcs();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue block7;
                }
                case 51: {
                    return;
                }
            }
        }
    }

    private void invokeRpcs() throws Exception {
        Method method = MethodCall.findMethod(ScaleTest.class, "getAddress", null);
        MethodCall call = new MethodCall(method);
        call.setRequestMode(2);
        call.setTimeout(5000L);
        call.setFlags((byte)16);
        int num_msgs = Util.readIntFromStdin("Number of RPCs: ");
        int print = num_msgs / 10;
        System.out.println("Invoking " + num_msgs + " RPCs:");
        long start = System.currentTimeMillis();
        for (int i = 0; i < num_msgs; ++i) {
            this.disp.callRemoteMethods(null, call);
            if (print <= 0 || i % print != 0) continue;
            System.out.println("invoking RPC #" + i);
        }
        long diff = System.currentTimeMillis() - start;
        double rpcs_per_sec = (double)num_msgs / ((double)diff / 1000.0);
        System.out.println("Invoked " + num_msgs + " in " + diff + " ms: " + f.format(rpcs_per_sec) + " RPCs / sec");
    }

    private static String prompt() {
        return "\n[1] View [2] Send RPCs [3] Exit";
    }

    public static void main(String[] args) throws ChannelException {
        String props = "udp.xml";
        boolean server = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-server")) {
                server = Boolean.parseBoolean(args[++i]);
                continue;
            }
            ScaleTest.help();
            return;
        }
        ScaleTest test = new ScaleTest(props, server);
        test.start();
    }

    static void help() {
        System.out.println("ScaleTest [-props properties] [-server (true | false)]");
    }

    static {
        f.setGroupingUsed(false);
        f.setMaximumFractionDigits(2);
    }
}

