/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.debug.Simulator;
import org.jgroups.protocols.DELAY;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class SimulatorTest {
    static final int NUM_PEERS = 3;
    static final int NUM_MSGS = 5;
    static final int WAIT_TIMEOUT = 5;
    static final int MSGS_PER_STATUS_LINE = 1;
    static boolean allMsgsReceived = false;
    IpAddress[] addresses = new IpAddress[3];
    Vector<Address> members = null;
    View view = null;
    Simulator[] simulators = new Simulator[3];
    DELAY[] layers = new DELAY[3];
    Protocol[][] stacks = new Protocol[3][];
    Thread[] threads = new Thread[3];
    boolean[] isSender = new boolean[3];
    static Object all_msgs_recd = new Object();

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        int i;
        int i2;
        System.out.println("calling setUp()");
        this.isSender[0] = false;
        this.isSender[1] = true;
        this.isSender[2] = true;
        this.addresses[0] = new IpAddress(1111);
        this.addresses[1] = new IpAddress(2222);
        this.addresses[2] = new IpAddress(3333);
        this.members = new Vector();
        for (i2 = 0; i2 < 3; ++i2) {
            this.members.add(this.addresses[i2]);
        }
        this.view = new View(this.addresses[0], 1L, this.members);
        for (i2 = 0; i2 < 3; ++i2) {
            this.createSimulator(this.simulators, this.view, this.addresses, this.layers, this.stacks, i2);
        }
        for (i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 3; ++j) {
                if (i2 == j) {
                    this.simulators[i2].addMember(this.addresses[j]);
                    continue;
                }
                this.simulators[i2].addMember(this.addresses[j], this.simulators[j]);
            }
        }
        Simulator.Receiver[] receivers = new Simulator.Receiver[3];
        for (i = 0; i < 3; ++i) {
            receivers[i] = this.isSender[i] ? new SenderPeer(this.simulators[i]) : new ReceiverPeer(this.simulators[i]);
            this.simulators[i].setReceiver(receivers[i]);
        }
        for (i = 0; i < 3; ++i) {
            this.simulators[i].start();
        }
        System.out.println("Ending setUp()");
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        System.out.println("Calling tearDown()");
        allMsgsReceived = false;
        for (int i = 0; i < 3; ++i) {
            this.simulators[i].stop();
        }
        System.out.println("Ending tearDown()");
    }

    private void createSimulator(Simulator[] simulators, View view, Address[] addresses, DELAY[] layers, Protocol[][] stacks, int i) {
        simulators[i] = new Simulator();
        simulators[i].setLocalAddress(addresses[i]);
        simulators[i].setView(view);
        layers[i] = new DELAY();
        layers[i].setInDelay(0);
        layers[i].setOutDelay(0);
        stacks[i] = new Protocol[]{layers[i]};
        simulators[i].setProtocolStack(stacks[i]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDroppedMessages() {
        System.out.println("Starting testDroppedMessages");
        MyDropMessage d = new MyDropMessage(this.addresses[0]);
        this.simulators[2].registerDropMessage(d);
        for (int i = 0; i < 3; ++i) {
            this.threads[i] = new MyPeer(this.simulators[i], this.isSender[i]);
            this.threads[i].start();
        }
        Object i = all_msgs_recd;
        synchronized (i) {
            try {
                all_msgs_recd.wait(5000L);
            }
            catch (InterruptedException e) {
                System.out.println("main thread interrupted");
            }
        }
        try {
            for (int i2 = 0; i2 < 3; ++i2) {
                this.threads[i2].join();
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        int receiver = ((ReceiverPeer)this.simulators[0].getReceiver()).getNumberOfReceivedMessages();
        int sender1 = ((SenderPeer)this.simulators[1].getReceiver()).getNumberOfReceivedMessages();
        int sender2 = ((SenderPeer)this.simulators[2].getReceiver()).getNumberOfReceivedMessages();
        Assert.assertFalse((boolean)allMsgsReceived, (String)"receiver received all messages from both peers");
        Assert.assertTrue((receiver == 5 ? 1 : 0) != 0, (String)("receiver did not receive all messages from single peer: received " + receiver));
        Assert.assertTrue((sender1 == 10 ? 1 : 0) != 0, (String)("sender1 did not receive messages from itself and other sender: received " + sender1));
        Assert.assertTrue((sender2 == 10 ? 1 : 0) != 0, (String)("sender2 did not receive messages from itself and other sender: received " + sender2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCrashFailure() {
        System.out.println("Starting testCrashfailure");
        this.simulators[1].simulateCrashFailure();
        for (int i = 0; i < 3; ++i) {
            this.threads[i] = new MyPeer(this.simulators[i], this.isSender[i]);
            this.threads[i].start();
        }
        Object i = all_msgs_recd;
        synchronized (i) {
            try {
                all_msgs_recd.wait(5000L);
            }
            catch (InterruptedException e) {
                System.out.println("main thread interrupted");
            }
        }
        try {
            for (int i2 = 0; i2 < 3; ++i2) {
                this.threads[i2].join();
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        int receiver = ((ReceiverPeer)this.simulators[0].getReceiver()).getNumberOfReceivedMessages();
        int sender1 = ((SenderPeer)this.simulators[1].getReceiver()).getNumberOfReceivedMessages();
        int sender2 = ((SenderPeer)this.simulators[2].getReceiver()).getNumberOfReceivedMessages();
        Assert.assertFalse((boolean)allMsgsReceived, (String)"receiver received all messages from both peers");
        Assert.assertTrue((receiver == 5 ? 1 : 0) != 0, (String)"receiver did not receive all messages from single peer");
        Assert.assertTrue((sender1 == 0 ? 1 : 0) != 0, (String)"sender1 received messages");
        Assert.assertTrue((sender2 == 5 ? 1 : 0) != 0, (String)"sender2 did not receive messages only from itself");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNetworkPartition() {
        System.out.println("Starting testNetworkPartition");
        Address[] part1 = new Address[]{this.addresses[0], this.addresses[1]};
        Address[] part2 = new Address[]{this.addresses[2]};
        this.simulators[0].simulatePartition(part1);
        this.simulators[1].simulatePartition(part1);
        this.simulators[2].simulatePartition(part2);
        for (int i = 0; i < 3; ++i) {
            this.threads[i] = new MyPeer(this.simulators[i], this.isSender[i]);
            this.threads[i].start();
        }
        Object i = all_msgs_recd;
        synchronized (i) {
            try {
                all_msgs_recd.wait(5000L);
            }
            catch (InterruptedException e) {
                System.out.println("main thread interrupted");
            }
        }
        try {
            for (int i2 = 0; i2 < 3; ++i2) {
                this.threads[i2].join();
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        int receiver = ((ReceiverPeer)this.simulators[0].getReceiver()).getNumberOfReceivedMessages();
        int sender1 = ((SenderPeer)this.simulators[1].getReceiver()).getNumberOfReceivedMessages();
        int sender2 = ((SenderPeer)this.simulators[2].getReceiver()).getNumberOfReceivedMessages();
        Assert.assertFalse((boolean)allMsgsReceived, (String)"receiver received all messages from both peers");
        Assert.assertTrue((receiver == 5 ? 1 : 0) != 0, (String)"receiver did not receive all messages from single peer");
        Assert.assertTrue((sender1 == 5 ? 1 : 0) != 0, (String)"sender1 did not receive messages only from itself");
        Assert.assertTrue((sender2 == 5 ? 1 : 0) != 0, (String)"sender2 did not receive messages only from itself");
    }

    static class MyPeer
    extends Thread {
        Simulator s = null;
        boolean sender = false;

        public MyPeer(Simulator s, boolean sender) {
            this.s = s;
            this.sender = sender;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.sender) {
                Address address = this.s.getLocalAddress();
                for (int i = 1; i <= 5; ++i) {
                    Message msg = new Message(null, address, new Long(i));
                    Event evt = new Event(1, msg);
                    this.s.send(evt);
                    if (i % 1 != 0) continue;
                    System.out.println("<" + address + ">:" + " ==> " + i);
                }
            }
            if (!this.sender) {
                Object object = all_msgs_recd;
                synchronized (object) {
                    try {
                        all_msgs_recd.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        System.out.println("thread interrupted");
                    }
                }
            }
        }
    }

    class ReceiverPeer
    implements Simulator.Receiver {
        Simulator simulator = null;
        int num_mgs_received = 0;
        Message msg;
        Address sender;

        ReceiverPeer(Simulator s) {
            this.simulator = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void receive(Event evt) {
            block7: {
                if (evt.getType() == 1) {
                    this.msg = (Message)evt.getArg();
                    this.sender = this.msg.getSrc();
                    try {
                        ++this.num_mgs_received;
                        Address address = this.simulator.getLocalAddress();
                        if (this.num_mgs_received % 1 == 0) {
                            System.out.println("<" + address + ">:" + "PASS: received msg #" + this.num_mgs_received + " from " + this.sender);
                        }
                        if (this.num_mgs_received < 10) break block7;
                        allMsgsReceived = true;
                        Object object = all_msgs_recd;
                        synchronized (object) {
                            all_msgs_recd.notifyAll();
                        }
                    }
                    catch (Exception ex) {
                        System.out.println("SimulatorTest.receive()" + ex.toString());
                    }
                }
            }
        }

        public int getNumberOfReceivedMessages() {
            return this.num_mgs_received;
        }
    }

    class SenderPeer
    implements Simulator.Receiver {
        Simulator simulator = null;
        int num_mgs_received = 0;

        SenderPeer(Simulator s) {
            this.simulator = s;
        }

        public void receive(Event evt) {
            if (evt.getType() == 1) {
                ++this.num_mgs_received;
                if (this.num_mgs_received % 1 == 0) {
                    System.out.println("<" + this.simulator.getLocalAddress() + ">:" + "<== " + this.num_mgs_received);
                }
            }
        }

        public int getNumberOfReceivedMessages() {
            return this.num_mgs_received;
        }
    }

    class MyDropMessage
    implements Simulator.DropMessage {
        Address address = null;

        MyDropMessage(Address a) {
            this.address = a;
        }

        public boolean drop(Message msg, Address dest) {
            if (msg.getDest() == null && dest.equals(this.address)) {
                return true;
            }
            return msg.getDest() != null && msg.getDest().equals(this.address);
        }
    }
}

