/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class RpcDispatcherSerializationTest
extends ChannelTestBase {
    private JChannel channel;
    private JChannel channel2;
    private RpcDispatcher disp;
    private RpcDispatcher disp2;
    private final Target target = new Target();

    @BeforeClass
    protected void setUp() throws Exception {
        this.channel = this.createChannel(true);
        this.disp = new RpcDispatcher((Channel)this.channel, null, null, this.target);
        this.channel.connect("RpcDispatcherSerializationTest");
        this.channel2 = this.createChannel(this.channel);
        this.disp2 = new RpcDispatcher((Channel)this.channel2, null, null, this.target);
        this.channel2.connect("RpcDispatcherSerializationTest");
    }

    @AfterClass
    protected void tearDown() throws Exception {
        this.channel2.close();
        this.disp2.stop();
        this.disp.stop();
        this.channel.close();
    }

    public void testNonSerializableArgument() throws Throwable {
        try {
            this.disp.callRemoteMethods(null, "foo", new Object[]{new NonSerializable()}, new Class[]{NonSerializable.class}, 2, 5000L);
            throw new IllegalStateException("should throw NotSerializableException");
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            if (cause == null || !(cause instanceof NotSerializableException)) {
                throw t;
            }
            System.out.println("received RuntimeException with NotSerializableException as cause - this is expected");
            return;
        }
    }

    public void testTargetMethodNotFound() {
        Vector<Address> members = this.channel.getView().getMembers();
        System.out.println("members are: " + members);
        RspList rsps = this.disp.callRemoteMethods(members, "foo", null, new Class[]{String.class, String.class}, 2, 8000L);
        System.out.println("responses:\n" + rsps + ", channel.view: " + this.channel.getView() + ", channel2.view: " + this.channel2.getView());
        assert (members.size() == rsps.size()) : "expected " + members.size() + " responses, but got " + rsps + " (" + rsps.size() + ")";
        for (Rsp rsp : rsps.values()) {
            assert (rsp.getValue() instanceof NoSuchMethodException) : "response value is " + rsp.getValue();
        }
    }

    public void testMarshaller() {
        MyMarshaller m = new MyMarshaller();
        this.disp.setRequestMarshaller(m);
        this.disp.setResponseMarshaller(m);
        this.disp2.setRequestMarshaller(m);
        this.disp2.setResponseMarshaller(m);
        RspList rsps = this.disp.callRemoteMethods(null, "methodA", new Object[]{Boolean.TRUE, new Long(322649L)}, new Class[]{Boolean.TYPE, Long.TYPE}, 2, 0L);
        assert (rsps.size() == 2);
        for (Rsp rsp : rsps.values()) {
            assert (rsp.getValue() == null);
            RpcDispatcherSerializationTest.assertTrue(rsp.wasReceived());
            RpcDispatcherSerializationTest.assertFalse(rsp.wasSuspected());
        }
        rsps = this.disp.callRemoteMethods(null, "methodB", null, (Class[])null, 2, 0L);
        RpcDispatcherSerializationTest.assertEquals(2, rsps.size());
        for (Rsp rsp : rsps.values()) {
            RpcDispatcherSerializationTest.assertNotNull(rsp.getValue());
            RpcDispatcherSerializationTest.assertEquals(Boolean.TRUE, rsp.getValue());
            RpcDispatcherSerializationTest.assertTrue(rsp.wasReceived());
            RpcDispatcherSerializationTest.assertFalse(rsp.wasSuspected());
        }
        rsps = this.disp.callRemoteMethods(null, "methodC", null, (Class[])null, 2, 0L);
        RpcDispatcherSerializationTest.assertEquals(2, rsps.size());
        for (Rsp rsp : rsps.values()) {
            RpcDispatcherSerializationTest.assertNotNull(rsp.getValue());
            RpcDispatcherSerializationTest.assertTrue(rsp.getValue() instanceof Throwable);
            RpcDispatcherSerializationTest.assertTrue(rsp.wasReceived());
            RpcDispatcherSerializationTest.assertFalse(rsp.wasSuspected());
        }
        this.disp.setRequestMarshaller(null);
        this.disp.setResponseMarshaller(null);
        this.disp2.setRequestMarshaller(null);
        this.disp2.setResponseMarshaller(null);
    }

    static class NonSerializable {
        int i;

        NonSerializable() {
        }
    }

    static class Target {
        Target() {
        }

        public static void methodA(boolean b, long l) {
        }

        public static boolean methodB() {
            return true;
        }

        public static void methodC() {
            throw new IllegalArgumentException("dummy exception - for testing only");
        }
    }

    static class MyMarshaller
    implements RpcDispatcher.Marshaller {
        static final byte NULL = 0;
        static final byte BOOL = 1;
        static final byte LONG = 2;
        static final byte OBJ = 3;

        MyMarshaller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] objectToByteBuffer(Object obj) throws Exception {
            ByteArrayOutputStream out = new ByteArrayOutputStream(24);
            ObjectOutputStream oos = new ObjectOutputStream(out);
            try {
                if (obj == null) {
                    oos.writeByte(0);
                } else if (obj instanceof Boolean) {
                    oos.writeByte(1);
                    oos.writeBoolean((Boolean)obj);
                } else if (obj instanceof Long) {
                    oos.writeByte(2);
                    oos.writeLong((Long)obj);
                } else {
                    oos.writeByte(3);
                    oos.writeObject(obj);
                }
                oos.flush();
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            finally {
                Util.close(oos);
            }
        }

        public Object objectFromByteBuffer(byte[] buf) throws Exception {
            ByteArrayInputStream inp = new ByteArrayInputStream(buf);
            ObjectInputStream in = new ObjectInputStream(inp);
            try {
                byte type = in.readByte();
                switch (type) {
                    case 0: {
                        Object var5_5 = null;
                        return var5_5;
                    }
                    case 1: {
                        Boolean bl = in.readBoolean();
                        return bl;
                    }
                    case 2: {
                        Long l = new Long(in.readLong());
                        return l;
                    }
                    case 3: {
                        Object object = in.readObject();
                        return object;
                    }
                }
                throw new IllegalArgumentException("incorrect type " + type);
            }
            finally {
                Util.close(in);
            }
        }
    }
}

