/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverter;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyHelper {
    protected static final Log log = LogFactory.getLog(PropertyHelper.class);

    public static String getPropertyName(Field field, Map<String, String> props) throws IllegalArgumentException {
        if (field == null) {
            throw new IllegalArgumentException("Cannot get property name: field is null");
        }
        if (props == null) {
            throw new IllegalArgumentException("Cannot get property name: properties map is null");
        }
        Property annotation = field.getAnnotation(Property.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Cannot get property name for field " + field.getName() + " which is not annotated with @Property");
        }
        String propertyName = field.getName();
        if (props.containsKey(annotation.name())) {
            boolean isDeprecated;
            propertyName = annotation.name();
            boolean bl = isDeprecated = annotation.deprecatedMessage().length() > 0;
            if (isDeprecated && log.isWarnEnabled()) {
                log.warn(annotation.deprecatedMessage());
            }
        }
        return propertyName;
    }

    public static String getPropertyName(Method method) throws IllegalArgumentException {
        if (method == null) {
            throw new IllegalArgumentException("Cannot get property name: field is null");
        }
        Property annotation = method.getAnnotation(Property.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Cannot get property name for method " + method.getName() + " which is not annotated with @Property");
        }
        String propertyName = annotation.name().length() > 0 ? annotation.name() : method.getName();
        propertyName = Util.methodNameToAttributeName(propertyName);
        return propertyName;
    }

    public static Object getConvertedValue(Object obj, Field field, Map<String, String> props, String prop, boolean check_scope) throws Exception {
        if (obj == null) {
            throw new IllegalArgumentException("Cannot get converted value: Object is null");
        }
        if (field == null) {
            throw new IllegalArgumentException("Cannot get converted value: Field is null");
        }
        if (props == null) {
            throw new IllegalArgumentException("Cannot get converted value: Properties is null");
        }
        Property annotation = field.getAnnotation(Property.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Cannot get property name for field " + field.getName() + " which is not annotated with @Property");
        }
        String propertyName = PropertyHelper.getPropertyName(field, props);
        String name = obj instanceof Protocol ? ((Protocol)obj).getName() : obj.getClass().getName();
        PropertyConverter propertyConverter = (PropertyConverter)annotation.converter().newInstance();
        if (propertyConverter == null) {
            throw new Exception("Could not find property converter for field " + propertyName + " in " + name);
        }
        Object converted = null;
        try {
            String tmp = obj instanceof Protocol ? ((Protocol)obj).getName() + "." + propertyName : propertyName;
            converted = propertyConverter.convert(obj, field.getType(), tmp, prop, check_scope);
        }
        catch (Exception e) {
            throw new Exception("Conversion of " + propertyName + " in " + name + " with original property value " + prop + " failed. Exception is " + e, e);
        }
        return converted;
    }

    public static Object getConvertedValue(Object obj, Method method, Map<String, String> props, String prop, boolean check_scope) throws Exception {
        if (obj == null) {
            throw new IllegalArgumentException("Cannot get converted value: Object is null");
        }
        if (method == null) {
            throw new IllegalArgumentException("Cannot get converted value: Method is null");
        }
        if (!Configurator.isSetPropertyMethod(method)) {
            throw new IllegalArgumentException("Cannot get converted value: Method is not set property method");
        }
        if (props == null) {
            throw new IllegalArgumentException("Cannot get converted value: Properties is null");
        }
        Property annotation = method.getAnnotation(Property.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Cannot get property name for method " + method.getName() + " which is not annotated with @Property");
        }
        String propertyName = PropertyHelper.getPropertyName(method);
        String name = obj instanceof Protocol ? ((Protocol)obj).getName() : obj.getClass().getName();
        PropertyConverter propertyConverter = (PropertyConverter)annotation.converter().newInstance();
        if (propertyConverter == null) {
            throw new Exception("Could not find property converter for method " + propertyName + " in " + name);
        }
        Object converted = null;
        try {
            String tmp = obj instanceof Protocol ? ((Protocol)obj).getName() + "." + propertyName : propertyName;
            converted = propertyConverter.convert(obj, method.getParameterTypes()[0], tmp, prop, check_scope);
        }
        catch (Exception e) {
            throw new Exception("Conversion of " + propertyName + " in " + name + " with original property value " + prop + " failed. Exception is " + e, e);
        }
        return converted;
    }

    public static boolean usesDefaultConverter(Field field) throws IllegalArgumentException {
        if (field == null) {
            throw new IllegalArgumentException("Cannot check converter: field is null");
        }
        Property annotation = field.getAnnotation(Property.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Cannot check converter for field " + field.getName() + " which is not annotated with @Property");
        }
        return annotation.converter().equals(PropertyConverters.Default.class);
    }
}

