/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.debug.Simulator;
import org.jgroups.protocols.FC;
import org.jgroups.protocols.FRAG2;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class FCTest {
    Simulator s = null;
    static final int SIZE = 1000;
    static final int NUM_MSGS = 100000;
    static final int PRINT = 10000;

    @BeforeMethod
    void setUp() throws Exception {
        IpAddress a1 = new IpAddress(1111);
        Vector<Address> members = new Vector<Address>();
        members.add(a1);
        View v = new View(a1, 1L, members);
        this.s = new Simulator();
        this.s.setLocalAddress(a1);
        this.s.setView(v);
        this.s.addMember(a1);
        FC fc = new FC();
        fc.setMinCredits(1000L);
        fc.setMaxCredits(10000L);
        fc.setMaxBlockTime(1000L);
        FRAG2 frag = new FRAG2();
        frag.setFragSize(60000);
        Protocol[] stack = new Protocol[]{frag, fc};
        this.s.setProtocolStack(stack);
        this.s.start();
    }

    @AfterMethod
    void tearDown() throws Exception {
        this.s.stop();
    }

    @Test(groups={"functional"})
    public void testReceptionOfAllMessages() {
        int num_received = 0;
        Receiver r = new Receiver();
        this.s.setReceiver(r);
        for (int i = 1; i <= 100000; ++i) {
            Message msg = new Message(null, null, FCTest.createPayload(1000));
            Event evt = new Event(1, msg);
            this.s.send(evt);
            if (i % 10000 != 0) continue;
            System.out.println("==> " + i);
        }
        for (int num_tries = 10; num_tries > 0; --num_tries) {
            Util.sleep(1000L);
            num_received = r.getNumberOfReceivedMessages();
            System.out.println("-- num received=" + num_received + ", stats:\n" + this.s.dumpStats());
            if (num_received >= 100000) break;
        }
        assert (num_received == 100000);
    }

    private static byte[] createPayload(int size) {
        byte[] retval = new byte[size];
        for (int i = 0; i < size; ++i) {
            retval[i] = 48;
        }
        return retval;
    }

    static class Receiver
    implements Simulator.Receiver {
        int num_mgs_received = 0;

        Receiver() {
        }

        public void receive(Event evt) {
            if (evt.getType() == 1) {
                ++this.num_mgs_received;
                if (this.num_mgs_received % 10000 == 0) {
                    System.out.println("<== " + this.num_mgs_received);
                }
            }
        }

        public int getNumberOfReceivedMessages() {
            return this.num_mgs_received;
        }
    }
}

