/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=false)
public class StateTransferTest
extends ChannelTestBase {
    static final int MSG_SEND_COUNT = 5000;
    static final String[] names = new String[]{"A", "B", "C", "D"};
    static final int APP_COUNT = names.length;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStateTransferFromSelfWithRegularChannel() throws Exception {
        JChannel ch = this.createChannel(true);
        ((Channel)ch).connect("StateTransferTest");
        try {
            boolean rc = ((Channel)ch).getState(null, 2000L);
            assert (!rc) : "getState() on singleton should return false";
        }
        finally {
            ((Channel)ch).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStateTransferWhileSending() throws Exception {
        StateTransferApplication[] apps = new StateTransferApplication[APP_COUNT];
        try {
            int i;
            Semaphore semaphore = new Semaphore(APP_COUNT);
            semaphore.acquire(APP_COUNT);
            int from = 0;
            int to = 5000;
            for (i = 0; i < apps.length; ++i) {
                apps[i] = i == 0 ? new StateTransferApplication(semaphore, names[i], from, to) : new StateTransferApplication((JChannel)apps[0].getChannel(), semaphore, names[i], from, to);
                from += 5000;
                to += 5000;
            }
            for (i = 0; i < apps.length; ++i) {
                StateTransferApplication app = apps[i];
                app.start();
                semaphore.release();
                Util.sleep(3000L);
            }
            Channel[] tmp = new Channel[apps.length];
            for (int i2 = 0; i2 < apps.length; ++i2) {
                tmp[i2] = apps[i2].getChannel();
            }
            Util.blockUntilViewsReceived(60000L, 1000L, tmp);
            boolean acquired = semaphore.tryAcquire(apps.length, 30L, TimeUnit.SECONDS);
            if (!acquired) {
                this.log.warn("Most likely a bug, analyse the stack below:");
                this.log.warn(Util.dumpThreads());
            }
            System.out.println("Waiting for all channels to have received the " + 5000 * APP_COUNT + " messages:");
            long end_time = System.currentTimeMillis() + 40000L;
            while (System.currentTimeMillis() < end_time) {
                boolean terminate = true;
                for (StateTransferApplication app : apps) {
                    Map<Object, Object> map = app.getMap();
                    if (map.size() == 5000 * APP_COUNT) continue;
                    terminate = false;
                    break;
                }
                if (terminate) break;
                Util.sleep(500L);
            }
            System.out.println("++++++++++++++++++++++++++++++++++++++");
            for (int i3 = 0; i3 < apps.length; ++i3) {
                StateTransferApplication w = apps[i3];
                Map<Object, Object> m = w.getMap();
                this.log.info("map has " + m.size() + " elements");
                assert (m.size() == 5000 * APP_COUNT);
            }
            System.out.println("++++++++++++++++++++++++++++++++++++++");
            Set<Object> keys = apps[0].getMap().keySet();
            for (int i4 = 0; i4 < apps.length; ++i4) {
                StateTransferApplication app = apps[i4];
                Map<Object, Object> m = app.getMap();
                Set<Object> s = m.keySet();
                assert (((Object)keys).equals(s));
            }
        }
        finally {
            for (StateTransferApplication app : apps) {
                app.getChannel().setReceiver(null);
            }
            for (StateTransferApplication app : apps) {
                app.cleanup();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class StateTransferApplication
    extends ChannelTestBase.PushChannelApplicationWithSemaphore {
        private final Map<Object, Object> map;
        private int from;
        private int to;

        public StateTransferApplication(Semaphore semaphore, String name, int from, int to) throws Exception {
            super(name, semaphore);
            this.map = new HashMap<Object, Object>(5000 * APP_COUNT);
            this.from = from;
            this.to = to;
        }

        public StateTransferApplication(JChannel copySource, Semaphore semaphore, String name, int from, int to) throws Exception {
            super(copySource, name, semaphore);
            this.map = new HashMap<Object, Object>(5000 * APP_COUNT);
            this.from = from;
            this.to = to;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<Object, Object> getMap() {
            Map<Object, Object> map = this.map;
            synchronized (map) {
                return Collections.unmodifiableMap(this.map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receive(Message msg) {
            Object[] data = (Object[])msg.getObject();
            int num_received = 0;
            boolean changed = false;
            Map<Object, Object> map = this.map;
            synchronized (map) {
                int tmp_size = this.map.size();
                this.map.put(data[0], data[1]);
                num_received = this.map.size();
                changed = tmp_size != num_received;
            }
            if (changed && num_received % 1000 == 0) {
                StateTransferTest.this.log.info(this.channel.getAddress() + ": received " + num_received);
            }
            if (num_received >= 5000 * APP_COUNT) {
                this.semaphore.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getState() {
            Map<Object, Object> map = this.map;
            synchronized (map) {
                try {
                    return Util.objectToByteBuffer(this.map);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setState(byte[] state) {
            Map<Object, Object> map = this.map;
            synchronized (map) {
                try {
                    Map tmp = (Map)Util.objectFromByteBuffer(state);
                    this.map.putAll(tmp);
                    StateTransferTest.this.log.info(this.channel.getAddress() + ": received state, map has " + this.map.size() + " elements");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getState(OutputStream ostream) {
            Map<Object, Object> map = this.map;
            synchronized (map) {
                try {
                    ObjectOutputStream out = new ObjectOutputStream(ostream);
                    out.writeObject(this.map);
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setState(InputStream istream) {
            Map<Object, Object> map = this.map;
            synchronized (map) {
                try {
                    ObjectInputStream in = new ObjectInputStream(istream);
                    Map tmp = (Map)in.readObject();
                    Util.close(in);
                    this.map.putAll(tmp);
                    StateTransferTest.this.log.info(this.channel.getAddress() + ": received state, map has " + this.map.size() + " elements");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void run() {
            boolean acquired = false;
            try {
                acquired = this.semaphore.tryAcquire(60000L, TimeUnit.MILLISECONDS);
                if (!acquired) {
                    throw new Exception(this.channel.getAddress() + " cannot acquire semaphore");
                }
                this.useChannel();
            }
            catch (Exception e) {
                StateTransferTest.this.log.error(this.channel.getAddress() + ": " + e.getLocalizedMessage(), e);
                this.exception = e;
            }
        }

        @Override
        protected void useChannel() throws Exception {
            System.out.println(this.channel.getName() + ": connecting and fetching the state");
            this.channel.connect("StateTransferTest", null, null, 30000L);
            System.out.println(this.channel.getName() + ": state transfer is done");
            Object[] data = new Object[2];
            for (int i = this.from; i < this.to; ++i) {
                data[0] = new Integer(i);
                data[1] = "Value #" + i;
                try {
                    this.channel.send(null, null, (Serializable)data);
                    if (i % 100 == 0) {
                        Util.sleep(50L);
                    }
                    if (i % 1000 != 0) continue;
                    StateTransferTest.this.log.info(this.channel.getAddress() + ": sent " + i);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
    }
}

