/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Membership;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.protocols.DISCARD;
import org.jgroups.protocols.SHARED_LOOPBACK;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.NAKACK;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.stack.Protocol;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Digest;
import org.jgroups.util.MergeId;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"stack-independent"}, sequential=true)
public class GMS_MergeTest
extends ChannelTestBase {
    static final String simple_props = "SHARED_LOOPBACK:PING(timeout=1000):pbcast.NAKACK(gc_lag=0;log_discard_msgs=false;log_not_found_msgs=false):UNICAST:pbcast.STABLE(stability_delay=200):pbcast.GMS:FC:FRAG2";
    static final String flush_props = "SHARED_LOOPBACK:PING(timeout=1000):pbcast.NAKACK(gc_lag=0;log_discard_msgs=false;log_not_found_msgs=false):UNICAST:pbcast.STABLE(stability_delay=200):pbcast.GMS:FC:FRAG2:pbcast.FLUSH";

    public static void testMergeRequestTimeout() throws Exception {
        GMS_MergeTest._testMergeRequestTimeout(simple_props, "testMergeRequestTimeout");
    }

    public static void testMergeRequestTimeoutWithFlush() throws Exception {
        GMS_MergeTest._testMergeRequestTimeout(flush_props, "testMergeRequestTimeoutWithFlush");
    }

    public static void testSimpleMerge() throws Exception {
        GMS_MergeTest._testSimpleMerge(simple_props, "testSimpleMerge");
    }

    public static void testSimpleMergeWithFlush() throws Exception {
        GMS_MergeTest._testSimpleMerge(flush_props, "testSimpleMergeWithFlush");
    }

    public static void testConcurrentMergeTwoPartitions() throws Exception {
        GMS_MergeTest._testConcurrentMergeTwoPartitions(simple_props, "testConcurrentMergeTwoPartitions");
    }

    public static void testConcurrentMergeTwoPartitionsWithFlush() throws Exception {
        GMS_MergeTest._testConcurrentMergeTwoPartitions(flush_props, "testConcurrentMergeTwoPartitionsWithFlush");
    }

    public static void testConcurrentMergeMultiplePartitions() throws Exception {
        GMS_MergeTest._testConcurrentMergeMultiplePartitions(simple_props, "testConcurrentMergeMultiplePartitions");
    }

    public static void testConcurrentMergeMultiplePartitionsWithFlush() throws Exception {
        GMS_MergeTest._testConcurrentMergeMultiplePartitions(flush_props, "testConcurrentMergeMultiplePartitionsWithFlush");
    }

    public static void testMergeAsymmetricPartitions() throws Exception {
        GMS_MergeTest._testMergeAsymmetricPartitions(simple_props, "testMergeAsymmetricPartitions");
    }

    public static void testMergeAsymmetricPartitionsWithFlush() throws Exception {
        GMS_MergeTest._testMergeAsymmetricPartitions(flush_props, "testMergeAsymmetricPartitionsWithFlush");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void _testMergeRequestTimeout(String props, String cluster_name) throws Exception {
        JChannel c1 = new JChannel(props);
        try {
            c1.connect(cluster_name);
            Message merge_request = new Message();
            GMS.GmsHeader hdr = new GMS.GmsHeader(6);
            MergeId new_merge_id = MergeId.create(c1.getAddress());
            hdr.setMergeId(new_merge_id);
            merge_request.putHeader(GMS.class.getSimpleName(), hdr);
            GMS gms = (GMS)c1.getProtocolStack().findProtocol(GMS.class);
            gms.setMergeTimeout(2000L);
            MergeId merge_id = gms.getMergeId();
            assert (merge_id == null);
            System.out.println("starting merge");
            gms.up(new Event(1, merge_request));
            merge_id = gms.getMergeId();
            System.out.println("merge_id = " + merge_id);
            assert (new_merge_id.equals(merge_id));
            long timeout = (long)((double)gms.getMergeTimeout() * 1.5);
            System.out.println("sleeping for " + timeout + " ms, then fetching merge_id: should be null (cancelled by the MergeCanceller)");
            long target_time = System.currentTimeMillis() + timeout;
            while (System.currentTimeMillis() < target_time && (merge_id = gms.getMergeId()) != null) {
                Util.sleep(500L);
            }
            merge_id = gms.getMergeId();
            System.out.println("merge_id = " + merge_id);
            assert (merge_id == null) : "MergeCanceller didn't kick in";
        }
        finally {
            Util.close((Channel)c1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void _testSimpleMerge(String props, String cluster_name) throws Exception {
        JChannel[] channels = null;
        try {
            channels = GMS_MergeTest.create(props, true, cluster_name, "A", "B", "C", "D");
            GMS_MergeTest.print(channels);
            View view = channels[channels.length - 1].getView();
            assert (view.size() == channels.length) : "view is " + view;
            System.out.println("\ncreating partitions: ");
            String[][] partitions = GMS_MergeTest.generate({"A", "B"}, {"C", "D"});
            GMS_MergeTest.createPartitions(channels, partitions);
            GMS_MergeTest.print(channels);
            GMS_MergeTest.checkViews(channels, "A", "A", "B");
            GMS_MergeTest.checkViews(channels, "B", "A", "B");
            GMS_MergeTest.checkViews(channels, "C", "C", "D");
            GMS_MergeTest.checkViews(channels, "D", "C", "D");
            Address leader = GMS_MergeTest.determineLeader(channels, "A", "C");
            long end_time = System.currentTimeMillis() + 30000L;
            do {
                System.out.println("\n==== injecting merge events into " + leader + " ====");
                GMS_MergeTest.injectMergeEvent(channels, leader, "A", "C");
                Util.sleep(1000L);
            } while (!GMS_MergeTest.allChannelsHaveViewOf(channels, 4) && end_time > System.currentTimeMillis());
            System.out.println("\n");
            GMS_MergeTest.print(channels);
            GMS_MergeTest.assertAllChannelsHaveViewOf(channels, 4);
            System.out.println("closing channels");
        }
        catch (Throwable throwable) {
            System.out.println("closing channels");
            GMS_MergeTest.close(channels);
            System.out.println("done");
            throw throwable;
        }
        GMS_MergeTest.close(channels);
        System.out.println("done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void _testConcurrentMergeTwoPartitions(String props, String cluster_name) throws Exception {
        JChannel[] channels = null;
        try {
            channels = GMS_MergeTest.create(props, true, cluster_name, "A", "B", "C", "D");
            GMS_MergeTest.print(channels);
            View view = channels[channels.length - 1].getView();
            assert (view.size() == channels.length) : "view is " + view;
            System.out.println("\ncreating partitions: ");
            String[][] partitions = GMS_MergeTest.generate({"A", "B"}, {"C", "D"});
            GMS_MergeTest.createPartitions(channels, partitions);
            GMS_MergeTest.print(channels);
            GMS_MergeTest.checkViews(channels, "A", "A", "B");
            GMS_MergeTest.checkViews(channels, "B", "A", "B");
            GMS_MergeTest.checkViews(channels, "C", "C", "D");
            GMS_MergeTest.checkViews(channels, "D", "C", "D");
            long end_time = System.currentTimeMillis() + 30000L;
            do {
                System.out.println("\n==== injecting merge events into A and C concurrently ====");
                GMS_MergeTest.injectMergeEvent(channels, "C", "A", "C");
                GMS_MergeTest.injectMergeEvent(channels, "A", "A", "C");
                Util.sleep(1000L);
            } while (!GMS_MergeTest.allChannelsHaveViewOf(channels, 4) && end_time > System.currentTimeMillis());
            System.out.println("\n");
            GMS_MergeTest.print(channels);
            GMS_MergeTest.assertAllChannelsHaveViewOf(channels, 4);
        }
        catch (Throwable throwable) {
            GMS_MergeTest.close(channels);
            throw throwable;
        }
        GMS_MergeTest.close(channels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void _testConcurrentMergeMultiplePartitions(String props, String cluster_name) throws Exception {
        JChannel[] channels = null;
        try {
            channels = GMS_MergeTest.create(props, true, cluster_name, "A", "B", "C", "D", "E", "F", "G", "H");
            GMS_MergeTest.print(channels);
            View view = channels[channels.length - 1].getView();
            assert (view.size() == channels.length) : "view is " + view;
            GMS_MergeTest.assertAllChannelsHaveViewOf(channels, 8);
            System.out.println("\ncreating partitions: ");
            String[][] partitions = GMS_MergeTest.generate({"A", "B"}, {"C", "D"}, {"E", "F"}, {"G", "H"});
            GMS_MergeTest.createPartitions(channels, partitions);
            GMS_MergeTest.print(channels);
            GMS_MergeTest.checkViews(channels, "A", "A", "B");
            GMS_MergeTest.checkViews(channels, "B", "A", "B");
            GMS_MergeTest.checkViews(channels, "C", "C", "D");
            GMS_MergeTest.checkViews(channels, "D", "C", "D");
            GMS_MergeTest.checkViews(channels, "E", "E", "F");
            GMS_MergeTest.checkViews(channels, "F", "E", "F");
            GMS_MergeTest.checkViews(channels, "G", "G", "H");
            GMS_MergeTest.checkViews(channels, "H", "G", "H");
            long end_time = System.currentTimeMillis() + 30000L;
            do {
                System.out.println("\n==== injecting merge event into A, C, E and G concurrently ====");
                GMS_MergeTest.injectMergeEvent(channels, "G", "A", "C", "E", "G");
                GMS_MergeTest.injectMergeEvent(channels, "E", "A", "C", "E", "G");
                GMS_MergeTest.injectMergeEvent(channels, "A", "A", "C", "E", "G");
                GMS_MergeTest.injectMergeEvent(channels, "C", "A", "C", "E", "G");
                Util.sleep(1000L);
            } while (!GMS_MergeTest.allChannelsHaveViewOf(channels, 8) && end_time > System.currentTimeMillis());
            GMS_MergeTest.print(channels);
            GMS_MergeTest.assertAllChannelsHaveViewOf(channels, 8);
        }
        catch (Throwable throwable) {
            GMS_MergeTest.close(channels);
            throw throwable;
        }
        GMS_MergeTest.close(channels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void _testMergeAsymmetricPartitions(String props, String cluster_name) throws Exception {
        JChannel[] channels = null;
        int NUM = 10;
        try {
            int i;
            channels = GMS_MergeTest.create(props, true, cluster_name, "B", "A", "C");
            MyReceiver[] receivers = new MyReceiver[channels.length];
            for (int i2 = 0; i2 < channels.length; ++i2) {
                receivers[i2] = new MyReceiver(channels[i2].getName());
                channels[i2].setReceiver(receivers[i2]);
            }
            JChannel a = GMS_MergeTest.findChannel("A", channels);
            JChannel b = GMS_MergeTest.findChannel("B", channels);
            JChannel c = GMS_MergeTest.findChannel("C", channels);
            GMS_MergeTest.print(channels);
            View view = channels[channels.length - 1].getView();
            assert (view.size() == channels.length) : "view is " + view;
            System.out.println("sending 10 msgs:");
            for (int i3 = 0; i3 < 10; ++i3) {
                for (JChannel ch : channels) {
                    ch.send(null, null, (Serializable)((Object)("Number #" + i3 + " from " + ch.getAddress())));
                }
            }
            GMS_MergeTest.waitForNumMessages(10 * channels.length, 10000L, 1000L, receivers);
            GMS_MergeTest.checkMessages(10 * channels.length, receivers);
            System.out.println("\ncreating partitions: ");
            GMS_MergeTest.applyView(channels, "A", "B", "A", "C");
            GMS_MergeTest.applyView(channels, "B", "B", "C");
            GMS_MergeTest.applyView(channels, "C", "B", "C");
            GMS_MergeTest.print(channels);
            GMS_MergeTest.checkViews(channels, "A", "B", "A", "C");
            GMS_MergeTest.checkViews(channels, "B", "B", "C");
            GMS_MergeTest.checkViews(channels, "C", "B", "C");
            for (MyReceiver receiver : receivers) {
                receiver.clear();
            }
            DISCARD discard = new DISCARD();
            discard.addIgnoreMember(b.getAddress());
            discard.addIgnoreMember(c.getAddress());
            a.getProtocolStack().insertProtocol((Protocol)discard, 1, SHARED_LOOPBACK.class);
            System.out.println("B and C exchange 10 messages, A discards them");
            for (i = 0; i < 10; ++i) {
                b.send(null, null, (Serializable)((Object)("message #" + i + " from B")));
            }
            for (i = 0; i < 10; ++i) {
                c.send(null, null, (Serializable)((Object)("message #" + i + " from C")));
            }
            GMS_MergeTest.waitForNumMessages(20, 10000L, 500L, receivers[0], receivers[2]);
            GMS_MergeTest.checkMessages(20, receivers[0], receivers[2]);
            GMS_MergeTest.checkMessages(0, receivers[1]);
            Digest da = ((NAKACK)a.getProtocolStack().findProtocol(NAKACK.class)).getDigest();
            Digest db = ((NAKACK)b.getProtocolStack().findProtocol(NAKACK.class)).getDigest();
            Digest dc = ((NAKACK)c.getProtocolStack().findProtocol(NAKACK.class)).getDigest();
            System.out.println("Digest A: " + da + "\nDigest B: " + db + "\nDigest C: " + dc);
            System.out.println("Running stability protocol on B and C now");
            for (int i4 = 0; i4 < 3; ++i4) {
                ((STABLE)b.getProtocolStack().findProtocol(STABLE.class)).runMessageGarbageCollection();
                ((STABLE)c.getProtocolStack().findProtocol(STABLE.class)).runMessageGarbageCollection();
                Util.sleep(300L);
            }
            db = ((NAKACK)a.getProtocolStack().findProtocol(NAKACK.class)).getDigest();
            db = ((NAKACK)b.getProtocolStack().findProtocol(NAKACK.class)).getDigest();
            dc = ((NAKACK)c.getProtocolStack().findProtocol(NAKACK.class)).getDigest();
            System.out.println("(after purging)\nDigest A: " + da + "\nDigest B: " + db + "\nDigest C: " + dc);
            discard.removeIgnoredMember(b.getAddress());
            discard.removeIgnoredMember(c.getAddress());
            Address leader = b.getAddress();
            long end_time = System.currentTimeMillis() + 12000L;
            do {
                System.out.println("\n==== injecting merge event into " + leader + " ====");
                GMS_MergeTest.injectMergeEvent(channels, leader, "B", "A", "C");
                Util.sleep(3000L);
            } while (!GMS_MergeTest.allChannelsHaveView(channels, b.getView()) && end_time > System.currentTimeMillis());
            System.out.println("\n");
            GMS_MergeTest.print(channels);
            GMS_MergeTest.assertAllChannelsHaveView(channels, b.getView());
        }
        catch (Throwable throwable) {
            GMS_MergeTest.close(channels);
            throw throwable;
        }
        GMS_MergeTest.close(channels);
    }

    private static void applyView(JChannel[] channels, String member, String ... members) throws Exception {
        JChannel ch = GMS_MergeTest.findChannel(member, channels);
        View view = GMS_MergeTest.createView(members, channels);
        GMS gms = (GMS)ch.getProtocolStack().findProtocol(GMS.class);
        gms.installView(view);
    }

    private static boolean allChannelsHaveViewOf(JChannel[] channels, int count) {
        for (JChannel ch : channels) {
            if (ch.getView().size() == count) continue;
            return false;
        }
        return true;
    }

    private static boolean allChannelsHaveView(JChannel[] channels, View view) {
        for (JChannel ch : channels) {
            if (ch.getView().equals(view)) continue;
            return false;
        }
        return true;
    }

    private static void assertAllChannelsHaveView(JChannel[] channels, View view) {
        for (JChannel ch : channels) {
            View v = ch.getView();
            assert (v.equals(view)) : "expected view " + view + " but got " + v + " for channel " + ch.getName();
        }
    }

    private static void assertAllChannelsHaveViewOf(JChannel[] channels, int count) {
        for (JChannel ch : channels) {
            assert (ch.getView().size() == count) : ch.getName() + " has view " + ch.getView() + " (should have " + count + " mbrs)";
        }
    }

    private static void close(JChannel[] channels) {
        if (channels == null) {
            return;
        }
        for (int i = channels.length - 1; i >= 0; --i) {
            JChannel ch = channels[i];
            Util.close((Channel)ch);
        }
    }

    private static JChannel[] create(String props, boolean simple_ids, String cluster_name, String ... names) throws Exception {
        JChannel[] retval = new JChannel[names.length];
        for (int i = 0; i < retval.length; ++i) {
            JChannel ch;
            if (simple_ids) {
                ch = new MyChannel(props);
                ((MyChannel)ch).setId(i + 1);
            } else {
                ch = new JChannel(props);
            }
            ch.setName(names[i]);
            retval[i] = ch;
            ch.connect(cluster_name);
            if (i != 0) continue;
            Util.sleep(3000L);
        }
        return retval;
    }

    private static void createPartitions(JChannel[] channels, String[] ... partitions) throws Exception {
        GMS_MergeTest.checkUniqueness(partitions);
        ArrayList<View> views = new ArrayList<View>(partitions.length);
        for (String[] partition : partitions) {
            View view = GMS_MergeTest.createView(partition, channels);
            views.add(view);
        }
        GMS_MergeTest.applyViews(views, channels);
    }

    private static void injectMergeEvent(JChannel[] channels, String leader, String ... coordinators) {
        Address leader_addr = leader != null ? GMS_MergeTest.findAddress(leader, channels) : GMS_MergeTest.determineLeader(channels, new String[0]);
        GMS_MergeTest.injectMergeEvent(channels, leader_addr, coordinators);
    }

    private static void injectMergeEvent(JChannel[] channels, Address leader_addr, String ... coordinators) {
        HashMap<Address, View> views = new HashMap<Address, View>();
        for (String tmp : coordinators) {
            Address coord = GMS_MergeTest.findAddress(tmp, channels);
            views.put(coord, GMS_MergeTest.findView(tmp, channels));
        }
        JChannel coord = GMS_MergeTest.findChannel(leader_addr, channels);
        GMS gms = (GMS)coord.getProtocolStack().findProtocol(GMS.class);
        gms.setLevel("trace");
        gms.up(new Event(14, views));
    }

    private static Address determineLeader(JChannel[] channels, String ... coords) {
        Membership membership = new Membership();
        for (String coord : coords) {
            membership.add(GMS_MergeTest.findAddress(coord, channels));
        }
        membership.sort();
        return membership.elementAt(0);
    }

    private static String[][] generate(String[] ... partitions) {
        String[][] retval = new String[partitions.length][];
        System.arraycopy(partitions, 0, retval, 0, partitions.length);
        return retval;
    }

    private static void checkUniqueness(String[] ... partitions) throws Exception {
        HashSet<String> set = new HashSet<String>();
        String[][] arr$ = partitions;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] partition;
            for (String tmp : partition = arr$[i$]) {
                if (set.add(tmp)) continue;
                throw new Exception("partitions are overlapping: element " + tmp + " is in multiple partitions");
            }
        }
    }

    private static View createView(String[] partition, JChannel[] channels) throws Exception {
        Vector<Address> members = new Vector<Address>(partition.length);
        for (String tmp : partition) {
            Address addr = GMS_MergeTest.findAddress(tmp, channels);
            if (addr == null) {
                throw new Exception(tmp + " not associated with a channel");
            }
            members.add(addr);
        }
        return new View((Address)members.firstElement(), 10L, members);
    }

    private static void checkViews(JChannel[] channels, String channel_name, String ... members) {
        JChannel ch = GMS_MergeTest.findChannel(channel_name, channels);
        View view = ch.getView();
        assert (view.size() == members.length) : "view is " + view + ", members: " + Arrays.toString(members);
        for (String member : members) {
            Address addr = GMS_MergeTest.findAddress(member, channels);
            assert (view.getMembers().contains(addr)) : "view " + view + " does not contain " + addr;
        }
    }

    private static JChannel findChannel(String tmp, JChannel[] channels) {
        for (JChannel ch : channels) {
            if (!ch.getName().equals(tmp)) continue;
            return ch;
        }
        return null;
    }

    private static JChannel findChannel(Address addr, JChannel[] channels) {
        for (JChannel ch : channels) {
            if (!ch.getAddress().equals(addr)) continue;
            return ch;
        }
        return null;
    }

    private static Address findAddress(String tmp, JChannel[] channels) {
        for (JChannel ch : channels) {
            if (!ch.getName().equals(tmp)) continue;
            return ch.getAddress();
        }
        return null;
    }

    private static View findView(String tmp, JChannel[] channels) {
        for (JChannel ch : channels) {
            if (!ch.getName().equals(tmp)) continue;
            return ch.getView();
        }
        return null;
    }

    private static void applyViews(List<View> views, JChannel[] channels) {
        for (View view : views) {
            Vector<Address> members = view.getMembers();
            for (JChannel ch : channels) {
                Address addr = ch.getAddress();
                if (!members.contains(addr)) continue;
                GMS gms = (GMS)ch.getProtocolStack().findProtocol(GMS.class);
                gms.installView(view);
            }
        }
    }

    private static void print(JChannel[] channels) {
        for (JChannel ch : channels) {
            System.out.println(ch.getName() + ": " + ch.getView());
        }
    }

    static void waitForNumMessages(int num_msgs, long timeout, long interval, MyReceiver ... receivers) {
        long target_time = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < target_time) {
            boolean all_received = true;
            for (MyReceiver receiver : receivers) {
                if (receiver.getNumMsgs() >= num_msgs) continue;
                all_received = false;
                break;
            }
            if (all_received) break;
            Util.sleep(interval);
        }
    }

    static void checkMessages(int expected, MyReceiver ... receivers) {
        for (MyReceiver receiver : receivers) {
            System.out.println(receiver.name + ": " + receiver.getNumMsgs());
        }
        for (MyReceiver receiver : receivers) {
            assert (receiver.getNumMsgs() == expected) : "[" + MyReceiver.access$000(receiver) + "] expected " + expected + " msgs, but received " + receiver.getNumMsgs();
        }
    }

    private static class MyReceiver
    extends ReceiverAdapter {
        private final String name;
        private AtomicInteger num_msgs = new AtomicInteger(0);

        public MyReceiver(String name) {
            this.name = name;
        }

        public int getNumMsgs() {
            return this.num_msgs.get();
        }

        public void clear() {
            this.num_msgs.set(0);
        }

        public void receive(Message msg) {
            this.num_msgs.incrementAndGet();
        }

        public void viewAccepted(View new_view) {
            System.out.println("[" + this.name + "] view=" + new_view);
        }
    }

    private static class MyChannel
    extends JChannel {
        protected int id = 0;

        public MyChannel() throws ChannelException {
        }

        public MyChannel(File properties) throws ChannelException {
            super(properties);
        }

        public MyChannel(Element properties) throws ChannelException {
            super(properties);
        }

        public MyChannel(URL properties) throws ChannelException {
            super(properties);
        }

        public MyChannel(String properties) throws ChannelException {
            super(properties);
        }

        public MyChannel(ProtocolStackConfigurator configurator) throws ChannelException {
            super(configurator);
        }

        public MyChannel(JChannel ch) throws ChannelException {
            super(ch);
        }

        public void setId(int id) {
            this.id = id;
        }

        protected void setAddress() {
            UUID old_addr = this.local_addr;
            this.local_addr = new UUID(this.id, this.id);
            if (old_addr != null) {
                this.down(new Event(90, old_addr));
            }
            if (this.name == null || this.name.length() == 0) {
                this.name = Util.generateLocalName();
            }
            if (this.name != null && this.name.length() > 0) {
                UUID.add(this.local_addr, this.name);
            }
            Event evt = new Event(8, this.local_addr);
            this.down(evt);
            if (this.up_handler != null) {
                this.up_handler.up(evt);
            }
        }
    }
}

