/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.PingData;
import org.jgroups.stack.GossipData;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class GossipRouter {
    public static final byte CONNECT = 1;
    public static final byte DISCONNECT = 2;
    public static final byte GOSSIP_GET = 4;
    public static final byte SHUTDOWN = 9;
    public static final byte MESSAGE = 10;
    public static final byte SUSPECT = 11;
    public static final byte PING = 12;
    public static final byte CLOSE = 13;
    public static final int PORT = 12001;
    @ManagedAttribute(description="server port on which the GossipRouter accepts client connections", writable=true)
    private int port;
    @ManagedAttribute(description="address to which the GossipRouter should bind", writable=true, name="bindAddress")
    private String bindAddressString;
    private final ConcurrentMap<String, ConcurrentMap<Address, ConnectionHandler>> routingTable = new ConcurrentHashMap<String, ConcurrentMap<Address, ConnectionHandler>>();
    private final Map<Address, Set<PhysicalAddress>> address_mappings = new ConcurrentHashMap<Address, Set<PhysicalAddress>>();
    private ServerSocket srvSock = null;
    private InetAddress bindAddress = null;
    @Property(description="Time (in ms) for setting SO_LINGER on sockets returned from accept(). 0 means do not set SO_LINGER")
    private long linger_timeout = 2000L;
    @Property(description="Time (in ms) for SO_TIMEOUT on sockets returned from accept(). 0 means don't set SO_TIMEOUT")
    private long sock_read_timeout = 0L;
    @Property(description="The max queue size of backlogged connections")
    private int backlog = 1000;
    private final AtomicBoolean running = new AtomicBoolean(false);
    @ManagedAttribute(description="whether to discard message sent to self", writable=true)
    private boolean discard_loopbacks = false;
    protected List<ConnectionTearListener> connectionTearListeners = new CopyOnWriteArrayList<ConnectionTearListener>();
    protected ThreadFactory default_thread_factory = new DefaultThreadFactory(Util.getGlobalThreadGroup(), "gossip-handlers", true, true);
    protected final Log log = LogFactory.getLog(this.getClass());
    private boolean jmx = false;
    private boolean registered = false;

    public GossipRouter() {
        this(12001);
    }

    public GossipRouter(int port) {
        this(port, null);
    }

    public GossipRouter(int port, String bindAddressString) {
        this.port = port;
        this.bindAddressString = bindAddressString;
        this.connectionTearListeners.add(new FailureDetectionListener());
    }

    public GossipRouter(int port, String bindAddressString, boolean jmx) {
        this(port, bindAddressString);
        this.jmx = jmx;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddressString = bindAddress;
    }

    public String getBindAddress() {
        return this.bindAddressString;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    @Deprecated
    public void setExpiryTime(long expiryTime) {
    }

    @Deprecated
    public static long getExpiryTime() {
        return 0L;
    }

    @Deprecated
    public void setGossipRequestTimeout(long gossipRequestTimeout) {
    }

    @Deprecated
    public static long getGossipRequestTimeout() {
        return 0L;
    }

    @Deprecated
    public void setRoutingClientReplyTimeout(long routingClientReplyTimeout) {
    }

    @Deprecated
    public static long getRoutingClientReplyTimeout() {
        return 0L;
    }

    @ManagedAttribute(description="status")
    public boolean isStarted() {
        return this.isRunning();
    }

    public boolean isDiscardLoopbacks() {
        return this.discard_loopbacks;
    }

    public void setDiscardLoopbacks(boolean discard_loopbacks) {
        this.discard_loopbacks = discard_loopbacks;
    }

    public long getLingerTimeout() {
        return this.linger_timeout;
    }

    public void setLingerTimeout(long linger_timeout) {
        this.linger_timeout = linger_timeout;
    }

    public long getSocketReadTimeout() {
        return this.sock_read_timeout;
    }

    public void setSocketReadTimeout(long sock_read_timeout) {
        this.sock_read_timeout = sock_read_timeout;
    }

    public ThreadFactory getDefaultThreadPoolThreadFactory() {
        return this.default_thread_factory;
    }

    public static String type2String(int type) {
        switch (type) {
            case 1: {
                return "CONNECT";
            }
            case 2: {
                return "DISCONNECT";
            }
            case 4: {
                return "GOSSIP_GET";
            }
            case 9: {
                return "SHUTDOWN";
            }
            case 10: {
                return "MESSAGE";
            }
            case 11: {
                return "SUSPECT";
            }
            case 12: {
                return "PING";
            }
            case 13: {
                return "CLOSE";
            }
        }
        return "unknown (" + type + ")";
    }

    @ManagedOperation(description="Lifecycle operation. Called after create(). When this method is called, the managed attributes have already been set. Brings the Router into a fully functional state.")
    public void start() throws Exception {
        if (this.running.compareAndSet(false, true)) {
            if (this.jmx && !this.registered) {
                MBeanServer server = Util.getMBeanServer();
                JmxConfigurator.register(this, server, "jgroups:name=GossipRouter");
                this.registered = true;
            }
            if (this.bindAddressString != null) {
                this.bindAddress = InetAddress.getByName(this.bindAddressString);
                this.srvSock = new ServerSocket(this.port, this.backlog, this.bindAddress);
            } else {
                this.srvSock = new ServerSocket(this.port, this.backlog);
            }
        } else {
            throw new Exception("Router already started.");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                GossipRouter.this.stop();
            }
        });
        new Thread(new Runnable(){

            public void run() {
                GossipRouter.this.mainLoop();
            }
        }, "GossipRouter").start();
    }

    @ManagedOperation(description="Always called before destroy(). Closes connections and frees resources")
    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            Util.close(this.srvSock);
            for (ConcurrentMap map : this.routingTable.values()) {
                for (ConnectionHandler ce : map.values()) {
                    ce.close();
                }
            }
            this.routingTable.clear();
            if (this.log.isInfoEnabled()) {
                this.log.info("router stopped");
            }
        }
    }

    public void destroy() {
    }

    @ManagedAttribute(description="operational status", name="running")
    public boolean isRunning() {
        return this.running.get();
    }

    @ManagedOperation(description="dumps the contents of the routing table")
    public String dumpRoutingTable() {
        String label = "routing";
        StringBuilder sb = new StringBuilder();
        if (this.routingTable.isEmpty()) {
            sb.append("empty ").append(label).append(" table");
        } else {
            boolean first = true;
            for (Map.Entry entry : this.routingTable.entrySet()) {
                String gname = (String)entry.getKey();
                if (!first) {
                    sb.append("\n");
                } else {
                    first = false;
                }
                sb.append(gname + ": ");
                Map map = (Map)entry.getValue();
                if (map == null || map.isEmpty()) {
                    sb.append("null");
                    continue;
                }
                sb.append(Util.printListWithDelimiter(map.keySet(), ", "));
            }
        }
        return sb.toString();
    }

    @ManagedOperation(description="dumps the contents of the routing table")
    public String dumpRoutingTableDetailed() {
        String label = "routing";
        StringBuilder sb = new StringBuilder();
        if (this.routingTable.isEmpty()) {
            sb.append("empty ").append(label).append(" table");
        } else {
            boolean first = true;
            for (Map.Entry entry : this.routingTable.entrySet()) {
                String gname = (String)entry.getKey();
                if (!first) {
                    sb.append("\n");
                } else {
                    first = false;
                }
                sb.append(gname + ":\n");
                Map map = (Map)entry.getValue();
                if (map == null || map.isEmpty()) {
                    sb.append("null");
                } else {
                    for (Map.Entry en : map.entrySet()) {
                        sb.append(en.getKey() + ": ");
                        ConnectionHandler handler = (ConnectionHandler)en.getValue();
                        sb.append("sock=" + handler.sock).append("\n");
                    }
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @ManagedOperation(description="dumps the mappings between logical and physical addresses")
    public String dumpAddresssMappings() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Address, Set<PhysicalAddress>> entry : this.address_mappings.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    private void mainLoop() {
        if (this.bindAddress == null) {
            this.bindAddress = this.srvSock.getInetAddress();
        }
        this.printStartupInfo();
        while (this.isRunning()) {
            Socket sock = null;
            try {
                sock = this.srvSock.accept();
                if (this.linger_timeout > 0L) {
                    int linger = Math.max(1, (int)(this.linger_timeout / 1000L));
                    sock.setSoLinger(true, linger);
                }
                if (this.sock_read_timeout > 0L) {
                    sock.setSoTimeout((int)this.sock_read_timeout);
                }
                ConnectionHandler ch = new ConnectionHandler(sock);
                this.getDefaultThreadPoolThreadFactory().newThread(ch).start();
            }
            catch (IOException e) {
                if (!this.isRunning()) continue;
                this.log.error("failure handling connection from " + sock, e);
                Util.close(sock);
            }
        }
    }

    private void route(Address dest, String group, byte[] msg) {
        if (dest == null) {
            if (group == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("group is null");
                }
            } else {
                this.sendToAllMembersInGroup(group, msg);
            }
        } else {
            ConnectionHandler handler = this.findAddressEntry(group, dest);
            if (handler == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("cannot find " + dest + " in the routing table, \nrouting table=\n" + this.dumpRoutingTable());
                }
                return;
            }
            if (handler.output == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(dest + " is associated with a null output stream");
                }
                return;
            }
            try {
                GossipRouter.sendToMember(dest, handler.output, msg);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failed sending message to " + dest + ": " + e.getMessage());
                }
                this.removeEntry(group, dest);
            }
        }
    }

    private void removeEntry(String group, Address addr) {
        if (group != null) {
            ConcurrentMap map = (ConcurrentMap)this.routingTable.get(group);
            if (map != null && map.remove(addr) != null && map.isEmpty()) {
                this.routingTable.remove(group);
            }
        } else {
            for (Map.Entry entry : this.routingTable.entrySet()) {
                ConcurrentMap map = (ConcurrentMap)entry.getValue();
                if (map == null || map.remove(addr) == null || !map.isEmpty()) continue;
                this.routingTable.remove(entry.getKey());
            }
        }
        this.address_mappings.remove(addr);
        if (addr instanceof UUID) {
            UUID.remove((UUID)addr);
        }
    }

    private ConnectionHandler findAddressEntry(String group, Address addr) {
        if (group == null || addr == null) {
            return null;
        }
        ConcurrentMap map = (ConcurrentMap)this.routingTable.get(group);
        if (map == null) {
            return null;
        }
        return (ConnectionHandler)map.get(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToAllMembersInGroup(String group, byte[] msg) {
        ConcurrentMap map = (ConcurrentMap)this.routingTable.get(group);
        if (map == null || map.isEmpty()) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("didn't find any members for group " + group);
            }
            return;
        }
        ConcurrentMap concurrentMap = map;
        synchronized (concurrentMap) {
            for (Map.Entry entry : map.entrySet()) {
                ConnectionHandler handler = (ConnectionHandler)entry.getValue();
                DataOutputStream dos = handler.output;
                if (dos == null) continue;
                try {
                    GossipRouter.sendToMember(null, dos, msg);
                }
                catch (Exception e) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn("cannot send to " + entry.getKey() + ": " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendToMember(Address dest, DataOutputStream out, byte[] msg) throws IOException {
        if (out == null) {
            return;
        }
        DataOutputStream dataOutputStream = out;
        synchronized (dataOutputStream) {
            GossipData request = new GossipData(10, null, dest, msg);
            request.writeTo(out);
            out.flush();
        }
    }

    private void notifyAbnormalConnectionTear(ConnectionHandler ch, Exception e) {
        for (ConnectionTearListener l : this.connectionTearListeners) {
            l.connectionTorn(ch, e);
        }
    }

    private void printStartupInfo() {
        System.out.println("GossipRouter started at " + new Date());
        System.out.print("Listening on port " + this.port);
        System.out.println(" bound on address " + this.bindAddress);
        System.out.print("Backlog is " + this.backlog);
        System.out.print(", linger timeout is " + this.linger_timeout);
        System.out.println(", and read timeout is " + this.sock_read_timeout);
    }

    public static void main(String[] args) throws Exception {
        int port = 12001;
        int backlog = 0;
        long soLinger = -1L;
        long soTimeout = -1L;
        GossipRouter router = null;
        String bind_addr = null;
        boolean jmx = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-port".equals(arg)) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-bindaddress".equals(arg) || "-bind_addr".equals(arg)) {
                bind_addr = args[++i];
                continue;
            }
            if ("-backlog".equals(arg)) {
                backlog = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-expiry".equals(arg)) {
                System.err.println("-expiry has been deprecated and will be ignored");
                continue;
            }
            if ("-jmx".equals(arg)) {
                jmx = true;
                continue;
            }
            if ("-timeout".equals(arg)) {
                System.out.println("    -timeout is deprecated and will be ignored");
                ++i;
                continue;
            }
            if ("-rtimeout".equals(arg)) {
                System.out.println("    -rtimeout is deprecated and will be ignored");
                ++i;
                continue;
            }
            if ("-solinger".equals(arg)) {
                soLinger = Long.parseLong(args[++i]);
                continue;
            }
            if ("-sotimeout".equals(arg)) {
                soTimeout = Long.parseLong(args[++i]);
                continue;
            }
            GossipRouter.help();
            return;
        }
        System.out.println("GossipRouter is starting. CTRL-C to exit JVM");
        try {
            router = new GossipRouter(port, bind_addr, jmx);
            if (backlog > 0) {
                router.setBacklog(backlog);
            }
            if (soTimeout >= 0L) {
                router.setSocketReadTimeout(soTimeout);
            }
            if (soLinger >= 0L) {
                router.setLingerTimeout(soLinger);
            }
            router.start();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void help() {
        System.out.println();
        System.out.println("GossipRouter [-port <port>] [-bind_addr <address>] [options]");
        System.out.println();
        System.out.println("Options:");
        System.out.println();
        System.out.println("    -backlog <backlog>    - Max queue size of backlogged connections. Must be");
        System.out.println("                            greater than zero or the default of 1000 will be");
        System.out.println("                            used.");
        System.out.println();
        System.out.println("    -jmx                  - Expose attributes and operations via JMX.");
        System.out.println();
        System.out.println("    -solinger <msecs>     - Time for setting SO_LINGER on connections. 0");
        System.out.println("                            means do not set SO_LINGER. Must be greater than");
        System.out.println("                            or equal to zero or the default of 2000 will be");
        System.out.println("                            used.");
        System.out.println();
        System.out.println("    -sotimeout <msecs>    - Time for setting SO_TIMEOUT on connections. 0");
        System.out.println("                            means don't set SO_TIMEOUT. Must be greater than");
        System.out.println("                            or equal to zero or the default of 3000 will be");
        System.out.println("                            used.");
        System.out.println();
    }

    class ConnectionHandler
    implements Runnable {
        private final AtomicBoolean active = new AtomicBoolean(false);
        private final Socket sock;
        private final DataOutputStream output;
        private final DataInputStream input;
        private final List<Address> logical_addrs = new ArrayList<Address>();
        Set<String> known_groups = new HashSet<String>();

        public ConnectionHandler(Socket sock) throws IOException {
            this.sock = sock;
            this.input = new DataInputStream(sock.getInputStream());
            this.output = new DataOutputStream(sock.getOutputStream());
        }

        void close() {
            if (this.active.compareAndSet(true, false)) {
                Util.close(this.input);
                Util.close(this.output);
                Util.close(this.sock);
                for (Address addr : this.logical_addrs) {
                    GossipRouter.this.removeEntry(null, addr);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.active.compareAndSet(false, true)) {
                try {
                    this.readLoop();
                }
                finally {
                    this.close();
                }
            }
        }

        public boolean isRunning() {
            return this.active.get();
        }

        private void readLoop() {
            block15: while (this.isRunning()) {
                try {
                    GossipData request = new GossipData();
                    request.readFrom(this.input);
                    byte command = request.getType();
                    Address addr = request.getAddress();
                    String group = request.getGroup();
                    this.known_groups.add(group);
                    switch (command) {
                        case 1: {
                            String logical_name = request.getLogicalName();
                            if (logical_name != null && addr instanceof UUID) {
                                UUID.add((UUID)addr, logical_name);
                            }
                            this.logical_addrs.add(addr);
                            ConcurrentHashMap<Address, ConnectionHandler> map = (ConcurrentMap)GossipRouter.this.routingTable.get(group);
                            if (map == null) {
                                map = new ConcurrentHashMap<Address, ConnectionHandler>();
                                GossipRouter.this.routingTable.put(group, map);
                            }
                            map.put(addr, this);
                            if (request.getPhysicalAddresses() == null) break;
                            Set<PhysicalAddress> physical_addrs = (Set)GossipRouter.this.address_mappings.get(addr);
                            if (physical_addrs == null) {
                                physical_addrs = new HashSet<PhysicalAddress>();
                                GossipRouter.this.address_mappings.put(addr, physical_addrs);
                            }
                            physical_addrs.addAll(request.getPhysicalAddresses());
                            break;
                        }
                        case 12: {
                            break;
                        }
                        case 10: {
                            if (request.buffer == null || request.buffer.length == 0) {
                                if (!GossipRouter.this.log.isWarnEnabled()) break;
                                GossipRouter.this.log.warn("received null message");
                                break;
                            }
                            try {
                                GossipRouter.this.route(addr, request.getGroup(), request.getBuffer());
                            }
                            catch (Exception e) {
                                if (!GossipRouter.this.log.isErrorEnabled()) continue block15;
                                GossipRouter.this.log.error("failed routing request to " + addr, e);
                            }
                            break;
                        }
                        case 4: {
                            Set<PhysicalAddress> physical_addrs;
                            ArrayList<PingData> mbrs = new ArrayList<PingData>();
                            ConcurrentHashMap<Address, ConnectionHandler> map = (ConcurrentHashMap<Address, ConnectionHandler>)GossipRouter.this.routingTable.get(group);
                            if (map != null) {
                                for (Address logical_addr : map.keySet()) {
                                    physical_addrs = (HashSet<PhysicalAddress>)GossipRouter.this.address_mappings.get(logical_addr);
                                    PingData rsp = new PingData(logical_addr, null, true, UUID.get(logical_addr), physical_addrs != null ? new ArrayList(physical_addrs) : null);
                                    mbrs.add(rsp);
                                }
                            }
                            this.output.writeShort(mbrs.size());
                            for (PingData data : mbrs) {
                                data.writeTo(this.output);
                            }
                            this.output.flush();
                            break;
                        }
                        case 2: {
                            GossipRouter.this.removeEntry(request.getGroup(), request.getAddress());
                            break;
                        }
                        case 13: {
                            this.close();
                            break;
                        }
                        case -1: {
                            GossipRouter.this.notifyAbnormalConnectionTear(this, new EOFException("Connection broken"));
                        }
                    }
                }
                catch (SocketTimeoutException ste) {
                }
                catch (IOException ioex) {
                    GossipRouter.this.notifyAbnormalConnectionTear(this, ioex);
                    break;
                }
                catch (Exception ex) {
                    if (!this.active.get() || !GossipRouter.this.log.isWarnEnabled()) break;
                    GossipRouter.this.log.warn("Exception in ConnectionHandler thread", ex);
                    break;
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("peer: " + this.sock.getInetAddress());
            if (!this.logical_addrs.isEmpty()) {
                sb.append(", logical_addrs: " + Util.printListWithDelimiter(this.logical_addrs, ", "));
            }
            return sb.toString();
        }
    }

    class FailureDetectionListener
    implements ConnectionTearListener {
        FailureDetectionListener() {
        }

        public void connectionTorn(ConnectionHandler ch, Exception e) {
            Set<String> groups = ch.known_groups;
            for (String group : groups) {
                Map map;
                if (group == null || (map = (Map)GossipRouter.this.routingTable.get(group)) == null || map.isEmpty()) continue;
                Iterator i = map.entrySet().iterator();
                while (i.hasNext()) {
                    ConnectionHandler entry = (ConnectionHandler)i.next().getValue();
                    DataOutputStream stream = entry.output;
                    try {
                        for (Address a : ch.logical_addrs) {
                            GossipData suspect = new GossipData(11);
                            suspect.writeTo(stream);
                            Util.writeAddress(a, stream);
                            stream.flush();
                        }
                    }
                    catch (Exception ioe) {
                    }
                }
            }
        }
    }

    public static interface ConnectionTearListener {
        public void connectionTorn(ConnectionHandler var1, Exception var2);
    }
}

