/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.concurrent.CyclicBarrier;
import org.jgroups.Channel;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class ConcurrentCloseTest
extends ChannelTestBase {
    JChannel c1;
    JChannel c2;

    @AfterMethod
    void tearDown() throws Exception {
        Util.close(this.c2, this.c1);
    }

    public void testConcurrentClose() throws Exception {
        System.setProperty("useBlocking", "true");
        this.c1 = this.createChannel(true);
        this.c1.setReceiver(new MyReceiver("C1"));
        this.c2 = this.createChannel(this.c1);
        this.c2.setReceiver(new MyReceiver("C2"));
        String GROUP = ConcurrentCloseTest.getUniqueClusterName("ConcurrentCloseTest");
        this.c1.connect(GROUP);
        this.c2.connect(GROUP);
        CyclicBarrier barrier = new CyclicBarrier(3);
        Closer one = new Closer(this.c1, barrier);
        Closer two = new Closer(this.c2, barrier);
        one.start();
        two.start();
        Util.sleep(500L);
        barrier.await();
        one.join(10000L);
        two.join(10000L);
        ConcurrentCloseTest.assertFalse(one.isAlive());
        ConcurrentCloseTest.assertFalse(two.isAlive());
    }

    private static class MyReceiver
    extends ExtendedReceiverAdapter {
        private final String name;

        public MyReceiver(String name) {
            this.name = name;
        }

        public void block() {
            System.out.println("[" + this.name + "] block()");
        }

        public void unblock() {
            System.out.println("[" + this.name + "] unblock()");
        }

        public void viewAccepted(View new_view) {
            System.out.println("[" + this.name + "] " + new_view);
        }

        public void receive(Message msg) {
            System.out.println("[" + this.name + "] " + msg);
        }
    }

    private static class Closer
    extends Thread {
        private final Channel channel;
        private final CyclicBarrier barrier;

        public Closer(Channel channel, CyclicBarrier barrier) {
            this.channel = channel;
            this.barrier = barrier;
        }

        public void run() {
            try {
                this.barrier.await();
                System.out.println("closing channel for " + this.channel.getAddress());
                this.channel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

