/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import org.jgroups.util.Util;

public class RelayTest {
    private ServerSocket srv_sock;
    private Socket sock;
    private InetAddress local_addr = null;
    private InetAddress remote_addr = null;
    private OutputStream remote_out = null;
    private InputStream remote_in = null;
    private int local_port = 5000;
    private int remote_port = 5000;
    private int size = 1000000;
    private State state = null;
    private static final int CHUNK_SIZE = 60000;

    private void start(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-local_addr")) {
                this.local_addr = InetAddress.getByName(args[++i]);
                continue;
            }
            if (args[i].equals("-addr")) {
                this.remote_addr = InetAddress.getByName(args[++i]);
                continue;
            }
            if (args[i].equals("-local_port")) {
                this.local_port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-port")) {
                this.remote_port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-size")) {
                this.size = Integer.parseInt(args[++i]);
                continue;
            }
            RelayTest.help();
            return;
        }
        if (this.local_addr != null) {
            this.srv_sock = new ServerSocket(this.local_port, 0, this.local_addr);
        }
        if (this.remote_addr != null) {
            this.sock = new Socket(this.remote_addr, this.remote_port);
            this.remote_out = this.sock.getOutputStream();
            this.remote_in = this.sock.getInputStream();
        }
        if (this.local_addr != null) {
            System.out.println("local_addr: " + this.local_addr + ":" + this.local_port);
        }
        if (this.remote_addr != null) {
            System.out.println("remote_addr: " + this.remote_addr + ":" + this.remote_port);
        }
        this.sanityCheck();
        System.out.println("state = " + (Object)((Object)this.state));
        switch (this.state) {
            case sender: {
                this.loop();
                break;
            }
            case terminator: 
            case forwarder: {
                this.handleInput();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInput() throws IOException {
        Socket client_sock = null;
        InputStream inp = null;
        OutputStream out = null;
        byte[] buf = new byte[60000];
        int cnt = 0;
        while ((client_sock = this.srv_sock.accept()) != null) {
            try {
                int tmp;
                inp = client_sock.getInputStream();
                out = client_sock.getOutputStream();
                while ((tmp = inp.read(buf, 0, buf.length)) != -1) {
                    cnt += tmp;
                    if (this.state == State.forwarder) {
                        this.remote_out.write(buf, 0, tmp);
                    }
                    if (cnt < this.size) continue;
                    if (this.state == State.terminator) {
                        System.out.println("received " + Util.printBytes(cnt) + " at " + new Date());
                    } else {
                        this.remote_in.read();
                    }
                    cnt = 0;
                    out.write(49);
                    out.flush();
                }
            }
            finally {
                client_sock.close();
            }
        }
    }

    private void loop() throws IOException {
        block5: while (true) {
            System.out.println("[1] send " + Util.printBytes(this.size) + " data [x] Exit");
            int ch = System.in.read();
            switch (ch) {
                case -1: {
                    continue block5;
                }
                case 88: 
                case 120: {
                    continue block5;
                }
                case 49: {
                    this.send();
                    continue block5;
                }
            }
        }
    }

    private void send() throws IOException {
        int cnt = 0;
        byte[] buf = new byte[60000];
        System.out.println("-- sending " + Util.printBytes(this.size) + " to " + this.remote_addr + ":" + this.remote_port);
        long start = System.currentTimeMillis();
        while (cnt + 60000 < this.size) {
            this.remote_out.write(buf, 0, buf.length);
            cnt += 60000;
        }
        if (cnt < this.size) {
            this.remote_out.write(buf, 0, this.size - cnt);
        }
        this.remote_out.flush();
        this.remote_in.read();
        long diff = System.currentTimeMillis() - start;
        System.out.println("sent " + Util.printBytes(this.size) + " in " + diff + " ms");
    }

    private void sanityCheck() {
        if (this.srv_sock == null && this.sock != null) {
            this.state = State.sender;
        } else if (this.srv_sock != null && this.sock == null) {
            this.state = State.terminator;
        } else if (this.srv_sock != null && this.sock != null) {
            this.state = State.forwarder;
        } else {
            throw new IllegalStateException("either server socket or socket has to be non-null");
        }
    }

    public static void main(String[] args) throws Exception {
        new RelayTest().start(args);
    }

    static void help() {
        System.out.println("RelayTest [-help] [-local_addr <bind addr>] [-local_port <port>] [-addr <remote address>] [-port <remote port>] [-size <num bytes to send/forward>]");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        sender,
        forwarder,
        terminator;

    }
}

