/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.protocols.UNICAST;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.AgeOutCache;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class UnicastEnableToTest
extends ChannelTestBase {
    private JChannel c1 = null;
    private JChannel c2 = null;
    private static final String GROUP = "UnicastEnableToTest";
    AgeOutCache cache;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.c1 = this.createChannel(true);
        this.c1.connect(GROUP);
        UNICAST ucast = (UNICAST)this.c1.getProtocolStack().findProtocol(UNICAST.class);
        AgeOutCache<Address> ageOutCache = this.cache = ucast != null ? ucast.getAgeOutCache() : null;
        if (this.cache != null) {
            this.cache.setTimeout(1000L);
        }
    }

    @AfterMethod
    protected void tearDown() throws Exception {
        Util.close(this.c2, this.c1);
    }

    public void testUnicastMessageToUnknownMember() throws Exception {
        UUID addr = UUID.randomUUID();
        System.out.println("sending message to non-existing destination " + addr);
        this.c1.send(new Message((Address)addr, null, (Serializable)((Object)"Hello world")));
        if (this.cache != null) {
            System.out.println("age out cache:\n" + this.cache);
            assert (this.cache.size() == 1);
        }
        Util.sleep(1500L);
        if (this.cache != null) assert (this.cache.size() == 0);
    }

    public void testUnicastMessageToExistingMember() throws Exception {
        this.c2 = this.createChannel(this.c1);
        this.c2.connect(GROUP);
        assert (2 == this.c2.getView().size()) : " view=" + this.c2.getView();
        MyReceiver receiver = new MyReceiver();
        this.c2.setReceiver(receiver);
        Address dest = this.c2.getAddress();
        this.c1.send(new Message(dest, null, (Serializable)((Object)"hello")));
        if (this.cache != null) {
            System.out.println("age out cache:\n" + this.cache);
            assert (this.cache.size() == 0);
        }
        Util.sleep(500L);
        List<Message> list = receiver.getMsgs();
        System.out.println("channel2 received the following msgs: " + list);
        assert (1 == list.size());
        receiver.reset();
    }

    public void testUnicastMessageToLeftMember() throws Exception {
        this.c2 = this.createChannel(this.c1);
        this.c2.connect(GROUP);
        assert (2 == this.c2.getView().size()) : "view=" + this.c2.getView();
        Address dest = this.c2.getAddress();
        this.c2.close();
        Util.sleep(100L);
        this.c1.send(new Message(dest, null, (Serializable)((Object)"hello")));
        if (this.cache != null) {
            System.out.println("age out cache:\n" + this.cache);
            assert (this.cache.size() == 1);
        }
        Util.sleep(1500L);
        if (this.cache != null) assert (this.cache.size() == 0) : "cache size is " + this.cache.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReceiver
    extends ExtendedReceiverAdapter {
        List<Message> msgs = Collections.synchronizedList(new LinkedList());

        private MyReceiver() {
        }

        @Override
        public void receive(Message msg) {
            this.msgs.add(msg);
        }

        List<Message> getMsgs() {
            return this.msgs;
        }

        void reset() {
            this.msgs.clear();
        }
    }
}

